/*
 * Decompiled with CFR 0.152.
 */
package org.w3.atom;

import nu.xom.Attribute;
import nu.xom.Element;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.ContentType;

public class TextConstruct
extends XmlElement
implements SwordElementInterface {
    private String content;
    private ContentType type;

    public TextConstruct(String prefix, String name) {
        super(prefix, name);
    }

    public TextConstruct(String name) {
        super(name);
        this.type = ContentType.TEXT;
    }

    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.type != null) {
            Attribute typeAttribute = new Attribute("type", this.type.toString());
            element.addAttribute(typeAttribute);
        }
        if (this.content != null) {
            element.appendChild(this.content);
        }
        return element;
    }

    public void unmarshall(Element text) throws UnmarshallException {
        if (!this.isInstanceOf(text, this.localName, "http://www.w3.org/2005/Atom")) {
            throw new UnmarshallException("Not a " + this.getQualifiedName() + " element");
        }
        try {
            int attributeCount = text.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = text.getAttribute(i);
                if (!"type".equals(attribute.getQualifiedName())) continue;
                String value = attribute.getValue();
                if (ContentType.TEXT.toString().equals(value)) {
                    this.type = ContentType.TEXT;
                    continue;
                }
                if (ContentType.HTML.toString().equals(value)) {
                    this.type = ContentType.HTML;
                    continue;
                }
                if (ContentType.XHTML.toString().equals(value)) {
                    this.type = ContentType.XHTML;
                    continue;
                }
                InfoLogger.getLogger().writeError("Unable to parse extract type in " + this.getQualifiedName());
            }
            int length = text.getChildCount();
            if (length > 0) {
                this.content = this.unmarshallString(text);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in " + this.getQualifiedName() + ": " + ex.getMessage());
            throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        this.type = type;
    }
}

