/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.text.ParseException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword.DSpaceSWORDException;
import org.purl.sword.base.SWORDEntry;
import org.w3.atom.Author;
import org.w3.atom.Content;
import org.w3.atom.ContentType;
import org.w3.atom.Contributor;
import org.w3.atom.Generator;
import org.w3.atom.InvalidMediaTypeException;
import org.w3.atom.Link;
import org.w3.atom.Rights;
import org.w3.atom.Source;
import org.w3.atom.Summary;
import org.w3.atom.Title;

public class DSpaceATOMEntry {
    protected SWORDEntry entry;
    protected Item item;

    public SWORDEntry getSWORDEntry(Item item, String handle, boolean noOp) throws DSpaceSWORDException {
        this.entry = new SWORDEntry();
        this.item = item;
        this.addAuthors();
        this.addCategories();
        this.addContentElement(handle, noOp);
        this.addContributors();
        if (!noOp) {
            this.addIdentifier(handle, noOp);
        }
        this.addLinks(handle);
        this.addPublishDate();
        this.addRights(handle);
        this.addSource();
        this.addSummary();
        this.addTitle();
        this.addLastUpdatedDate();
        this.setFormatNamespace();
        return this.entry;
    }

    protected void addAuthors() {
        DCValue[] dcv = this.item.getMetadata("dc.contributor.author");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Author author = new Author();
                author.setName(dcv[i].value);
                this.entry.addAuthors(author);
            }
        }
    }

    protected void addCategories() {
        DCValue[] dcv = this.item.getMetadata("dc.subject.*");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                this.entry.addCategory(dcv[i].value);
            }
        }
    }

    protected void addContentElement(String handle, boolean noOp) {
        try {
            if (!noOp) {
                if (this.item.getHandle() != null) {
                    handle = this.item.getHandle();
                }
                if (handle != null && !"".equals(handle)) {
                    Content content = new Content();
                    content.setType("text/html");
                    content.setSource(HandleManager.getCanonicalForm((String)handle));
                    this.entry.setContent(content);
                }
            }
        }
        catch (InvalidMediaTypeException invalidMediaTypeException) {
            // empty catch block
        }
    }

    protected void addContributors() {
        DCValue[] dcv = this.item.getMetadata("dc.contributor.*");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Contributor cont = new Contributor();
                cont.setName(dcv[i].value);
                this.entry.addContributor(cont);
            }
        }
    }

    protected void addIdentifier(String handle, boolean noOp) {
        if (!noOp) {
            if (this.item.getHandle() != null) {
                handle = this.item.getHandle();
            }
            if (handle != null && !"".equals(handle)) {
                this.entry.setId(HandleManager.getCanonicalForm((String)handle));
                return;
            }
        }
        String cfg = ConfigurationManager.getProperty((String)"dspace.url");
        this.entry.setId(cfg);
    }

    protected void addLinks(String handle) throws DSpaceSWORDException {
        try {
            if (handle == null) {
                return;
            }
            String base = ConfigurationManager.getProperty((String)"dspace.url");
            Bundle[] bundles = this.item.getBundles("ORIGINAL");
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bss = bundles[i].getBitstreams();
                for (int j = 0; j < bss.length; ++j) {
                    Link link = new Link();
                    String url = base + "/bitstream/" + handle + "/" + bss[j].getSequenceID() + "/" + bss[j].getName();
                    link.setHref(url);
                    this.entry.addLink(link);
                }
            }
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    protected void addPublishDate() {
        try {
            DCValue[] dcv = this.item.getMetadata("dc.date.issued");
            if (dcv != null && dcv.length == 1) {
                this.entry.setPublished(dcv[0].value);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void addRights(String handle) {
        try {
            if (handle == null) {
                return;
            }
            String base = ConfigurationManager.getProperty((String)"dspace.url");
            if (base == null) {
                return;
            }
            StringBuilder rightsString = new StringBuilder();
            Bundle[] bundles = this.item.getBundles("LICENSE");
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bss = bundles[i].getBitstreams();
                for (int j = 0; j < bss.length; ++j) {
                    String url = base + "/bitstream/" + handle + "/" + bss[j].getSequenceID() + "/" + bss[j].getName();
                    rightsString.append(url + " ");
                }
            }
            Rights rights = new Rights();
            rights.setContent(rightsString.toString());
            rights.setType(ContentType.TEXT);
            this.entry.setRights(rights);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void addSource() {
        String base = ConfigurationManager.getProperty((String)"dspace.url");
        String name = ConfigurationManager.getProperty((String)"dspace.name");
        Source source = new Source();
        Generator gen = new Generator();
        gen.setUri(base);
        gen.setContent(name);
        source.setGenerator(gen);
        this.entry.setSource(source);
    }

    protected void addSummary() {
        DCValue[] dcv = this.item.getMetadata("dc.description.abstract");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Summary summary = new Summary();
                summary.setContent(dcv[i].value);
                summary.setType(ContentType.TEXT);
                this.entry.setSummary(summary);
            }
        }
    }

    protected void addTitle() {
        DCValue[] dcv = this.item.getMetadata("dc.title");
        if (dcv != null) {
            for (int i = 0; i < dcv.length; ++i) {
                Title title = new Title();
                title.setContent(dcv[i].value);
                title.setType(ContentType.TEXT);
                this.entry.setTitle(title);
            }
        }
    }

    protected void addLastUpdatedDate() {
        try {
            String config = ConfigurationManager.getProperty((String)"sword.updated.field");
            DCValue[] dcv = this.item.getMetadata(config);
            if (dcv != null && dcv.length == 1) {
                DCDate dcd = new DCDate(dcv[0].value);
                this.entry.setUpdated(dcd.toString());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void setFormatNamespace() {
        this.entry.setFormatNamespace("http://www.log.gov/METS");
    }
}

