/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword.CollectionLocation;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDIngester;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.purl.sword.base.Deposit;

public class SWORDMETSIngester
implements SWORDIngester {
    public static Logger log = Logger.getLogger(SWORDMETSIngester.class);
    private StringBuilder verboseDesc = new StringBuilder();
    private boolean verbose = false;

    public DepositResult ingest(Context context, Deposit deposit) throws DSpaceSWORDException {
        try {
            this.verbose = deposit.isVerbose();
            InputStream is = deposit.getFile();
            String loc = deposit.getLocation();
            CollectionLocation cl = new CollectionLocation();
            Collection collection = cl.getCollection(context, loc);
            this.message("Performing deposit using location: " + loc + "; ");
            this.message("Location resolves to collection with handle: " + collection.getHandle() + " and name: " + collection.getMetadata("name") + "; ");
            String cfg = ConfigurationManager.getProperty((String)"sword.mets-ingester.package-ingester");
            if (cfg == null || "".equals(cfg)) {
                cfg = "METS";
            }
            this.message("Using package manifest format: " + cfg);
            PackageIngester pi = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)cfg);
            String licence = null;
            PackageParameters params = new PackageParameters();
            WorkspaceItem wsi = pi.ingest(context, collection, is, params, licence);
            if (wsi == null) {
                this.message("Failed to ingest the package; throwing exception");
                throw new DSpaceSWORDException("Package Ingest failed");
            }
            WorkflowItem wfi = WorkflowManager.startWithoutNotify((Context)context, (WorkspaceItem)wsi);
            Item installedItem = wfi.getItem();
            this.setUpdatedDate(installedItem);
            this.setSlug(installedItem, deposit.getSlug());
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            installedItem.update();
            context.setIgnoreAuthorization(ignore);
            String handle = HandleManager.findHandle((Context)context, (DSpaceObject)installedItem);
            this.message("Ingest successful; ");
            this.message("Item created with internal identifier: " + installedItem.getID() + "; ");
            if (handle != null) {
                this.message("Item created with external identifier: " + handle + "; ");
            } else {
                this.message("No external identifier available at this stage (item in workflow); ");
            }
            DepositResult dr = new DepositResult();
            dr.setItem(installedItem);
            dr.setHandle(handle);
            dr.setVerboseDescription(this.verboseDesc.toString());
            return dr;
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    private void message(String msg) {
        if (this.verbose) {
            this.verboseDesc.append("\n\n");
            this.verboseDesc.append(msg);
        }
    }

    private void setUpdatedDate(Item item) throws DSpaceSWORDException {
        String field = ConfigurationManager.getProperty((String)"sword.updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        DCValue dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        DCDate date = new DCDate(new Date());
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, date.toString());
    }

    private void setSlug(Item item, String slugVal) throws DSpaceSWORDException {
        if (slugVal == null) {
            return;
        }
        String field = ConfigurationManager.getProperty((String)"sword.slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        DCValue dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, slugVal);
    }

    private DCValue configToDC(String config, String def) {
        DCValue dcv = new DCValue();
        dcv.schema = def;
        dcv.element = def;
        dcv.qualifier = def;
        StringTokenizer stz = new StringTokenizer(config, ".");
        dcv.schema = stz.nextToken();
        dcv.element = stz.nextToken();
        if (stz.hasMoreTokens()) {
            dcv.qualifier = stz.nextToken();
        }
        return dcv;
    }
}

