/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.ServiceLevel;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.Workspace;
import org.purl.sword.base.XmlElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends XmlElement
implements SwordElementInterface {
    private static final String ELEMENT_NAME = "service";
    private ServiceLevel complianceLevel;
    private boolean noOp;
    private boolean isNoOp = false;
    private boolean verbose;
    private boolean isVerbose = false;
    private List<Workspace> workspaces = new ArrayList<Workspace>();

    public Service() {
        super("app");
        this.complianceLevel = ServiceLevel.UNDEFINED;
    }

    public Service(ServiceLevel complianceLevel) {
        this();
        this.complianceLevel = complianceLevel;
    }

    public Service(ServiceLevel complianceLevel, boolean noOp, boolean verbose) {
        this();
        this.complianceLevel = complianceLevel;
        this.setNoOp(noOp);
        this.setVerbose(verbose);
    }

    public ServiceLevel getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setComplianceLevel(ServiceLevel complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
        this.isNoOp = true;
    }

    public boolean isNoOpSet() {
        return this.isNoOp;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.isVerbose = true;
    }

    public boolean isVerboseSet() {
        return this.isVerbose;
    }

    public Iterator<Workspace> getWorkspaces() {
        return this.workspaces.iterator();
    }

    public List<Workspace> getWorkspacesList() {
        return this.workspaces;
    }

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public void clearWorkspaces() {
        this.workspaces.clear();
    }

    @Override
    public Element marshall() {
        Element service = new Element(ELEMENT_NAME, "http://purl.org/atom/app#");
        service.addNamespaceDeclaration("atom", "http://www.w3.org/2005/Atom");
        service.addNamespaceDeclaration("dcterms", "http://purl.org/dc/terms/");
        service.addNamespaceDeclaration("sword", "http://purl.org/net/sword/");
        if (this.complianceLevel != ServiceLevel.UNDEFINED) {
            Element compliance = new Element("sword:level", "http://purl.org/net/sword/");
            compliance.appendChild(Integer.toString(this.complianceLevel.number()));
            service.appendChild((Node)compliance);
        }
        if (this.isVerboseSet()) {
            Element verboseElement = new Element("sword:verbose", "http://purl.org/net/sword/");
            verboseElement.appendChild(Boolean.toString(this.verbose));
            service.appendChild((Node)verboseElement);
        }
        if (this.isNoOpSet()) {
            Element noOpElement = new Element("sword:noOp", "http://purl.org/net/sword/");
            noOpElement.appendChild(Boolean.toString(this.noOp));
            service.appendChild((Node)noOpElement);
        }
        for (Workspace item : this.workspaces) {
            service.appendChild((Node)item.marshall());
        }
        return service;
    }

    private ServiceLevel getServiceLevel(int level) {
        ServiceLevel theLevel = ServiceLevel.UNDEFINED;
        switch (level) {
            case 0: {
                theLevel = ServiceLevel.ZERO;
                break;
            }
            case 1: {
                theLevel = ServiceLevel.ONE;
                break;
            }
            default: {
                theLevel = ServiceLevel.UNDEFINED;
                InfoLogger.getLogger().writeError("Invalid value for sword:level");
            }
        }
        return theLevel;
    }

    @Override
    public void unmarshall(Element service) throws UnmarshallException {
        if (!this.isInstanceOf(service, ELEMENT_NAME, "http://purl.org/atom/app#")) {
            throw new UnmarshallException("Not an app:service element");
        }
        try {
            this.workspaces.clear();
            Elements elements = service.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, "level", "http://purl.org/net/sword/")) {
                    int level = this.unmarshallInteger(element);
                    this.complianceLevel = this.getServiceLevel(level);
                    continue;
                }
                if (this.isInstanceOf(element, "verbose", "http://purl.org/net/sword/")) {
                    this.setVerbose(this.unmarshallBoolean(element));
                    continue;
                }
                if (this.isInstanceOf(element, "noOp", "http://purl.org/net/sword/")) {
                    this.setNoOp(this.unmarshallBoolean(element));
                    continue;
                }
                if (!this.isInstanceOf(element, "workspace", "http://purl.org/atom/app#")) continue;
                Workspace workspace = new Workspace();
                workspace.unmarshall(element);
                this.workspaces.add(workspace);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in Service: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse element in Service", ex);
        }
    }
}

