/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.purl.sword.base.Collection;
import org.purl.sword.base.InfoLogger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.w3.atom.ContentType;
import org.w3.atom.Title;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends XmlElement
implements SwordElementInterface {
    public static final String ELEMENT_NAME = "workspace";
    private Title title;
    private List<Collection> collections;

    public Workspace() {
        this(null);
    }

    public Workspace(String title) {
        super("app", ELEMENT_NAME);
        this.setTitle(title);
        this.collections = new ArrayList<Collection>();
    }

    public void setTitle(String title) {
        if (this.title == null) {
            this.title = new Title();
        }
        this.title.setContent(title);
        this.title.setType(ContentType.TEXT);
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getContent();
    }

    public void addCollection(Collection collection) {
        this.collections.add(collection);
    }

    public Iterator<Collection> collectionIterator() {
        return this.collections.iterator();
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    @Override
    public Element marshall() {
        Element workspace = new Element(ELEMENT_NAME, "http://purl.org/atom/app#");
        workspace.appendChild((Node)this.title.marshall());
        for (Collection item : this.collections) {
            workspace.appendChild((Node)item.marshall());
        }
        return workspace;
    }

    @Override
    public void unmarshall(Element workspace) throws UnmarshallException {
        if (!this.isInstanceOf(workspace, ELEMENT_NAME, "http://purl.org/atom/app#")) {
            throw new UnmarshallException("Not an app:workspace element");
        }
        try {
            this.collections.clear();
            Elements elements = workspace.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, "title", "http://www.w3.org/2005/Atom")) {
                    this.title = new Title();
                    this.title.unmarshall(element);
                    continue;
                }
                if (!this.isInstanceOf(element, "collection", "http://purl.org/atom/app#")) continue;
                Collection collection = new Collection();
                collection.unmarshall(element);
                this.collections.add(collection);
            }
        }
        catch (Exception ex) {
            InfoLogger.getLogger().writeError("Unable to parse an element in workspace: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse element in workspace.", ex);
        }
    }
}

