/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.purl.sword.base.ChecksumUtils;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDContentTypeException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.server.SWORDServer;

public class DepositServlet
extends HttpServlet {
    private SWORDServer myRepository;
    private String authN;
    private String tempDirectory;
    private static AtomicInteger counter = new AtomicInteger(0);
    private static Logger log = Logger.getLogger(DepositServlet.class);

    public void init() {
        String className = this.getServletContext().getInitParameter("sword-server-class");
        if (className == null) {
            log.fatal((Object)"Unable to read value of 'sword-server-class' from Servlet context");
        } else {
            try {
                this.myRepository = (SWORDServer)Class.forName(className).newInstance();
                log.info((Object)("Using " + className + " as the SWORDServer"));
            }
            catch (Exception e) {
                log.fatal((Object)("Unable to instantiate class from 'sword-server-class': " + className));
            }
        }
        this.authN = this.getServletContext().getInitParameter("authentication-method");
        if (this.authN == null || this.authN.equals("")) {
            this.authN = "None";
        }
        log.info((Object)("Authentication type set to: " + this.authN));
        this.tempDirectory = this.getServletContext().getInitParameter("upload-temp-directory");
        if (this.tempDirectory == null || this.tempDirectory.equals("")) {
            this.tempDirectory = System.getProperty("java.io.tmpdir");
        }
        File tempDir = new File(this.tempDirectory);
        log.info((Object)("Upload temporary directory set to: " + tempDir));
        if (!tempDir.isDirectory()) {
            log.fatal((Object)("Upload temporary directory is not a directory: " + tempDir));
        }
        if (!tempDir.canWrite()) {
            log.fatal((Object)("Upload temporary directory cannot be written to: " + tempDir));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(501);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Deposit d = new Deposit();
        Date date = new Date();
        log.debug((Object)("Starting deposit processing at " + date.toString() + " by " + request.getRemoteAddr()));
        String usernamePassword = this.getUsernamePassword(request);
        if (usernamePassword != null && !usernamePassword.equals("")) {
            int p = usernamePassword.indexOf(":");
            if (p != -1) {
                d.setUsername(usernamePassword.substring(0, p));
                d.setPassword(usernamePassword.substring(p + 1));
            }
        } else if (this.authenticateWithBasic()) {
            String s = "Basic realm=\"SWORD\"";
            response.setHeader("WWW-Authenticate", s);
            response.setStatus(401);
            return;
        }
        try {
            int data;
            String filename = this.tempDirectory + "SWORD-" + request.getRemoteAddr() + "-" + counter.addAndGet(1);
            ServletInputStream inputStream = request.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(filename);
            while ((data = inputStream.read()) != -1) {
                ((OutputStream)outputStream).write(data);
            }
            inputStream.close();
            ((OutputStream)outputStream).close();
            String receivedMD5 = ChecksumUtils.generateMD5(filename);
            log.debug((Object)("Received filechecksum: " + receivedMD5));
            d.setMd5(receivedMD5);
            String md5 = request.getHeader("Content-MD5");
            log.debug((Object)("Received file checksum header: " + md5));
            if (md5 != null && !md5.equals(receivedMD5)) {
                response.sendError(412);
                response.setHeader("X-Error-Code", "ErrorChecksumMismatch");
                log.debug((Object)"Bad MD5 for file. Aborting with appropriate error message");
            } else {
                File f = new File(filename);
                FileInputStream fis = new FileInputStream(f);
                d.setFile(fis);
                d.setOnBehalfOf(request.getHeader("X-On-Behalf-Of".toString()));
                d.setFormatNamespace(request.getHeader("X-Format-Namespace"));
                String noop = request.getHeader("X-No-Op");
                if (noop != null && noop.equals("true")) {
                    d.setNoOp(true);
                } else {
                    d.setNoOp(false);
                }
                String verbose = request.getHeader("X-Verbose");
                if (verbose != null && verbose.equals("true")) {
                    d.setVerbose(true);
                } else {
                    d.setVerbose(false);
                }
                String slug = request.getHeader("Slug");
                if (slug != null) {
                    d.setSlug(slug);
                }
                d.setFilename(request.getHeader("Content-Disposition"));
                d.setIPAddress(request.getRemoteAddr());
                d.setLocation(DepositServlet.getUrl(request));
                d.setContentType(request.getContentType());
                String cl = request.getHeader("Content-Length");
                if (cl != null && !cl.equals("")) {
                    d.setContentLength(Integer.parseInt(cl));
                }
                DepositResponse dr = this.myRepository.doDeposit(d);
                response.setStatus(dr.getHttpResponse());
                response.setContentType("application/atom+xml; charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.write(dr.marshall());
                out.flush();
                fis.close();
                f = new File(filename);
                f.delete();
            }
        }
        catch (SWORDAuthenticationException sae) {
            if (this.authN.equals("Basic")) {
                String s = "Basic realm=\"SWORD\"";
                response.setHeader("WWW-Authenticate", s);
                response.setStatus(401);
            }
        }
        catch (SWORDContentTypeException scte) {
            response.sendError(415);
        }
        catch (SWORDException se) {
            response.sendError(500);
            if (se.getErrorCode() != null) {
                response.setHeader("X-Error-Code", se.getErrorCode());
            }
            System.out.println(se.toString());
            log.error((Object)se.toString());
        }
        catch (IOException ioe) {
            response.sendError(500);
            log.error((Object)ioe.toString());
        }
        catch (NoSuchAlgorithmException nsae) {
            response.sendError(500);
            log.error((Object)nsae.toString());
        }
    }

    private String getUsernamePassword(HttpServletRequest request) {
        try {
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                String userPass = new String(Base64.decodeBase64((byte[])credentials.getBytes()));
                return userPass;
            }
        }
        catch (Exception e) {
            log.debug((Object)e.toString());
        }
        return null;
    }

    private boolean authenticateWithBasic() {
        return this.authN.equalsIgnoreCase("Basic");
    }

    private static String getUrl(HttpServletRequest req) {
        String reqUrl = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        if (queryString != null) {
            reqUrl = reqUrl + "?" + queryString;
        }
        return reqUrl;
    }
}

