/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.purl.sword.atom.Summary;
import org.purl.sword.atom.Title;
import org.purl.sword.base.SWORDErrorDocument;
import org.purl.sword.server.SWORDServer;

public class DepositServlet
extends HttpServlet {
    protected SWORDServer myRepository;
    private String authN;
    private int maxUploadSize;
    private String tempDirectory;
    private static AtomicInteger counter = new AtomicInteger(0);
    private static Logger log = Logger.getLogger(DepositServlet.class);

    public void init() throws ServletException {
        String className = this.getServletContext().getInitParameter("sword-server-class");
        if (className == null) {
            log.fatal((Object)"Unable to read value of 'sword-server-class' from Servlet context");
        } else {
            try {
                this.myRepository = (SWORDServer)Class.forName(className).newInstance();
                log.info((Object)("Using " + className + " as the SWORDServer"));
            }
            catch (Exception e) {
                log.fatal((Object)("Unable to instantiate class from 'sword-server-class': " + className));
                throw new ServletException("Unable to instantiate class from 'sword-server-class': " + className);
            }
        }
        this.authN = this.getServletContext().getInitParameter("authentication-method");
        if (this.authN == null || this.authN.equals("")) {
            this.authN = "None";
        }
        log.info((Object)("Authentication type set to: " + this.authN));
        String maxUploadSizeStr = this.getServletContext().getInitParameter("maxUploadSize");
        if (maxUploadSizeStr == null || maxUploadSizeStr.equals("") || maxUploadSizeStr.equals("-1")) {
            this.maxUploadSize = -1;
            log.warn((Object)"No maxUploadSize set, so setting max file upload size to unlimited.");
        } else {
            try {
                this.maxUploadSize = Integer.parseInt(maxUploadSizeStr);
                log.info((Object)("Setting max file upload size to " + this.maxUploadSize));
            }
            catch (NumberFormatException nfe) {
                this.maxUploadSize = -1;
                log.warn((Object)"maxUploadSize not a number, so setting max file upload size to unlimited.");
            }
        }
        this.tempDirectory = this.getServletContext().getInitParameter("upload-temp-directory");
        if (this.tempDirectory == null || this.tempDirectory.equals("")) {
            this.tempDirectory = System.getProperty("java.io.tmpdir");
        }
        File tempDir = new File(this.tempDirectory);
        log.info((Object)("Upload temporary directory set to: " + tempDir));
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new ServletException("Upload directory did not exist and I can't create it. " + tempDir);
        }
        if (!tempDir.isDirectory()) {
            log.fatal((Object)("Upload temporary directory is not a directory: " + tempDir));
            throw new ServletException("Upload temporary directory is not a directory: " + tempDir);
        }
        if (!tempDir.canWrite()) {
            log.fatal((Object)("Upload temporary directory cannot be written to: " + tempDir));
            throw new ServletException("Upload temporary directory cannot be written to: " + tempDir);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(501);
    }

    /*
     * Exception decompiling
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 47[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void makeErrorDocument(String errorURI, int status, String summary, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SWORDErrorDocument sed = new SWORDErrorDocument(errorURI);
        Title title = new Title();
        title.setContent("ERROR");
        sed.setTitle(title);
        Calendar calendar = Calendar.getInstance();
        String utcformat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        SimpleDateFormat zulu = new SimpleDateFormat(utcformat);
        String serializeddate = zulu.format(calendar.getTime());
        sed.setUpdated(serializeddate);
        Summary sum = new Summary();
        sum.setContent(summary);
        sed.setSummary(sum);
        if (request.getHeader("User-Agent".toString()) != null) {
            sed.setUserAgent(request.getHeader("User-Agent".toString()));
        }
        response.setStatus(status);
        response.setContentType("application/atom+xml; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(sed.marshall().toXML());
        out.flush();
    }

    protected String getUsernamePassword(HttpServletRequest request) {
        try {
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                String userPass = new String(Base64.decodeBase64((byte[])credentials.getBytes()));
                return userPass;
            }
        }
        catch (Exception e) {
            log.debug((Object)e.toString());
        }
        return null;
    }

    protected boolean authenticateWithBasic() {
        return this.authN.equalsIgnoreCase("Basic");
    }

    protected static String getUrl(HttpServletRequest req) {
        String reqUrl = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        if (queryString != null) {
            reqUrl = reqUrl + "?" + queryString;
        }
        return reqUrl;
    }
}

