/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.atom.Generator;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordMaxUploadSize;
import org.purl.sword.base.SwordNoOp;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.SwordVerbose;
import org.purl.sword.base.SwordVersion;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.Workspace;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends XmlElement
implements SwordElementInterface {
    private SwordVersion swordVersion;
    private SwordNoOp swordNoOp;
    private SwordVerbose swordVerbose;
    private SwordMaxUploadSize swordMaxUploadSize;
    private Generator generator;
    private List<Workspace> workspaces;
    private static Logger log = Logger.getLogger(Service.class);
    @Deprecated
    public static final String ELEMENT_GENERATOR = "generator";
    @Deprecated
    public static final String ELEMENT_NAME = "service";
    private static XmlName XML_NAME = new XmlName("app", "service", "http://www.w3.org/2007/app");

    public Service() {
        super(XML_NAME);
        this.initialise();
    }

    public Service(String version) {
        this();
        this.setVersion(version);
    }

    public Service(String version, boolean noOp, boolean verbose) {
        this();
        this.setVersion(version);
        this.setNoOp(noOp);
        this.setVerbose(verbose);
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    private void initialise() {
        this.workspaces = new ArrayList<Workspace>();
        this.swordVersion = null;
        this.swordNoOp = null;
        this.swordVerbose = null;
        this.swordMaxUploadSize = null;
        this.generator = null;
    }

    public String getVersion() {
        if (this.swordVersion == null) {
            return null;
        }
        return this.swordVersion.getContent();
    }

    public void setVersion(String version) {
        if (version == null) {
            this.swordVersion = null;
            return;
        }
        this.swordVersion = new SwordVersion(version);
    }

    public boolean isNoOp() {
        if (this.swordNoOp == null) {
            return false;
        }
        return this.swordNoOp.getContent();
    }

    public void setNoOp(boolean noOp) {
        this.swordNoOp = new SwordNoOp(noOp);
    }

    public boolean isNoOpSet() {
        if (this.swordNoOp == null) {
            return false;
        }
        return this.swordNoOp.isSet();
    }

    public boolean isVerbose() {
        if (this.swordVerbose == null) {
            return false;
        }
        return this.swordVerbose.getContent();
    }

    public void setVerbose(boolean verbose) {
        this.swordVerbose = new SwordVerbose(verbose);
    }

    public boolean isVerboseSet() {
        if (this.swordVerbose == null) {
            return false;
        }
        return this.swordVerbose.isSet();
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.swordMaxUploadSize = new SwordMaxUploadSize(maxUploadSize);
    }

    public int getMaxUploadSize() {
        if (this.swordMaxUploadSize == null) {
            return Integer.MIN_VALUE;
        }
        return this.swordMaxUploadSize.getContent();
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public Iterator<Workspace> getWorkspaces() {
        return this.workspaces.iterator();
    }

    public List<Workspace> getWorkspacesList() {
        return this.workspaces;
    }

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public void clearWorkspaces() {
        this.workspaces.clear();
    }

    @Override
    public Element marshall() {
        Element service = new Element(this.getQualifiedName(), "http://www.w3.org/2007/app");
        service.addNamespaceDeclaration("atom", "http://www.w3.org/2005/Atom");
        service.addNamespaceDeclaration("dcterms", "http://purl.org/dc/terms/");
        service.addNamespaceDeclaration("sword", "http://purl.org/net/sword/");
        if (this.swordVersion != null) {
            service.appendChild((Node)this.swordVersion.marshall());
        }
        if (this.swordVerbose != null) {
            service.appendChild((Node)this.swordVerbose.marshall());
        }
        if (this.swordNoOp != null) {
            service.appendChild((Node)this.swordNoOp.marshall());
        }
        if (this.swordMaxUploadSize != null) {
            service.appendChild((Node)this.swordMaxUploadSize.marshall());
        }
        if (this.generator != null) {
            service.appendChild((Node)this.generator.marshall());
        }
        for (Workspace item : this.workspaces) {
            service.appendChild((Node)item.marshall());
        }
        return service;
    }

    @Override
    public void unmarshall(Element service) throws UnmarshallException {
        this.unmarshall(service, null);
    }

    public SwordValidationInfo unmarshall(Element service, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(service, this.xmlName)) {
            return this.handleIncorrectElement(service, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        try {
            this.initialise();
            Elements elements = service.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                SwordValidationInfo info;
                element = elements.get(i);
                if (this.isInstanceOf(element, SwordVersion.elementName())) {
                    if (this.swordVersion == null) {
                        this.swordVersion = new SwordVersion();
                        validationItems.add(this.swordVersion.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordVersion.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordVerbose.elementName())) {
                    if (this.swordVerbose == null) {
                        this.swordVerbose = new SwordVerbose();
                        validationItems.add(this.swordVerbose.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordVerbose.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordNoOp.elementName())) {
                    if (this.swordNoOp == null) {
                        this.swordNoOp = new SwordNoOp();
                        validationItems.add(this.swordNoOp.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordNoOp.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordMaxUploadSize.elementName())) {
                    if (this.swordMaxUploadSize == null) {
                        this.swordMaxUploadSize = new SwordMaxUploadSize();
                        validationItems.add(this.swordMaxUploadSize.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordNoOp.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, Generator.elementName())) {
                    if (this.generator == null) {
                        this.generator = new Generator();
                        validationItems.add(this.generator.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Generator.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, Workspace.elementName())) {
                    Workspace workspace = new Workspace();
                    validationItems.add(workspace.unmarshall(element, validationProperties));
                    this.workspaces.add(workspace);
                    continue;
                }
                if (validationProperties == null) continue;
                XmlName name = new XmlName(element.getNamespacePrefix(), element.getLocalName(), element.getNamespaceURI());
                validationItems.add(new SwordValidationInfo(name, "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in Service: " + ex.getMessage()));
            ex.printStackTrace();
            throw new UnmarshallException("Unable to parse element in Service", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, validationContext);
    }

    protected SwordValidationInfo validate(ArrayList<SwordValidationInfo> existing, Properties validationContext) {
        SwordValidationInfo info;
        boolean validateAll = existing != null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        if (this.swordVersion == null) {
            info = new SwordValidationInfo(SwordVersion.elementName(), "This element is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING);
            result.addValidationInfo(info);
        }
        if (this.generator == null) {
            info = new SwordValidationInfo(Generator.elementName(), "This element is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING);
            result.addValidationInfo(info);
        }
        if (this.workspaces == null || this.workspaces.size() == 0) {
            info = new SwordValidationInfo(Workspace.elementName(), "This element SHOULD be included unless the authenticated user does not have permission to deposit.", SwordValidationInfoType.WARNING);
            result.addValidationInfo(info);
        }
        if (validateAll) {
            if (this.swordVersion != null) {
                result.addValidationInfo(this.swordVersion.validate(validationContext));
            }
            if (this.swordNoOp != null) {
                result.addValidationInfo(this.swordNoOp.validate(validationContext));
            }
            if (this.swordVerbose != null) {
                result.addValidationInfo(this.swordVerbose.validate(validationContext));
            }
            if (this.swordMaxUploadSize != null) {
                result.addValidationInfo(this.swordMaxUploadSize.validate(validationContext));
            }
            if (this.generator != null) {
                result.addValidationInfo(this.generator.validate(validationContext));
            }
            Iterator<Workspace> iterator = this.workspaces.iterator();
            while (iterator.hasNext()) {
                result.addValidationInfo(iterator.next().validate(validationContext));
            }
        }
        result.addUnmarshallValidationInfo(existing, null);
        return result;
    }
}

