/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.purl.sword.base.AtomDocumentRequest;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDErrorException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocumentRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWORDAuthenticator {
    private static Logger log = Logger.getLogger(SWORDAuthenticator.class);

    public boolean authenticates(Context context, String un, String pw) {
        int auth = AuthenticationManager.authenticate((Context)context, (String)un, (String)pw, null, null);
        return auth == 1;
    }

    private Context constructContext(String ip) throws SWORDException {
        try {
            Context context = new Context();
            context.setExtraLogInfo("session_id=0:ip_addr=" + ip);
            return context;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem with the database", e);
        }
    }

    public SWORDContext authenticate(ServiceDocumentRequest request) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        Context context = this.constructContext(request.getIPAddress());
        return this.authenticate(context, request);
    }

    public SWORDContext authenticate(AtomDocumentRequest request) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        Context context = this.constructContext(request.getIPAddress());
        return this.authenticate(context, request);
    }

    private SWORDContext authenticate(Context context, AtomDocumentRequest request) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, request.getUsername(), request.getPassword(), null, request.getIPAddress());
    }

    private SWORDContext authenticate(Context context, ServiceDocumentRequest request) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, request.getUsername(), request.getPassword(), request.getOnBehalfOf(), request.getIPAddress());
    }

    public SWORDContext authenticate(Deposit deposit) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        Context context = this.constructContext(deposit.getIPAddress());
        return this.authenticate(context, deposit);
    }

    private SWORDContext authenticate(Context context, Deposit deposit) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, deposit.getUsername(), deposit.getPassword(), deposit.getOnBehalfOf(), deposit.getIPAddress());
    }

    private SWORDContext authenticate(Context context, String un, String pw, String obo, String ip) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        boolean mediated;
        if ("".equals(obo)) {
            obo = null;
        }
        if (!(mediated = ConfigurationManager.getBooleanProperty((String)"sword.on-behalf-of.enable")) && obo != null) {
            log.error((Object)"Attempted mediated deposit on service not configured to do so");
            throw new SWORDErrorException("http://purl.org/net/sword/error/MediationNotAllowed", "Mediated deposit to this service is not permitted");
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"sword_authenticate", (String)("username=" + un + ",on_behalf_of=" + obo)));
        try {
            SWORDContext sc = new SWORDContext();
            EPerson ep = null;
            boolean authenticated = false;
            if (this.authenticates(context, un, pw)) {
                ep = context.getCurrentUser();
                if (ep != null) {
                    authenticated = true;
                    sc.setAuthenticated(ep);
                    int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)context, null);
                    for (int i = 0; i < groupIDs.length; ++i) {
                        context.setSpecialGroup(groupIDs[i]);
                        log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
                    }
                    sc.setAuthenticatorContext(context);
                    sc.setContext(context);
                }
                EPerson epObo = null;
                if (obo != null) {
                    epObo = EPerson.findByEmail((Context)context, (String)obo);
                    if (epObo == null) {
                        epObo = EPerson.findByNetid((Context)context, (String)obo);
                    }
                    if (epObo != null) {
                        sc.setOnBehalfOf(epObo);
                        Context oboContext = this.constructContext(ip);
                        oboContext.setCurrentUser(epObo);
                        int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)oboContext, null);
                        for (int i = 0; i < groupIDs.length; ++i) {
                            oboContext.setSpecialGroup(groupIDs[i]);
                            log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
                        }
                        sc.setContext(oboContext);
                    } else {
                        authenticated = false;
                        throw new SWORDErrorException("http://purl.org/net/sword/error/TargetOwnerUnknown", "unable to identify on-behalf-of user: " + obo);
                    }
                }
            }
            if (!authenticated) {
                if (ep != null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_user", (String)("username=" + un)));
                    throw new SWORDAuthenticationException("Unable to authenticate the supplied used");
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_on_behalf_of", (String)("username=" + un + ",on_behalf_of=" + obo)));
                throw new SWORDAuthenticationException("Unable to authenticate the onBehalfOf account");
            }
            return sc;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem accessing the repository user database", e);
        }
        catch (AuthorizeException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDAuthenticationException("There was a problem authenticating or authorising the user", (Exception)((Object)e));
        }
    }

    public boolean canSubmit(SWORDService swordService, Deposit deposit, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        SWORDContext swordContext = swordService.getSwordContext();
        boolean submit = this.canSubmitTo(swordContext, dso);
        if (submit) {
            swordService.message("User is authorised to submit to collection");
        } else {
            swordService.message("User is not authorised to submit to collection");
        }
        return submit;
    }

    public boolean isUserAdmin(SWORDContext swordContext) throws DSpaceSWORDException {
        try {
            Context context = swordContext.getContext();
            EPerson authenticated = swordContext.getAuthenticated();
            if (authenticated != null) {
                return AuthorizeManager.isAdmin((Context)swordContext.getAuthenticatorContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean isOnBehalfOfAdmin(SWORDContext swordContext) throws DSpaceSWORDException {
        Context context = swordContext.getContext();
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        try {
            if (onBehalfOf != null) {
                return AuthorizeManager.isAdmin((Context)swordContext.getOnBehalfOfContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean isUserInGroup(SWORDContext swordContext, Group group) {
        EPerson authenticated = swordContext.getAuthenticated();
        if (authenticated != null) {
            return this.isInGroup(group, authenticated);
        }
        return false;
    }

    public boolean isOnBehalfOfInGroup(SWORDContext swordContext, Group group) {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        if (onBehalfOf != null) {
            return this.isInGroup(group, onBehalfOf);
        }
        return false;
    }

    public boolean isInGroup(Group group, EPerson eperson) {
        EPerson[] eps = group.getMembers();
        Group[] groups = group.getMemberGroups();
        for (int i = 0; i < eps.length; ++i) {
            if (eperson.getID() != eps[i].getID()) continue;
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (int j = 0; j < groups.length; ++j) {
                if (!this.isInGroup(groups[j], eperson)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Community> getAllowedCommunities(SWORDContext swordContext) throws DSpaceSWORDException {
        try {
            Context context = swordContext.getContext();
            ArrayList<Community> allowed = new ArrayList<Community>();
            Community[] comms = Community.findAllTop((Context)context);
            for (int i = 0; i < comms.length; ++i) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comms[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public List<Community> getCommunities(SWORDContext swordContext, Community community) throws DSpaceSWORDException {
        try {
            Community[] comms = community.getSubcommunities();
            Context context = swordContext.getContext();
            ArrayList<Community> allowed = new ArrayList<Community>();
            for (int i = 0; i < comms.length; ++i) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comms[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public List<Collection> getAllowedCollections(SWORDContext swordContext) throws DSpaceSWORDException {
        return this.getAllowedCollections(swordContext, null);
    }

    public List<Collection> getAllowedCollections(SWORDContext swordContext, Community community) throws DSpaceSWORDException {
        try {
            Context authContext = swordContext.getAuthenticatorContext();
            Collection[] cols = Collection.findAuthorized((Context)authContext, (Community)community, (int)3);
            ArrayList<Collection> allowed = new ArrayList<Collection>();
            for (int i = 0; i < cols.length; ++i) {
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)cols[i], (int)3);
                }
                if (!oboAllowed) continue;
                allowed.add(cols[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public List<Item> getAllowedItems(SWORDContext swordContext, Collection collection) throws DSpaceSWORDException {
        try {
            ArrayList<Item> allowed = new ArrayList<Item>();
            ItemIterator ii = collection.getItems();
            while (ii.hasNext()) {
                int i;
                boolean add;
                boolean write;
                Item item = ii.next();
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                Bundle[] bundles = item.getBundles("ORIGINAL");
                if (!authAllowed) {
                    write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)item, (int)1);
                    add = false;
                    for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                    }
                    boolean bl = authAllowed = write && add;
                }
                if (!oboAllowed) {
                    write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)item, (int)1);
                    add = false;
                    for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                    }
                    boolean bl = oboAllowed = write && add;
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(item);
            }
            return allowed;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean canSubmitTo(SWORDContext swordContext, Collection collection) throws DSpaceSWORDException {
        try {
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            if (!authAllowed) {
                authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)collection, (int)3);
            }
            if (!oboAllowed) {
                oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)collection, (int)3);
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean canSubmitTo(SWORDContext swordContext, Item item) throws DSpaceSWORDException {
        try {
            int i;
            boolean add;
            boolean write;
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            Bundle[] bundles = item.getBundles("ORIGINAL");
            if (!authAllowed) {
                write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)item, (int)1);
                add = false;
                for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                }
                boolean bl = authAllowed = write && add;
            }
            if (!oboAllowed) {
                write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)item, (int)1);
                add = false;
                for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                }
                oboAllowed = write && add;
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    public boolean canSubmitTo(SWORDContext context, DSpaceObject dso) throws DSpaceSWORDException {
        if (dso instanceof Collection) {
            return this.canSubmitTo(context, (Collection)dso);
        }
        if (dso instanceof Item) {
            return this.canSubmitTo(context, (Item)dso);
        }
        return false;
    }
}

