/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.purl.sword.atom.InvalidMediaTypeException;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
extends XmlElement
implements SwordElementInterface {
    public static final String ATTRIBUTE_SRC = "src";
    public static final String ATTRIBUTE_TYPE = "type";
    private String type;
    private String source;
    private static Logger log = Logger.getLogger(Content.class);
    private static final XmlName XML_NAME = new XmlName("atom", "content", "http://www.w3.org/2005/Atom");

    public Content() {
        super(XML_NAME);
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidMediaTypeException {
        if (type == null || !type.matches(".*/.*")) {
            throw new InvalidMediaTypeException("Type: '" + type + "' does not match .*/.*");
        }
        this.type = type;
    }

    @Override
    public Element marshall() {
        Attribute typeAttribute;
        Element content = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.type != null) {
            typeAttribute = new Attribute(ATTRIBUTE_TYPE, this.type);
            content.addAttribute(typeAttribute);
        }
        if (this.source != null) {
            typeAttribute = new Attribute(ATTRIBUTE_SRC, this.source);
            content.addAttribute(typeAttribute);
        }
        return content;
    }

    @Override
    public void unmarshall(Element content) throws UnmarshallException {
        this.unmarshall(content, null);
    }

    public SwordValidationInfo unmarshall(Element content, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(content, this.xmlName.getLocalName(), "http://www.w3.org/2005/Atom")) {
            return this.handleIncorrectElement(content, validationProperties);
        }
        ArrayList<SwordValidationInfo> elements = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributes = new ArrayList<SwordValidationInfo>();
        try {
            int attributeCount = content.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = content.getAttribute(i);
                String name = attribute.getQualifiedName();
                if (ATTRIBUTE_TYPE.equals(name)) {
                    this.type = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributes.add(this.createValidAttributeInfo(ATTRIBUTE_TYPE, this.type));
                    continue;
                }
                if (ATTRIBUTE_SRC.equals(name)) {
                    this.source = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributes.add(this.createValidAttributeInfo(ATTRIBUTE_SRC, this.source));
                    continue;
                }
                SwordValidationInfo info = new SwordValidationInfo(this.xmlName, new XmlName(attribute), "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(attribute.getValue());
                attributes.add(info);
            }
            if (content.getChildCount() > 0) {
                elements.add(new SwordValidationInfo(this.xmlName, "This element has child elements. These are not expected as part of the SWORD profile", SwordValidationInfoType.INFO));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in Content: " + ex.getMessage()));
            throw new UnmarshallException("Error parsing Content", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(elements, attributes, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    protected SwordValidationInfo validate(ArrayList<SwordValidationInfo> elements, ArrayList<SwordValidationInfo> attributes, Properties validationContext) {
        SwordValidationInfo info = new SwordValidationInfo(this.xmlName);
        if (this.source == null) {
            XmlName attributeName = new XmlName(this.xmlName.getPrefix(), ATTRIBUTE_SRC, this.xmlName.getNamespace());
            SwordValidationInfo item = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.ERROR);
            info.addValidationInfo(item);
        }
        info.addUnmarshallValidationInfo(elements, attributes);
        return info;
    }

    public String toString() {
        return "Content - source: " + this.getSource() + " type: " + this.getType();
    }
}

