/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

public class QualityValue {
    private float quality;

    public QualityValue() throws NumberFormatException {
        this.setQualityValue(1.0f);
    }

    public QualityValue(float q) throws NumberFormatException {
        this.setQualityValue(q);
    }

    public void setQualityValue(float q) throws NumberFormatException {
        int pos;
        if (q < 0.0f || q > 1.0f) {
            throw new NumberFormatException("Invalid value - must be between 0 and 1");
        }
        String qStr = "" + q;
        if (qStr.substring((pos = qStr.indexOf(".")) + 1).length() > 3) {
            throw new NumberFormatException("Invalid value - no more than three digits after the decimal point: " + qStr);
        }
        this.quality = q;
    }

    public float getQualityValue() {
        return this.quality;
    }

    public String toString() {
        return Float.toString(this.quality);
    }
}

