/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.atom.Author;
import org.purl.sword.atom.Category;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.Contributor;
import org.purl.sword.atom.Generator;
import org.purl.sword.atom.Id;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.Published;
import org.purl.sword.atom.Rights;
import org.purl.sword.atom.Source;
import org.purl.sword.atom.Summary;
import org.purl.sword.atom.Title;
import org.purl.sword.atom.Updated;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
extends XmlElement
implements SwordElementInterface {
    @Deprecated
    public static final String ELEMENT_NAME = "entry";
    @Deprecated
    public static final String ELEMENT_ID = "id";
    @Deprecated
    public static final String ELEMENT_PUBLISHED = "published";
    @Deprecated
    public static final String ELEMENT_UPDATED = "updated";
    @Deprecated
    public static final String ELEMENT_CATEGORY = "category";
    @Deprecated
    public static final String ELEMENT_GENERATOR = "generator";
    private List<Author> authors;
    private List<Category> categories;
    private Content content;
    private Generator generator;
    private List<Contributor> contributors;
    private Id id;
    private List<Link> links;
    private Published published;
    private Rights rights;
    @Deprecated
    private Source source;
    private Summary summary;
    private Title title;
    private Updated updated;
    private static Logger log = Logger.getLogger(Entry.class);
    private static final XmlName XML_NAME = new XmlName("atom", "entry", "http://www.w3.org/2005/Atom");

    public Entry() {
        this(XML_NAME.getPrefix(), XML_NAME.getLocalName(), XML_NAME.getNamespace());
    }

    public Entry(String prefix, String element) {
        this(prefix, element, XML_NAME.getNamespace());
    }

    public Entry(String prefix, String element, String namespaceUri) {
        super(prefix, element, namespaceUri);
        this.initialise();
    }

    public Entry(XmlName name) {
        this(name.getPrefix(), name.getLocalName(), name.getNamespace());
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    protected boolean isElementChecked(XmlName elementName) {
        if (elementName == null) {
            return false;
        }
        return elementName.equals(Author.elementName()) | elementName.equals(Category.elementName()) | elementName.equals(Content.elementName()) | elementName.equals(Generator.elementName()) | elementName.equals(Contributor.elementName()) | elementName.equals(Id.elementName()) | elementName.equals(Link.elementName()) | elementName.equals(Published.elementName()) | elementName.equals(Rights.elementName()) | elementName.equals(Source.elementName()) | elementName.equals(Summary.elementName()) | elementName.equals(Title.elementName()) | elementName.equals(Updated.elementName());
    }

    protected void initialise() {
        this.authors = new ArrayList<Author>();
        this.categories = new ArrayList<Category>();
        this.contributors = new ArrayList<Contributor>();
        this.links = new ArrayList<Link>();
    }

    @Override
    public Element marshall() {
        Element entry = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        entry.addNamespaceDeclaration("sword", "http://purl.org/net/sword/");
        entry.addNamespaceDeclaration("atom", "http://www.w3.org/2005/Atom");
        this.marshallElements(entry);
        return entry;
    }

    protected void marshallElements(Element entry) {
        if (this.id != null) {
            entry.appendChild((Node)this.id.marshall());
        }
        for (Author author : this.authors) {
            entry.appendChild((Node)author.marshall());
        }
        if (this.content != null) {
            entry.appendChild((Node)this.content.marshall());
        }
        if (this.generator != null) {
            entry.appendChild((Node)this.generator.marshall());
        }
        for (Contributor contributor : this.contributors) {
            entry.appendChild((Node)contributor.marshall());
        }
        for (Link link : this.links) {
            entry.appendChild((Node)link.marshall());
        }
        if (this.published != null) {
            entry.appendChild((Node)this.published.marshall());
        }
        if (this.rights != null) {
            entry.appendChild((Node)this.rights.marshall());
        }
        if (this.summary != null) {
            entry.appendChild((Node)this.summary.marshall());
        }
        if (this.title != null) {
            entry.appendChild((Node)this.title.marshall());
        }
        if (this.source != null) {
            entry.appendChild((Node)this.source.marshall());
        }
        if (this.updated != null) {
            entry.appendChild((Node)this.updated.marshall());
        }
        for (Category category : this.categories) {
            entry.appendChild((Node)category.marshall());
        }
    }

    @Override
    public void unmarshall(Element entry) throws UnmarshallException {
        this.unmarshall(entry, null);
    }

    public SwordValidationInfo unmarshallWithoutValidate(Element entry, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(entry, this.xmlName)) {
            return this.handleIncorrectElement(entry, validationProperties);
        }
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        try {
            this.initialise();
            Elements elements = entry.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                XmlName name;
                SwordValidationInfo info;
                element = elements.get(i);
                if (this.isInstanceOf(element, Author.elementName())) {
                    Author author = new Author();
                    result.addUnmarshallElementInfo(author.unmarshall(element, validationProperties));
                    this.authors.add(author);
                    continue;
                }
                if (this.isInstanceOf(element, Category.elementName())) {
                    Category category = new Category();
                    result.addUnmarshallElementInfo(category.unmarshall(element, validationProperties));
                    this.categories.add(category);
                    continue;
                }
                if (this.isInstanceOf(element, Content.elementName())) {
                    if (this.content == null) {
                        this.content = new Content();
                        result.addUnmarshallElementInfo(this.content.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Content.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Generator.elementName())) {
                    if (this.generator == null) {
                        this.generator = new Generator();
                        result.addUnmarshallElementInfo(this.generator.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Generator.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Contributor.elementName())) {
                    Contributor contributor = new Contributor();
                    result.addUnmarshallElementInfo(contributor.unmarshall(element, validationProperties));
                    this.contributors.add(contributor);
                    continue;
                }
                if (this.isInstanceOf(element, Id.elementName())) {
                    if (this.id == null) {
                        this.id = new Id();
                        result.addUnmarshallElementInfo(this.id.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Id.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Link.elementName())) {
                    Link link = new Link();
                    result.addUnmarshallElementInfo(link.unmarshall(element, validationProperties));
                    this.links.add(link);
                    continue;
                }
                if (this.isInstanceOf(element, Published.elementName())) {
                    if (this.published == null) {
                        this.published = new Published();
                        result.addUnmarshallElementInfo(this.published.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Published.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Rights.elementName())) {
                    if (this.rights == null) {
                        this.rights = new Rights();
                        result.addUnmarshallElementInfo(this.rights.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Rights.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Summary.elementName())) {
                    if (this.summary == null) {
                        this.summary = new Summary();
                        result.addUnmarshallElementInfo(this.summary.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Summary.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Title.elementName())) {
                    if (this.title == null) {
                        this.title = new Title();
                        result.addUnmarshallElementInfo(this.title.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Title.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Updated.elementName())) {
                    if (this.updated == null) {
                        this.updated = new Updated();
                        result.addUnmarshallElementInfo(this.updated.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Updated.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (this.isInstanceOf(element, Source.elementName())) {
                    if (this.source == null) {
                        this.source = new Source();
                        result.addUnmarshallElementInfo(this.source.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Source.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    result.addUnmarshallElementInfo(info);
                    continue;
                }
                if (validationProperties == null || this.isElementChecked(name = new XmlName(element))) continue;
                SwordValidationInfo info2 = new SwordValidationInfo(name, "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info2.setContentDescription(element.getValue());
                result.addUnmarshallElementInfo(info2);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in Entry: " + ex.getMessage()));
            ex.printStackTrace();
            throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
        }
        return result;
    }

    public SwordValidationInfo unmarshall(Element entry, Properties validationProperties) throws UnmarshallException {
        SwordValidationInfo result = this.unmarshallWithoutValidate(entry, validationProperties);
        if (validationProperties != null) {
            result = this.validate(result, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, validationContext);
    }

    protected SwordValidationInfo validate(SwordValidationInfo info, Properties validationContext) {
        boolean validateAll = info == null;
        SwordValidationInfo result = info;
        if (result == null) {
            result = new SwordValidationInfo(this.xmlName);
        }
        if (this.id == null) {
            result.addValidationInfo(new SwordValidationInfo(Id.elementName(), "This element is not present, but at least one MUST be included.", SwordValidationInfoType.ERROR));
        } else if (this.id != null && validateAll) {
            result.addValidationInfo(this.id.validate(validationContext));
        }
        if (this.title == null) {
            result.addValidationInfo(new SwordValidationInfo(Title.elementName(), "This element is not present, but at least one MUST be included.", SwordValidationInfoType.ERROR));
        } else if (this.title != null && validateAll) {
            result.addValidationInfo(this.title.validate(validationContext));
        }
        if (this.updated == null) {
            result.addValidationInfo(new SwordValidationInfo(Updated.elementName(), "This element is not present, but at least one MUST be included.", SwordValidationInfoType.ERROR));
        } else if (this.updated != null && validateAll) {
            result.addValidationInfo(this.updated.validate(validationContext));
        }
        if (this.contributors.isEmpty()) {
            String contributor = validationContext.getProperty("X-On-Behalf-Of");
            if (contributor != null) {
                result.addValidationInfo(new SwordValidationInfo(Contributor.elementName(), "This element is not present, but at least one MUST be included. This item SHOULD contain the value of the X-On-Behalf-Of header, if one was present in the POST request.", SwordValidationInfoType.ERROR));
            }
        } else if (!this.contributors.isEmpty() && validateAll) {
            for (Contributor contributor : this.contributors) {
                result.addValidationInfo(contributor.validate(validationContext));
            }
        }
        if (this.generator == null) {
            result.addValidationInfo(new SwordValidationInfo(Generator.elementName(), "This element is not present, but at least one MUST be included. SHOULD contain the URI and version of the server software.", SwordValidationInfoType.ERROR));
        } else if (this.generator != null && validateAll) {
            result.addValidationInfo(this.generator.validate(validationContext));
        }
        if (validateAll) {
            for (Link link : this.links) {
                result.addValidationInfo(link.validate(validationContext));
            }
            for (Author author : this.authors) {
                result.addValidationInfo(author.validate(validationContext));
            }
            if (this.content != null) {
                result.addValidationInfo(this.content.validate(validationContext));
            }
            if (this.published != null) {
                result.addValidationInfo(this.published.validate(validationContext));
            }
            if (this.rights != null) {
                result.addValidationInfo(this.rights.validate(validationContext));
            }
            if (this.summary != null) {
                result.addValidationInfo(this.summary.validate(validationContext));
            }
            for (Category category : this.categories) {
                result.addValidationInfo(category.validate(validationContext));
            }
        }
        return result;
    }

    public Iterator<Author> getAuthors() {
        return this.authors.iterator();
    }

    public void addAuthors(Author author) {
        this.authors.add(author);
    }

    public void clearAuthors() {
        this.authors.clear();
    }

    public Iterator<String> getCategories() {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < this.categories.size(); ++i) {
            items.add(this.categories.get(i).getContent());
        }
        return items.iterator();
    }

    public void addCategory(String category) {
        this.categories.add(new Category(category));
    }

    public void clearCategories() {
        this.categories.clear();
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public Iterator<Contributor> getContributors() {
        return this.contributors.iterator();
    }

    public void addContributor(Contributor contributor) {
        this.contributors.add(contributor);
    }

    public void clearContributors() {
        this.contributors.clear();
    }

    public String getId() {
        if (this.id == null) {
            return null;
        }
        return this.id.getContent();
    }

    public void setId(String id) {
        this.id = new Id(id);
    }

    public Iterator<Link> getLinks() {
        return this.links.iterator();
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void clearLinks() {
        this.links.clear();
    }

    public String getPublished() {
        if (this.published == null) {
            return null;
        }
        return this.published.getContent();
    }

    public void setPublished(String published) {
        this.published = new Published(published);
    }

    public Rights getRights() {
        return this.rights;
    }

    public void setRights(Rights rights) {
        this.rights = rights;
    }

    @Deprecated
    public Source getSource() {
        return this.source;
    }

    @Deprecated
    public void setSource(Source source) {
        this.source = source;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public String getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return this.updated.getContent();
    }

    public void setUpdated(String updated) {
        this.updated = new Updated(updated);
    }
}

