/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class ItemCollectionGenerator
extends ATOMCollectionGenerator {
    private static Logger log = Logger.getLogger(ItemCollectionGenerator.class);

    public ItemCollectionGenerator(SWORDService service) {
        super(service);
    }

    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        if (!(dso instanceof Item)) {
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        Context context = this.swordService.getContext();
        Item item = (Item)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(item);
        scol.setLocation(location);
        String title = "Untitled";
        DCValue[] dcv = item.getMetadata("dc.title");
        if (dcv.length > 0) {
            title = dcv[0].value;
        }
        scol.setTitle(title);
        String dcAbstract = "";
        DCValue[] dcva = item.getMetadata("dc.description.abstract");
        if (dcva.length > 0) {
            dcAbstract = dcva[0].value;
        }
        if (dcAbstract != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(swordConfig.isMediated());
        List<String> acceptFormats = swordConfig.getAccepts(context, (DSpaceObject)item);
        for (String acceptFormat : acceptFormats) {
            scol.addAccepts(acceptFormat);
        }
        return scol;
    }
}

