/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.sword.BitstreamEntryGenerator;
import org.dspace.sword.CollectionDepositor;
import org.dspace.sword.DSpaceATOMEntry;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.Depositor;
import org.dspace.sword.ItemDepositor;
import org.dspace.sword.ItemEntryGenerator;
import org.dspace.sword.SWORDAuthenticator;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.SWORDErrorException;

public class DepositManager {
    public static final Logger log = Logger.getLogger(DepositManager.class);
    private SWORDService swordService;

    public DepositManager(SWORDService service) {
        this.swordService = service;
        log.debug((Object)"Created instance of DepositManager");
    }

    public DSpaceObject getDepositTarget(Deposit deposit) throws DSpaceSWORDException, SWORDErrorException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        Context context = this.swordService.getContext();
        String loc = deposit.getLocation();
        DSpaceObject dso = urlManager.getDSpaceObject(context, loc);
        this.swordService.message("Performing deposit using location: " + loc);
        if (dso instanceof Collection) {
            this.swordService.message("Location resolves to collection with handle: " + dso.getHandle() + " and name: " + ((Collection)dso).getMetadata("name"));
        } else if (dso instanceof Item) {
            this.swordService.message("Location resolves to item with handle: " + dso.getHandle());
        }
        return dso;
    }

    public DepositResponse deposit(Deposit deposit) throws DSpaceSWORDException, SWORDErrorException, SWORDAuthenticationException {
        Date start = new Date();
        this.swordService.message("Initialising verbose deposit");
        SWORDContext swordContext = this.swordService.getSwordContext();
        Context context = this.swordService.getContext();
        DSpaceObject dso = this.getDepositTarget(deposit);
        SWORDAuthenticator auth = new SWORDAuthenticator();
        if (!auth.canSubmit(this.swordService, deposit, dso)) {
            String oboEmail = "none";
            if (swordContext.getOnBehalfOf() != null) {
                oboEmail = swordContext.getOnBehalfOf().getEmail();
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"deposit_failed_authorisation", (String)("user=" + swordContext.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
            throw new SWORDAuthenticationException("Cannot submit to the given collection with this context");
        }
        this.swordService.message("Authenticated user: " + swordContext.getAuthenticated().getEmail());
        if (swordContext.getOnBehalfOf() != null) {
            this.swordService.message("Depositing on behalf of: " + swordContext.getOnBehalfOf().getEmail());
        }
        Depositor dep = null;
        if (dso instanceof Collection) {
            this.swordService.message("Initialising depositor for an Item in a Collection");
            dep = new CollectionDepositor(this.swordService, dso);
        } else if (dso instanceof Item) {
            this.swordService.message("Initialising depositor for a Bitstream in an Item");
            dep = new ItemDepositor(this.swordService, dso);
        }
        if (dep == null) {
            log.error((Object)"The specified deposit target does not exist, or is not a collection or an item");
            throw new DSpaceSWORDException("Deposit target is not a collection or an item");
        }
        DepositResult result = null;
        try {
            result = dep.doDeposit(deposit);
        }
        catch (DSpaceSWORDException e) {
            if (this.swordService.getSwordConfig().isKeepPackageOnFailedIngest()) {
                try {
                    this.storePackageAsFile(deposit);
                }
                catch (IOException e2) {
                    log.warn((Object)("Unable to store SWORD package as file: " + e));
                }
            }
            throw e;
        }
        catch (SWORDErrorException e) {
            if (this.swordService.getSwordConfig().isKeepPackageOnFailedIngest()) {
                try {
                    this.storePackageAsFile(deposit);
                }
                catch (IOException e2) {
                    log.warn((Object)("Unable to store SWORD package as file: " + e));
                }
            }
            throw e;
        }
        String handle = result.getHandle();
        int state = 201;
        if (handle == null || "".equals(handle)) {
            state = 202;
        }
        DepositResponse response = new DepositResponse(state);
        response.setLocation(result.getMediaLink());
        DSpaceATOMEntry dsatom = null;
        if (result.getItem() != null) {
            this.swordService.message("Initialising ATOM entry generator for an Item");
            dsatom = new ItemEntryGenerator(this.swordService);
        } else if (result.getBitstream() != null) {
            this.swordService.message("Initialising ATOM entry generator for a Bitstream");
            dsatom = new BitstreamEntryGenerator(this.swordService);
        }
        if (dsatom == null) {
            log.error((Object)"The deposit failed, see exceptions for explanation");
            throw new DSpaceSWORDException("Result of deposit did not yield an Item or a Bitstream");
        }
        SWORDEntry entry = dsatom.getSWORDEntry(result, deposit);
        if (deposit.isNoOp()) {
            dep.undoDeposit(result);
            this.swordService.message("NoOp Requested: Removed all traces of submission");
        }
        entry.setNoOp(deposit.isNoOp());
        Date finish = new Date();
        long delta = finish.getTime() - start.getTime();
        this.swordService.message("Total time for deposit processing: " + delta + " ms");
        entry.setVerboseDescription(this.swordService.getVerboseDescription().toString());
        response.setEntry(entry);
        return response;
    }

    private void storePackageAsFile(Deposit deposit) throws IOException {
        String path = this.swordService.getSwordConfig().getFailedPackageDir();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Directory does not exist for writing packages on ingest error.");
        }
        String filenameBase = "sword-" + deposit.getUsername() + "-" + new Date().getTime();
        File packageFile = new File(path, filenameBase);
        File headersFile = new File(path, filenameBase + "-headers");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(deposit.getFile()));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packageFile));
        Utils.copy((InputStream)is, (OutputStream)fos);
        ((OutputStream)fos).close();
        ((InputStream)is).close();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(headersFile)));
        pw.println("Content-Disposition=" + deposit.getContentDisposition());
        pw.println("Content-Type=" + deposit.getContentType());
        pw.println("Packaging=" + deposit.getPackaging());
        pw.println("Location=" + deposit.getLocation());
        pw.println("On Behalf of=" + deposit.getOnBehalfOf());
        pw.println("Slug=" + deposit.getSlug());
        pw.println("User name=" + deposit.getUsername());
        pw.close();
    }
}

