/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlName;

public abstract class XmlElement {
    private static Logger log = Logger.getLogger(XmlElement.class);
    protected XmlName xmlName;
    protected static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ss.Sz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mmZZZZ", "yyyy-MM-dd'T'HH:mmzzzz", "yyyy-MM-dd'T'HHZZZZ", "yyyy-MM-dd'T'HHzzzz", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH", "yyyy-MM-dd", "yyyy-MM", "yyyy"};

    public XmlName getXmlName() {
        return this.xmlName;
    }

    public XmlElement(String localName) {
        this("", localName);
    }

    public XmlElement(String prefix, String localName) {
        this.xmlName = new XmlName(prefix, localName, "");
    }

    public XmlElement(String prefix, String localName, String namespaceUri) {
        this.xmlName = new XmlName(prefix, localName, namespaceUri);
    }

    public XmlElement(XmlName name) {
        this.xmlName = name;
    }

    protected boolean unmarshallBoolean(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing Boolean Value", null);
        }
        try {
            Node child = element.getChild(0);
            String value = child.getValue();
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new UnmarshallException("Illegal Value");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing Boolean element", ex);
        }
    }

    protected String unmarshallString(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing String Value", null);
        }
        try {
            Node child = element.getChild(0);
            return child.getValue();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing String element", ex);
        }
    }

    protected int unmarshallInteger(Element element) throws UnmarshallException {
        if (element.getChildCount() != 1) {
            throw new UnmarshallException("Missing Integer Value", null);
        }
        try {
            Node child = element.getChild(0);
            return Integer.parseInt(child.getValue());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnmarshallException("Error accessing Integer", ex);
        }
        catch (NumberFormatException nfex) {
            throw new UnmarshallException("Error formatting the number", nfex);
        }
    }

    protected boolean isInstanceOf(Element element, String localName, String namespaceURI) {
        return localName.equals(element.getLocalName()) && namespaceURI.equals(element.getNamespaceURI());
    }

    protected boolean isInstanceOf(Element element, XmlName xmlName) {
        return xmlName.getLocalName().equals(element.getLocalName()) && xmlName.getNamespace().equals(element.getNamespaceURI());
    }

    public String getQualifiedName() {
        return this.getQualifiedName(this.xmlName.getLocalName());
    }

    public String getQualifiedName(String name) {
        return this.xmlName.getQualifiedName();
    }

    public String getQualifiedNameWithPrefix(String prefix, String name) {
        return prefix + ":" + name;
    }

    public abstract SwordValidationInfo validate(Properties var1);

    protected void processUnexpectedAttributes(Element element, List<SwordValidationInfo> attributeItems) {
        int attributeCount = element.getAttributeCount();
        Attribute attribute = null;
        for (int i = 0; i < attributeCount; ++i) {
            attribute = element.getAttribute(i);
            XmlName attributeName = new XmlName(attribute.getNamespacePrefix(), attribute.getLocalName(), attribute.getNamespaceURI());
            SwordValidationInfo info = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
            info.setContentDescription(attribute.getValue());
            attributeItems.add(info);
        }
    }

    protected void processUnexpectedAttributes(Element element, SwordValidationInfo info) {
        int attributeCount = element.getAttributeCount();
        Attribute attribute = null;
        for (int i = 0; i < attributeCount; ++i) {
            attribute = element.getAttribute(i);
            XmlName attributeName = new XmlName(attribute.getNamespacePrefix(), attribute.getLocalName(), attribute.getNamespaceURI());
            SwordValidationInfo item = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
            item.setContentDescription(attribute.getValue());
            info.addUnmarshallAttributeInfo(item);
        }
    }

    protected SwordValidationInfo handleIncorrectElement(Element element, Properties validationProperties) throws UnmarshallException {
        log.error((Object)("Unexpected element. Expected: " + this.getQualifiedName() + ". Got: " + (element != null ? element.getQualifiedName() : "null")));
        if (validationProperties != null) {
            SwordValidationInfo info = new SwordValidationInfo(new XmlName(element.getNamespacePrefix(), element.getLocalName(), element.getNamespaceURI()), "This is not the expected element. Received: " + element.getQualifiedName() + " for namespaceUri: " + element.getNamespaceURI(), SwordValidationInfoType.ERROR);
            return info;
        }
        throw new UnmarshallException("Not a " + this.getQualifiedName() + " element");
    }

    protected SwordValidationInfo createValidAttributeInfo(String name, String content) {
        XmlName attributeName = new XmlName(this.xmlName.getPrefix(), name, this.xmlName.getNamespace());
        SwordValidationInfo item = new SwordValidationInfo(this.xmlName, attributeName);
        item.setContentDescription(content);
        return item;
    }
}

