/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.purl.sword.base.SWORDErrorException;

public class SWORDUrlManager {
    private SWORDConfiguration config;
    private Context context;

    public SWORDUrlManager(SWORDConfiguration config, Context context) {
        this.config = config;
        this.context = context;
    }

    public String getGeneratorUrl() {
        String cfg = ConfigurationManager.getProperty((String)"sword.generator.url");
        if (cfg == null || "".equals(cfg)) {
            return "http://www.dspace.org/ns/sword/1.3.1";
        }
        return cfg;
    }

    public String getDepositLocation(Collection collection) throws DSpaceSWORDException {
        return this.getBaseDepositUrl() + "/" + collection.getHandle();
    }

    public String getDepositLocation(Item item) throws DSpaceSWORDException {
        return this.getBaseDepositUrl() + "/" + item.getHandle();
    }

    public String getDepositLocation(Community community) throws DSpaceSWORDException {
        return this.getBaseDepositUrl() + "/" + community.getHandle();
    }

    public Collection getCollection(Context context, String location) throws DSpaceSWORDException, SWORDErrorException {
        try {
            String baseUrl = this.getBaseDepositUrl();
            if (baseUrl.length() == location.length()) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL is incomplete");
            }
            String handle = location.substring(baseUrl.length());
            if (handle.startsWith("/")) {
                handle = handle.substring(1);
            }
            if ("".equals(handle)) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL is incomplete");
            }
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle);
            if (!(dso instanceof Collection)) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL does not resolve to a valid collection");
            }
            return (Collection)dso;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException("There was a problem resolving the collection", e);
        }
    }

    public DSpaceObject getDSpaceObject(Context context, String location) throws DSpaceSWORDException, SWORDErrorException {
        try {
            String baseUrl = this.getBaseDepositUrl();
            if (baseUrl.length() == location.length()) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL is incomplete");
            }
            String handle = location.substring(baseUrl.length());
            if (handle.startsWith("/")) {
                handle = handle.substring(1);
            }
            if ("".equals(handle)) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL is incomplete");
            }
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle);
            if (!(dso instanceof Collection) && !(dso instanceof Item)) {
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The deposit URL does not resolve to a valid deposit target");
            }
            return dso;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException("There was a problem resolving the collection", e);
        }
    }

    public String constructSubServiceUrl(Community community) throws DSpaceSWORDException {
        String base = this.getBaseServiceDocumentUrl();
        String handle = community.getHandle();
        return base + "/" + handle;
    }

    public String constructSubServiceUrl(Collection collection) throws DSpaceSWORDException {
        String base = this.getBaseServiceDocumentUrl();
        String handle = collection.getHandle();
        return base + "/" + handle;
    }

    public DSpaceObject extractDSpaceObject(String url) throws DSpaceSWORDException, SWORDErrorException {
        try {
            String sdBase = this.getBaseServiceDocumentUrl();
            String mlBase = this.getBaseMediaLinkUrl();
            if (url.startsWith(sdBase)) {
                DSpaceObject dso;
                if ((url = url.substring(sdBase.length())).startsWith("/")) {
                    url = url.substring(1);
                }
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                if ((dso = HandleManager.resolveToObject((Context)this.context, (String)url)) instanceof Collection || dso instanceof Community) {
                    return dso;
                }
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "Service Document request does not refer to a DSpace Collection or Community");
            }
            if (url.startsWith(mlBase)) {
                int bsi = url.indexOf("/bitstream/");
                String bsid = url.substring(bsi + 11);
                if (bsid.endsWith("/")) {
                    bsid = bsid.substring(0, url.length() - 1);
                }
                return Bitstream.find((Context)this.context, (int)Integer.parseInt(bsid));
            }
            throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "Unable to recognise URL as a valid service document: " + url);
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public String getBaseServiceDocumentUrl() throws DSpaceSWORDException {
        String depositUrl = ConfigurationManager.getProperty((String)"sword.servicedocument.url");
        if (depositUrl == null || "".equals(depositUrl)) {
            String dspaceUrl = ConfigurationManager.getProperty((String)"dspace.baseUrl");
            if (dspaceUrl == null || "".equals(dspaceUrl)) {
                throw new DSpaceSWORDException("Unable to construct service document urls, due to missing/invalid config in sword.servicedocument.url and/or dspace.baseUrl");
            }
            try {
                URL url = new URL(dspaceUrl);
                depositUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/sword/servicedocument").toString();
            }
            catch (MalformedURLException e) {
                throw new DSpaceSWORDException("Unable to construct service document urls, due to invalid dspace.baseUrl " + e.getMessage(), e);
            }
        }
        return depositUrl;
    }

    public String getBaseDepositUrl() throws DSpaceSWORDException {
        String depositUrl = ConfigurationManager.getProperty((String)"sword.deposit.url");
        if (depositUrl == null || "".equals(depositUrl)) {
            String dspaceUrl = ConfigurationManager.getProperty((String)"dspace.baseUrl");
            if (dspaceUrl == null || "".equals(dspaceUrl)) {
                throw new DSpaceSWORDException("Unable to construct deposit urls, due to missing/invalid config in sword.deposit.url and/or dspace.baseUrl");
            }
            try {
                URL url = new URL(dspaceUrl);
                depositUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/sword/deposit").toString();
            }
            catch (MalformedURLException e) {
                throw new DSpaceSWORDException("Unable to construct deposit urls, due to invalid dspace.baseUrl " + e.getMessage(), e);
            }
        }
        return depositUrl;
    }

    public boolean isBaseServiceDocumentUrl(String url) throws DSpaceSWORDException {
        return this.getBaseServiceDocumentUrl().equals(url);
    }

    public boolean isBaseMediaLinkUrl(String url) throws DSpaceSWORDException {
        return this.getBaseMediaLinkUrl().equals(url);
    }

    public String getBitstreamUrl(Bitstream bitstream) throws DSpaceSWORDException {
        try {
            Bundle[] bundles = bitstream.getBundles();
            Bundle parent = null;
            if (bundles.length <= 0) {
                throw new DSpaceSWORDException("Encountered orphaned bitstream");
            }
            parent = bundles[0];
            Item[] items = parent.getItems();
            if (items.length <= 0) {
                throw new DSpaceSWORDException("Encountered orphaned bundle");
            }
            Item item = items[0];
            String handle = item.getHandle();
            String bsLink = ConfigurationManager.getProperty((String)"dspace.url");
            bsLink = handle != null && !"".equals(handle) ? bsLink + "/bitstream/" + handle + "/" + bitstream.getSequenceID() + "/" + bitstream.getName() : bsLink + "/retrieve/" + bitstream.getID();
            return bsLink;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    public String getBaseMediaLinkUrl() throws DSpaceSWORDException {
        String mlUrl = ConfigurationManager.getProperty((String)"sword.media-link.url");
        if (mlUrl == null || "".equals(mlUrl)) {
            String dspaceUrl = ConfigurationManager.getProperty((String)"dspace.baseUrl");
            if (dspaceUrl == null || "".equals(dspaceUrl)) {
                throw new DSpaceSWORDException("Unable to construct media-link urls, due to missing/invalid config in sword.media-link.url and/or dspace.baseUrl");
            }
            try {
                URL url = new URL(dspaceUrl);
                mlUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/sword/media-link").toString();
            }
            catch (MalformedURLException e) {
                throw new DSpaceSWORDException("Unable to construct media-link urls, due to invalid dspace.baseUrl " + e.getMessage(), e);
            }
        }
        return mlUrl;
    }

    private String getMediaLink(Item dso) throws DSpaceSWORDException {
        String ml = this.getBaseMediaLinkUrl();
        String handle = dso.getHandle();
        if (handle != null) {
            ml = ml + "/" + dso.getHandle();
        }
        return ml;
    }

    public String getMediaLink(Bitstream bitstream) throws DSpaceSWORDException {
        try {
            Bundle[] bundles = bitstream.getBundles();
            Bundle parent = null;
            if (bundles.length <= 0) {
                throw new DSpaceSWORDException("Encountered orphaned bitstream");
            }
            parent = bundles[0];
            Item[] items = parent.getItems();
            if (items.length <= 0) {
                throw new DSpaceSWORDException("Encountered orphaned bundle");
            }
            Item item = items[0];
            String itemUrl = this.getMediaLink(item);
            if (itemUrl.equals(this.getBaseMediaLinkUrl())) {
                return itemUrl;
            }
            String bsUrl = itemUrl + "/bitstream/" + bitstream.getID();
            return bsUrl;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }
}

