/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.Depositor;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDIngesterFactory;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class ItemDepositor
extends Depositor {
    private Item item;

    public ItemDepositor(SWORDService swordService, DSpaceObject dso) throws DSpaceSWORDException {
        super(swordService, dso);
        if (!(dso instanceof Item)) {
            throw new DSpaceSWORDException("You tried to initialise the item depositor with somethingother than an item object");
        }
        this.item = (Item)dso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DepositResult doDeposit(Deposit deposit) throws SWORDErrorException, DSpaceSWORDException {
        DepositResult result;
        block17: {
            Context context = this.swordService.getContext();
            SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            if (!swordConfig.isAcceptableContentType(context, deposit.getContentType(), (DSpaceObject)this.item)) {
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable content type in deposit request: " + deposit.getContentType());
            }
            if (!swordConfig.isSupportedMediaType(deposit.getPackaging(), (DSpaceObject)this.item)) {
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable packaging type in deposit request: " + deposit.getPackaging());
            }
            SWORDIngester si = SWORDIngesterFactory.getInstance(context, deposit, (DSpaceObject)this.item);
            this.swordService.message("Loaded ingester: " + si.getClass().getName());
            result = si.ingest(this.swordService, deposit, (DSpaceObject)this.item);
            this.swordService.message("Archive ingest completed successfully");
            try {
                if (swordConfig.isKeepOriginal()) {
                    Bitstream bitstream;
                    this.swordService.message("DSpace will store an original copy of the deposit file, as well as attaching it to the item");
                    boolean ignoreAuth = context.ignoreAuthorization();
                    context.setIgnoreAuthorization(true);
                    String bundleName = ConfigurationManager.getProperty((String)"sword.bundle.name");
                    if (bundleName == null || "".equals(bundleName)) {
                        bundleName = "SWORD";
                    }
                    Bundle[] bundles = this.item.getBundles(bundleName);
                    Bundle swordBundle = null;
                    if (bundles.length > 0) {
                        swordBundle = bundles[0];
                    }
                    if (swordBundle == null) {
                        swordBundle = this.item.createBundle(bundleName);
                    }
                    String fn = this.swordService.getFilename(context, deposit, true);
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(deposit.getFile());
                        bitstream = swordBundle.createBitstream((InputStream)fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    bitstream.setName(fn);
                    bitstream.setDescription("Original file deposited via SWORD");
                    BitstreamFormat bf = BitstreamFormat.findByMIMEType((Context)context, (String)deposit.getContentType());
                    if (bf != null) {
                        bitstream.setFormat(bf);
                    }
                    bitstream.update();
                    swordBundle.update();
                    this.item.update();
                    this.swordService.message("Original package stored as " + fn + ", in item bundle " + swordBundle);
                    context.setIgnoreAuthorization(ignoreAuth);
                    result.setMediaLink(urlManager.getMediaLink(bitstream));
                    break block17;
                }
                result.setMediaLink(urlManager.getMediaLink(result.getBitstream()));
            }
            catch (SQLException e) {
                throw new DSpaceSWORDException(e);
            }
            catch (AuthorizeException e) {
                throw new DSpaceSWORDException(e);
            }
            catch (FileNotFoundException e) {
                throw new DSpaceSWORDException(e);
            }
            catch (IOException e) {
                throw new DSpaceSWORDException(e);
            }
        }
        return result;
    }

    @Override
    public void undoDeposit(DepositResult result) throws DSpaceSWORDException {
        try {
            SWORDContext sc = this.swordService.getSwordContext();
            Bitstream bs = result.getBitstream();
            Bundle[] bundles = bs.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                bundles[i].removeBitstream(bs);
                bundles[i].update();
            }
            this.swordService.message("Removing temporary files from disk");
            sc.abort();
            this.swordService.message("Database changes aborted");
        }
        catch (IOException e) {
            throw new DSpaceSWORDException(e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSWORDException(e);
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException(e);
        }
    }
}

