/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.purl.sword.base.ChecksumUtils;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.SWORDClient;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.Status;

public class Client
implements SWORDClient {
    private Status status;
    private String server;
    private int port;
    private boolean doAuthentication;
    private String username;
    private String password;
    private String userAgent;
    private HttpClient client = new HttpClient();
    public static final int DEFAULT_TIMEOUT = 20000;
    private static Logger log = Logger.getLogger(Client.class);
    private SwordValidationInfo lastUnmarshallInfo;

    public Client() {
        this.client.getParams().setParameter("http.socket.timeout", (Object)20000);
        log.debug((Object)("proxy host: " + this.client.getHostConfiguration().getProxyHost()));
        log.debug((Object)("proxy port: " + this.client.getHostConfiguration().getProxyPort()));
        this.doAuthentication = false;
    }

    @Override
    public void setServer(String server, int port) {
        this.server = server;
        this.port = port;
    }

    @Override
    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        this.doAuthentication = true;
    }

    private void setBasicCredentials(String username, String password) {
        log.debug((Object)("server: " + this.server + " port: " + this.port + " u: '" + username + "' p '" + password + "'"));
        this.client.getState().setCredentials(new AuthScope(this.server, this.port), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public void setProxy(String host) {
        this.setProxy(host, 80);
    }

    @Override
    public void setProxy(String host, int port) {
        this.client.getHostConfiguration().setProxy(host, port);
    }

    public void clearProxy() {
        this.client.getHostConfiguration().setProxyHost(null);
    }

    @Override
    public void clearCredentials() {
        this.client.getState().clearProxyCredentials();
        this.doAuthentication = false;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setSocketTimeout(int milliseconds) {
        this.client.getParams().setParameter("http.socket.timeout", (Object)milliseconds);
    }

    @Override
    public ServiceDocument getServiceDocument(String url) throws SWORDClientException {
        return this.getServiceDocument(url, null);
    }

    @Override
    public ServiceDocument getServiceDocument(String url, String onBehalfOf) throws SWORDClientException {
        ServiceDocument doc;
        block15: {
            URL serviceDocURL = null;
            try {
                serviceDocURL = new URL(url);
            }
            catch (MalformedURLException e) {
                URL baseURL = null;
                try {
                    baseURL = new URL("http", this.server, this.port, "/");
                    serviceDocURL = new URL(baseURL, url == null ? "" : url);
                }
                catch (MalformedURLException e1) {
                    throw new SWORDClientException(url + " is not a valid URL (" + e1.getMessage() + "), and could not form a relative one from: " + baseURL + " / " + url, e1);
                }
            }
            GetMethod httpget = new GetMethod(serviceDocURL.toExternalForm());
            if (this.doAuthentication) {
                this.setBasicCredentials(this.username, this.password);
                httpget.setDoAuthentication(true);
            }
            Properties properties = new Properties();
            if (this.containsValue(onBehalfOf)) {
                log.debug((Object)("Setting on-behalf-of: " + onBehalfOf));
                httpget.addRequestHeader(new Header("X-On-Behalf-Of", onBehalfOf));
                properties.put("X-On-Behalf-Of", onBehalfOf);
            }
            if (this.containsValue(this.userAgent)) {
                log.debug((Object)("Setting userAgent: " + this.userAgent));
                httpget.addRequestHeader(new Header("User-Agent", this.userAgent));
                properties.put("User-Agent", this.userAgent);
            }
            doc = null;
            try {
                this.client.executeMethod((HttpMethod)httpget);
                this.status = new Status(httpget.getStatusCode(), httpget.getStatusText());
                if (this.status.getCode() == 200) {
                    String message = this.readResponse(httpget.getResponseBodyAsStream());
                    log.debug((Object)("returned message is: " + message));
                    doc = new ServiceDocument();
                    this.lastUnmarshallInfo = doc.unmarshall(message, properties);
                    break block15;
                }
                throw new SWORDClientException("Received error from service document request: " + this.status);
            }
            catch (HttpException ex) {
                throw new SWORDClientException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ioex) {
                throw new SWORDClientException(ioex.getMessage(), ioex);
            }
            catch (UnmarshallException uex) {
                throw new SWORDClientException(uex.getMessage(), uex);
            }
            finally {
                httpget.releaseConnection();
            }
        }
        return doc;
    }

    public SwordValidationInfo getLastUnmarshallInfo() {
        return this.lastUnmarshallInfo;
    }

    @Override
    public DepositResponse postFile(PostMessage message) throws SWORDClientException {
        if (message == null) {
            throw new SWORDClientException("Message cannot be null.");
        }
        PostMethod httppost = new PostMethod(message.getDestination());
        if (this.doAuthentication) {
            this.setBasicCredentials(this.username, this.password);
            httppost.setDoAuthentication(true);
        }
        DepositResponse response = null;
        String messageBody = "";
        try {
            String userAgent;
            String onBehalfOf;
            String filename;
            if (message.isUseMD5()) {
                String md5 = ChecksumUtils.generateMD5(message.getFilepath());
                if (message.getChecksumError()) {
                    md5 = "1234567890";
                }
                log.debug((Object)("checksum error is: " + md5));
                if (md5 != null) {
                    httppost.addRequestHeader(new Header("Content-MD5", md5));
                }
            }
            if (!"".equals(filename = message.getFilename())) {
                httppost.addRequestHeader(new Header("Content-Disposition", " filename=" + filename));
            }
            if (this.containsValue(message.getSlug())) {
                httppost.addRequestHeader(new Header("Slug", message.getSlug()));
            }
            if (message.getCorruptRequest()) {
                httppost.addRequestHeader(new Header("X-No-Op", "Wibble"));
            } else {
                httppost.addRequestHeader(new Header("X-No-Op", Boolean.toString(message.isNoOp())));
            }
            httppost.addRequestHeader(new Header("X-Verbose", Boolean.toString(message.isVerbose())));
            String packaging = message.getPackaging();
            if (packaging != null && packaging.length() > 0) {
                httppost.addRequestHeader(new Header("X-Packaging", packaging));
            }
            if (this.containsValue(onBehalfOf = message.getOnBehalfOf())) {
                httppost.addRequestHeader(new Header("X-On-Behalf-Of", onBehalfOf));
            }
            if (this.containsValue(userAgent = message.getUserAgent())) {
                httppost.addRequestHeader(new Header("User-Agent", userAgent));
            }
            FileRequestEntity requestEntity = new FileRequestEntity(new File(message.getFilepath()), message.getFiletype());
            httppost.setRequestEntity((RequestEntity)requestEntity);
            this.client.executeMethod((HttpMethod)httppost);
            this.status = new Status(httppost.getStatusCode(), httppost.getStatusText());
            log.info((Object)("Checking the status code: " + this.status.getCode()));
            if (this.status.getCode() == 202 || this.status.getCode() == 201) {
                messageBody = this.readResponse(httppost.getResponseBodyAsStream());
                response = new DepositResponse(this.status.getCode());
                response.setLocation(httppost.getResponseHeader("Location").getValue());
                this.lastUnmarshallInfo = response.unmarshall(messageBody, new Properties());
            } else {
                messageBody = this.readResponse(httppost.getResponseBodyAsStream());
                response = new DepositResponse(this.status.getCode());
                response.unmarshallErrorDocument(messageBody);
            }
            DepositResponse depositResponse = response;
            return depositResponse;
        }
        catch (NoSuchAlgorithmException nex) {
            throw new SWORDClientException("Unable to use MD5. " + nex.getMessage(), nex);
        }
        catch (HttpException ex) {
            throw new SWORDClientException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ioex) {
            throw new SWORDClientException(ioex.getMessage(), ioex);
        }
        catch (UnmarshallException uex) {
            throw new SWORDClientException(uex.getMessage() + "(<pre>" + messageBody + "</pre>)", uex);
        }
        finally {
            httppost.releaseConnection();
        }
    }

    private String readResponse(InputStream stream) throws UnsupportedEncodingException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    private boolean containsValue(String item) {
        return item != null && item.trim().length() > 0;
    }
}

