/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.client.Client;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.Status;

public class ServletClient
extends HttpServlet {
    public static final String userAgent = "SWORDAPP Java Client: SWORD version 1.3 compatible (http://sourceforge.net/projects/sword-app/)";
    private String tempDirectory;
    private String[] urls;
    private boolean useProxy = false;
    private String pHost;
    private int pPort;
    private static int counter = 0;

    public void init() {
        this.tempDirectory = this.getServletContext().getInitParameter("upload-temp-directory");
        if (this.tempDirectory == null || this.tempDirectory.equals("")) {
            this.tempDirectory = System.getProperty("java.io.tmpdir");
        }
        String lots = this.getServletContext().getInitParameter("client-urls");
        this.urls = lots.split(",");
        this.pHost = this.getServletContext().getInitParameter("proxy-host");
        String pPortstr = this.getServletContext().getInitParameter("proxy-port");
        if (this.pHost != null && !this.pHost.equals("") && pPortstr != null && !pPortstr.equals("")) {
            try {
                this.pPort = Integer.parseInt(pPortstr);
                this.useProxy = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("urls", (Object)this.urls);
        request.getRequestDispatcher("form.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("servicedocument") != null) {
            this.doServiceDocument(request, response);
        } else if (request.getParameter("deposit") != null) {
            request.setAttribute("url", (Object)request.getParameter("url"));
            request.setAttribute("u", (Object)request.getParameter("u"));
            request.setAttribute("p", (Object)request.getParameter("p"));
            request.setAttribute("obo", (Object)request.getParameter("obo"));
            request.setAttribute("abstract", (Object)request.getParameter("abstract"));
            request.setAttribute("policy", (Object)request.getParameter("policy"));
            request.setAttribute("treatment", (Object)request.getParameter("treatment"));
            request.setAttribute("mediation", (Object)request.getParameter("mediation"));
            request.setAttribute("accepts", (Object)request.getParameter("accepts"));
            request.setAttribute("acceptsp", (Object)request.getParameter("acceptsp"));
            request.setAttribute("maxuploadsize", (Object)request.getParameter("maxuploadsize"));
            request.getRequestDispatcher("depositform.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.doDeposit(request, response);
        } else {
            request.setAttribute("urls", (Object)this.urls);
            request.getRequestDispatcher("form.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void doServiceDocument(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int port;
        Client client = new Client();
        URL url = new URL(request.getParameter("url"));
        String theUrl = request.getParameter("url");
        if (request.getParameter("ownurl") != null && !request.getParameter("ownurl").equals("")) {
            url = new URL(request.getParameter("ownurl"));
            theUrl = request.getParameter("ownurl");
        }
        if ((port = url.getPort()) == -1) {
            port = 80;
        }
        client.setServer(url.getHost(), port);
        client.setCredentials(request.getParameter("u"), request.getParameter("p"));
        if (this.useProxy) {
            client.setProxy(this.pHost, this.pPort);
        }
        try {
            ServiceDocument sd = client.getServiceDocument(theUrl, request.getParameter("obo"));
            Status status = client.getStatus();
            request.setAttribute("status", (Object)status.toString());
            if (status.getCode() == 200) {
                String xml;
                String validateXml = xml = sd.marshall();
                validateXml = validateXml.replaceAll("&", "&amp;");
                validateXml = validateXml.replaceAll("<", "&lt;");
                validateXml = validateXml.replaceAll(">", "&gt;");
                validateXml = validateXml.replaceAll("\"", "&quot;");
                validateXml = validateXml.replaceAll("'", "&apos;");
                request.setAttribute("xmlValidate", (Object)validateXml);
                xml = xml.replaceAll("<", "&lt;");
                xml = xml.replaceAll(">", "&gt;");
                request.setAttribute("xml", (Object)xml);
                request.setAttribute("sd", (Object)sd);
                request.setAttribute("sdURL", (Object)theUrl);
                request.setAttribute("u", (Object)request.getParameter("u"));
                request.setAttribute("p", (Object)request.getParameter("p"));
                request.setAttribute("sdOBO", (Object)request.getParameter("obo"));
                request.getRequestDispatcher("servicedocument.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.setAttribute("error", (Object)(status.getCode() + " " + status.getMessage()));
            request.setAttribute("urls", (Object)this.urls);
            request.getRequestDispatcher("form.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (SWORDClientException e) {
            e.printStackTrace();
            request.setAttribute("error", (Object)e.toString());
            request.setAttribute("urls", (Object)this.urls);
            request.getRequestDispatcher("form.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
    }

    private void doDeposit(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Client client = new Client();
        try {
            PostMessage message = new PostMessage();
            message.setUserAgent("CASIS Test Client");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            Iterator iter = items.iterator();
            String u = null;
            String p = null;
            String contentDisposition = null;
            String filetype = null;
            boolean useMD5 = false;
            boolean errorMD5 = false;
            boolean verbose = false;
            boolean noOp = false;
            boolean login = false;
            while (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                if (item.isFormField()) {
                    String name = item.getFieldName();
                    String value = item.getString();
                    if (name.equals("url")) {
                        message.setDestination(value);
                        URL url = new URL(value);
                        int port = url.getPort();
                        if (port == -1) {
                            port = 80;
                        }
                        client.setServer(url.getHost(), port);
                    } else if (name.equals("usemd5")) {
                        useMD5 = true;
                    } else if (name.equals("errormd5")) {
                        errorMD5 = true;
                    } else if (name.equals("verbose")) {
                        verbose = true;
                    } else if (name.equals("noop")) {
                        noOp = true;
                    } else if (name.equals("obo")) {
                        message.setOnBehalfOf(value);
                    } else if (name.equals("slug")) {
                        if (value != null && !value.trim().equals("")) {
                            message.setSlug(value);
                        }
                    } else if (name.equals("cd")) {
                        contentDisposition = value;
                    } else if (name.equals("filetype")) {
                        filetype = value;
                    } else if (name.equals("formatnamespace")) {
                        if (value != null && !value.trim().equals("")) {
                            message.setFormatNamespace(value);
                        }
                    } else if (name.equals("u")) {
                        u = value;
                        login = true;
                        request.setAttribute("u", (Object)value);
                    } else if (name.equals("p")) {
                        p = value;
                        login = true;
                    }
                    request.setAttribute(name, (Object)value);
                    continue;
                }
                String fname = this.tempDirectory + File.separator + "ServletClient-" + counter++;
                if (contentDisposition != null && !contentDisposition.equals("")) {
                    fname = this.tempDirectory + File.separator + contentDisposition;
                }
                File uploadedFile = new File(fname);
                item.write(uploadedFile);
                message.setFilepath(fname);
                if (filetype == null || filetype.trim().equals("")) {
                    message.setFiletype(item.getContentType());
                    continue;
                }
                message.setFiletype(filetype);
            }
            if (login) {
                client.setCredentials(u, p);
            }
            if (this.useProxy) {
                client.setProxy(this.pHost, this.pPort);
            }
            message.setUseMD5(useMD5);
            message.setChecksumError(errorMD5);
            message.setVerbose(verbose);
            message.setNoOp(noOp);
            DepositResponse resp = client.postFile(message);
            Status status = client.getStatus();
            request.setAttribute("status", (Object)status.toString());
            if (status.getCode() == 201 || status.getCode() == 202) {
                String xml;
                String validateXml = xml = resp.marshall();
                validateXml = validateXml.replaceAll("&", "&amp;");
                validateXml = validateXml.replaceAll("<", "&lt;");
                validateXml = validateXml.replaceAll(">", "&gt;");
                validateXml = validateXml.replaceAll("\"", "&quot;");
                validateXml = validateXml.replaceAll("'", "&apos;");
                request.setAttribute("xmlValidate", (Object)validateXml);
                xml = xml.replaceAll("<", "&lt;");
                xml = xml.replaceAll(">", "&gt;");
                request.setAttribute("xml", (Object)xml);
                SWORDEntry se = resp.getEntry();
                request.setAttribute("id", (Object)se.getId());
                request.setAttribute("authors", se.getAuthors());
                request.setAttribute("contributors", se.getContributors());
                request.setAttribute("title", (Object)se.getTitle().getContent());
                request.setAttribute("updated", (Object)se.getUpdated());
                request.setAttribute("categories", se.getCategories());
                request.setAttribute("treatment", (Object)se.getTreatment());
                request.setAttribute("summary", (Object)se.getSummary().getContent());
                request.setAttribute("generator", (Object)se.getGenerator().getContent());
                request.setAttribute("userAgent", (Object)se.getUserAgent());
                request.setAttribute("packaging", (Object)se.getPackaging());
                request.setAttribute("links", se.getLinks());
                request.setAttribute("location", (Object)resp.getLocation());
                request.getRequestDispatcher("deposit.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String error = status.getCode() + " " + status.getMessage() + " - ";
            try {
                error = error + resp.getEntry().getSummary().getContent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            request.setAttribute("error", (Object)error);
            String xml = resp.marshall();
            xml = xml.replaceAll("<", "&lt;");
            xml = xml.replaceAll(">", "&gt;");
            request.setAttribute("xml", (Object)xml);
            request.getRequestDispatcher("depositform.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            request.setAttribute("error", (Object)("value: " + e.toString()));
            request.setAttribute("urls", (Object)this.urls);
            request.getRequestDispatcher("depositform.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("error", (Object)("value: " + e.toString()));
            request.setAttribute("urls", (Object)this.urls);
            request.getRequestDispatcher("depositform.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

