/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.purl.sword.atom.Author;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.Contributor;
import org.purl.sword.atom.Generator;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.TextConstruct;
import org.purl.sword.base.Collection;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordAcceptPackaging;
import org.purl.sword.base.Workspace;
import org.purl.sword.client.ServiceSelectedListener;

public class ServicePanel
extends JPanel
implements TreeSelectionListener {
    DefaultMutableTreeNode top;
    DefaultTreeModel treeModel = null;
    private JTree services;
    private JEditorPane details;
    private ServiceSelectedListener listener;

    public ServicePanel() {
        this.setLayout(new BorderLayout());
        this.top = new DefaultMutableTreeNode("Services & Posted Files");
        this.treeModel = new DefaultTreeModel(this.top);
        this.services = new JTree(this.treeModel);
        this.services.setCellRenderer(new ServicePostTreeRenderer());
        JScrollPane servicesPane = new JScrollPane(this.services, 22, 32);
        this.details = new JEditorPane("text/html", "<html><body><h1>Details</h1><p>This panel will show the details for the currently selected item in the tree.</p></body></html>");
        JScrollPane detailsPane = new JScrollPane(this.details, 22, 32);
        JSplitPane splitPane = new JSplitPane(1, servicesPane, detailsPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(200);
        this.services.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.services);
        this.add((Component)splitPane, "Center");
    }

    public void setServiceSelectedListener(ServiceSelectedListener listener) {
        this.listener = listener;
    }

    public void processServiceDocument(String url, ServiceDocument doc) {
        TreeNodeWrapper wrapper = null;
        Service service = doc.getService();
        wrapper = new TreeNodeWrapper(url, service);
        DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(wrapper);
        this.treeModel.insertNodeInto(serviceNode, this.top, this.top.getChildCount());
        this.services.scrollPathToVisible(new TreePath(serviceNode.getPath()));
        DefaultMutableTreeNode workspaceNode = null;
        Iterator<Workspace> workspaces = service.getWorkspaces();
        while (workspaces.hasNext()) {
            Workspace workspace = workspaces.next();
            wrapper = new TreeNodeWrapper(workspace.getTitle(), workspace);
            workspaceNode = new DefaultMutableTreeNode(wrapper);
            this.treeModel.insertNodeInto(workspaceNode, serviceNode, serviceNode.getChildCount());
            this.services.scrollPathToVisible(new TreePath(workspaceNode.getPath()));
            DefaultMutableTreeNode collectionNode = null;
            Iterator<Collection> collections = workspace.collectionIterator();
            while (collections.hasNext()) {
                Collection collection = collections.next();
                wrapper = new TreeNodeWrapper(collection.getTitle(), collection);
                collectionNode = new DefaultMutableTreeNode(wrapper);
                this.treeModel.insertNodeInto(collectionNode, workspaceNode, workspaceNode.getChildCount());
                this.services.scrollPathToVisible(new TreePath(collectionNode.getPath()));
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath[] paths = evt.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            if (!evt.isAddedPath(i)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof TreeNodeWrapper) {
                try {
                    TreeNodeWrapper wrapper = (TreeNodeWrapper)o;
                    Object data = wrapper.getData();
                    if (data instanceof Service) {
                        this.showService((Service)data);
                        this.alertListener(null);
                        continue;
                    }
                    if (data instanceof Workspace) {
                        this.showWorkspace((Workspace)data);
                        if (this.listener == null) continue;
                        this.alertListener(null);
                        continue;
                    }
                    if (data instanceof Collection) {
                        Collection c = (Collection)data;
                        this.showCollection(c);
                        this.alertListener(c.getLocation());
                        continue;
                    }
                    if (data instanceof SWORDEntry) {
                        this.showEntry((SWORDEntry)data);
                        this.alertListener(null);
                        continue;
                    }
                    this.details.setText("<html><body>unknown</body></html>");
                    this.alertListener(null);
                }
                catch (Exception e) {
                    this.details.setText("<html><body>An error occurred. The message was: " + e.getMessage() + "</body></html>");
                    this.alertListener(null);
                    e.printStackTrace();
                }
                continue;
            }
            this.details.setText("<html><body>please select one of the other nodes</body></html>");
            this.alertListener(null);
        }
    }

    private void alertListener(String value) {
        if (this.listener != null) {
            this.listener.selected(value);
        }
    }

    private void addTableRow(StringBuffer buffer, String label, Object value) {
        buffer.append("<tr bgcolor=\"#ffffff;\"><td>");
        buffer.append(label);
        buffer.append("</td><td>");
        buffer.append(this.displayableValue(value));
        buffer.append("</td></tr>");
    }

    private void showService(Service service) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<table border=\"1\" width=\"100%\">");
        buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Service Summary</font></td></tr>");
        this.addTableRow(buffer, "SWORD Version", service.getVersion());
        this.addTableRow(buffer, "NoOp Support ", service.isNoOp());
        this.addTableRow(buffer, "Verbose Support ", service.isVerbose());
        String maxSize = "";
        maxSize = "undefined";
        this.addTableRow(buffer, "Max File Upload Size ", maxSize);
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private void showWorkspace(Workspace workspace) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<table border=\"1\" width=\"100%\">");
        buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Workspace Summary</font></td></tr>");
        this.addTableRow(buffer, "Workspace Title", workspace.getTitle());
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private Object displayableValue(Object s) {
        if (null == s) {
            return "Not defined";
        }
        return s;
    }

    private void addPara(StringBuffer buffer, String message) {
        buffer.append("<p>" + message + "</p>");
    }

    private void showCollection(Collection collection) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        if (collection == null) {
            this.addPara(buffer, "Invalid Collection object. Unable to display details.");
        } else {
            buffer.append("<table border=\"1\" width=\"100%\">");
            buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Collection Summary</font></td></tr>");
            this.addTableRow(buffer, "Collection location", collection.getLocation());
            this.addTableRow(buffer, "Collection title", collection.getTitle());
            this.addTableRow(buffer, "Abstract", collection.getAbstract());
            this.addTableRow(buffer, "Collection Policy", collection.getCollectionPolicy());
            this.addTableRow(buffer, "Treatment", collection.getTreatment());
            this.addTableRow(buffer, "Mediation", collection.getMediation());
            this.addTableRow(buffer, "Nested Service Document", collection.getService());
            String[] accepts = collection.getAccepts();
            StringBuilder acceptList = new StringBuilder();
            if (accepts != null && accepts.length == 0) {
                acceptList.append("None specified");
            } else {
                for (String s : accepts) {
                    acceptList.append(s).append("<br>");
                }
            }
            this.addTableRow(buffer, "Accepts", acceptList.toString());
            List<SwordAcceptPackaging> acceptsPackaging = collection.getAcceptPackaging();
            StringBuilder acceptPackagingList = new StringBuilder();
            Iterator<SwordAcceptPackaging> i = acceptsPackaging.iterator();
            while (i.hasNext()) {
                SwordAcceptPackaging accept = i.next();
                acceptPackagingList.append(accept.getContent()).append(" (").append(accept.getQualityValue()).append(")");
                if (!i.hasNext()) continue;
                acceptPackagingList.append(", ");
            }
            this.addTableRow(buffer, "Accepts Packaging", acceptPackagingList.toString());
            buffer.append("</table>");
        }
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private void showEntry(SWORDEntry entry) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        if (entry == null) {
            this.addPara(buffer, "Invalid Entry object. Unable to display details.");
        } else {
            buffer.append("<table border=\"1\" width=\"100%\">");
            buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Entry Summary</font></td></tr>");
            String titleString = this.getTextConstructDetails(entry.getSummary());
            this.addTableRow(buffer, "Title", titleString);
            this.addTableRow(buffer, "ID", entry.getId());
            this.addTableRow(buffer, "Date Updated", entry.getUpdated());
            String authorString = this.getAuthorDetails(entry.getAuthors());
            this.addTableRow(buffer, "Authors", authorString);
            String summaryString = this.getTextConstructDetails(entry.getSummary());
            this.addTableRow(buffer, "Summary", summaryString);
            Content content = entry.getContent();
            String contentString = "";
            contentString = content == null ? "Not defined." : contentString + "Source: '" + content.getSource() + "', Type: '" + content.getType() + "'";
            this.addTableRow(buffer, "Content", contentString);
            Iterator<Link> links = entry.getLinks();
            StringBuffer linkBuffer = new StringBuffer();
            while (links.hasNext()) {
                Link link = links.next();
                linkBuffer.append("href: '");
                linkBuffer.append(link.getHref());
                linkBuffer.append("', href lang: '");
                linkBuffer.append(link.getHreflang());
                linkBuffer.append("', rel: '");
                linkBuffer.append(link.getRel());
                linkBuffer.append("')<br>");
            }
            if (linkBuffer.length() == 0) {
                linkBuffer.append("Not defined");
            }
            this.addTableRow(buffer, "Links", linkBuffer.toString());
            String contributorString = this.getContributorDetails(entry.getContributors());
            this.addTableRow(buffer, "Contributors", contributorString);
            String sourceString = "";
            Generator generator = entry.getGenerator();
            if (generator != null) {
                sourceString = sourceString + "Content: '" + generator.getContent() + "' <br>'";
                sourceString = sourceString + "Version: '" + generator.getVersion() + "' <br>'";
                sourceString = sourceString + "Uri: '" + generator.getUri() + "'";
            } else {
                sourceString = sourceString + "No generator defined.";
            }
            this.addTableRow(buffer, "Generator", sourceString);
            this.addTableRow(buffer, "Treatment", entry.getTreatment());
            this.addTableRow(buffer, "Verbose Description", entry.getVerboseDescription());
            this.addTableRow(buffer, "NoOp", entry.isNoOp());
            this.addTableRow(buffer, "Packaging", entry.getPackaging());
            this.addTableRow(buffer, "User Agent", entry.getUserAgent());
            buffer.append("</table>");
        }
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private String getTextConstructDetails(TextConstruct data) {
        String summaryStr = "";
        if (data == null) {
            summaryStr = "Not defined";
        } else {
            summaryStr = "Content: '" + data.getContent() + "', Type: ";
            summaryStr = data.getType() != null ? summaryStr + "'" + data.getType().toString() + "'" : summaryStr + "undefined.";
        }
        return summaryStr;
    }

    private String getAuthorDetails(Iterator<Author> authors) {
        StringBuffer authorBuffer = new StringBuffer();
        while (authors.hasNext()) {
            Author a = authors.next();
            authorBuffer.append(this.getAuthorDetails(a));
        }
        if (authorBuffer.length() == 0) {
            authorBuffer.append("Not defined");
        }
        return authorBuffer.toString();
    }

    private String getContributorDetails(Iterator<Contributor> contributors) {
        StringBuffer authorBuffer = new StringBuffer();
        while (contributors.hasNext()) {
            Contributor c = contributors.next();
            authorBuffer.append(this.getAuthorDetails(c));
        }
        if (authorBuffer.length() == 0) {
            authorBuffer.append("Not defined");
        }
        return authorBuffer.toString();
    }

    private String getAuthorDetails(Author author) {
        StringBuffer authorBuffer = new StringBuffer();
        authorBuffer.append(author.getName());
        authorBuffer.append(" (email: '");
        authorBuffer.append(author.getEmail());
        authorBuffer.append("', uri: '");
        authorBuffer.append(author.getUri());
        authorBuffer.append("')<br>");
        return authorBuffer.toString();
    }

    public void processDepositResponse(String url, DepositResponse response) {
        SWORDEntry entry = response.getEntry();
        Object title = entry.getTitle();
        title = title == null ? "Undefined" : entry.getTitle().getContent();
        TreeNodeWrapper wrapper = new TreeNodeWrapper(title.toString(), entry);
        DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(wrapper);
        DefaultMutableTreeNode newParentNode = this.top;
        List<DefaultMutableTreeNode> nodes = this.getCollectionNodes();
        for (DefaultMutableTreeNode node : nodes) {
            Collection col;
            String location;
            TreeNodeWrapper collectionWrapper;
            Object data;
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (collectionWrapper = (TreeNodeWrapper)o).getData()) instanceof Collection) || (location = (col = (Collection)data).getLocation()) == null || !location.equals(url)) continue;
            newParentNode = node;
            break;
        }
        this.treeModel.insertNodeInto(entryNode, newParentNode, newParentNode.getChildCount());
        this.services.scrollPathToVisible(new TreePath(entryNode.getPath()));
    }

    public String[] getCollectionLocations() {
        List<DefaultMutableTreeNode> nodes = this.getCollectionNodes();
        String[] locations = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Collection col;
            String location;
            TreeNodeWrapper collectionWrapper;
            Object data;
            DefaultMutableTreeNode node = nodes.get(i);
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (collectionWrapper = (TreeNodeWrapper)o).getData()) instanceof Collection) || (location = (col = (Collection)data).getLocation()) == null) continue;
            locations[i] = location;
        }
        return locations;
    }

    private List<DefaultMutableTreeNode> getCollectionNodes() {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> treeNodes = this.top.depthFirstEnumeration();
        while (treeNodes.hasMoreElements()) {
            TreeNodeWrapper wrapper;
            Object data;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNodes.nextElement();
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (wrapper = (TreeNodeWrapper)o).getData()) instanceof Collection)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    static class TreeNodeWrapper {
        private String name;
        private Object userObject;

        public TreeNodeWrapper(String name, Object data) {
            this.name = name;
            this.userObject = data;
        }

        public Object getData() {
            return this.userObject;
        }

        public String toString() {
            if (this.name == null || this.name.trim().equals("")) {
                return "Unspecified";
            }
            return this.name;
        }
    }

    static class ServicePostTreeRenderer
    extends DefaultTreeCellRenderer {
        Icon workspaceIcon;
        Icon serviceIcon;
        Icon collectionIcon;
        Icon fileIcon;

        public ServicePostTreeRenderer() {
            ClassLoader loader = this.getClass().getClassLoader();
            this.workspaceIcon = new ImageIcon(loader.getResource("images/WorkspaceNodeImage.gif"));
            this.serviceIcon = new ImageIcon(loader.getResource("images/ServiceNodeImage.gif"));
            this.collectionIcon = new ImageIcon(loader.getResource("images/CollectionNodeImage.gif"));
            this.fileIcon = new ImageIcon(loader.getResource("images/ServiceNodeImage.gif"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent comp = (JComponent)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            if (o instanceof TreeNodeWrapper) {
                TreeNodeWrapper wrapper = (TreeNodeWrapper)o;
                comp.setToolTipText(wrapper.toString());
                Object data = wrapper.getData();
                if (data instanceof Service) {
                    this.setIcon(this.serviceIcon);
                } else if (data instanceof Workspace) {
                    this.setIcon(this.workspaceIcon);
                } else if (data instanceof Collection) {
                    this.setIcon(this.collectionIcon);
                } else if (data instanceof SWORDEntry) {
                    this.setIcon(this.fileIcon);
                }
            } else {
                comp.setToolTipText(null);
            }
            return comp;
        }
    }
}

