/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import org.apache.log4j.Logger;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class CommunityCollectionGenerator
extends ATOMCollectionGenerator {
    private static Logger log = Logger.getLogger(CommunityCollectionGenerator.class);

    public CommunityCollectionGenerator(SWORDService service) {
        super(service);
        log.debug((Object)"Created instance of CommunityCollectionGenerator");
    }

    @Override
    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        String dcAbstract;
        if (!(dso instanceof Community)) {
            log.error((Object)"buildCollection passed something other than a Community object");
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        Community com = (Community)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(com);
        scol.setLocation(location);
        String title = com.getMetadata("name");
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if ((dcAbstract = com.getMetadata("short_description")) != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(swordConfig.isMediated());
        String subService = urlManager.constructSubServiceUrl(com);
        scol.setService(subService);
        log.debug((Object)"Created ATOM Collection for DSpace Community");
        return scol;
    }
}

