/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.atom.ContentType;
import org.purl.sword.atom.Title;
import org.purl.sword.base.Collection;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class Workspace
extends XmlElement
implements SwordElementInterface {
    private Title title;
    private List<Collection> collections;
    private static Logger log = Logger.getLogger(Workspace.class);
    @Deprecated
    public static final String ELEMENT_NAME = "workspace";
    private static final XmlName XML_NAME = new XmlName("app", "workspace", "http://www.w3.org/2007/app");

    public Workspace() {
        super(XML_NAME);
        this.initialise();
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    public Workspace(String title) {
        this();
        this.setTitle(title);
    }

    protected final void initialise() {
        this.collections = new ArrayList<Collection>();
        this.title = null;
    }

    public final void setTitle(String title) {
        if (this.title == null) {
            this.title = new Title();
        }
        this.title.setContent(title);
        this.title.setType(ContentType.TEXT);
    }

    public final String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getContent();
    }

    public void addCollection(Collection collection) {
        this.collections.add(collection);
    }

    public Iterator<Collection> collectionIterator() {
        return this.collections.iterator();
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    @Override
    public Element marshall() {
        Element workspace = new Element(this.xmlName.getQualifiedName(), this.xmlName.getNamespace());
        if (this.title != null) {
            workspace.appendChild((Node)this.title.marshall());
        }
        for (Collection item : this.collections) {
            workspace.appendChild((Node)item.marshall());
        }
        return workspace;
    }

    @Override
    public void unmarshall(Element workspace) throws UnmarshallException {
        this.unmarshall(workspace, null);
    }

    public SwordValidationInfo unmarshall(Element workspace, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(workspace, this.xmlName)) {
            return this.handleIncorrectElement(workspace, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        try {
            this.initialise();
            Elements elements = workspace.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, Title.elementName())) {
                    if (this.title == null) {
                        this.title = new Title();
                        validationItems.add(this.title.unmarshall(element, validationProperties));
                        continue;
                    }
                    SwordValidationInfo info = new SwordValidationInfo(Title.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, Collection.elementName())) {
                    Collection collection = new Collection();
                    validationItems.add(collection.unmarshall(element, validationProperties));
                    this.collections.add(collection);
                    continue;
                }
                if (validationProperties == null) continue;
                validationItems.add(new SwordValidationInfo(new XmlName(element), "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in workspace: " + ex.getMessage()));
            throw new UnmarshallException("Unable to parse element in workspace.", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, validationContext);
    }

    protected SwordValidationInfo validate(List<SwordValidationInfo> existing, Properties validationContext) {
        boolean validateAll = existing == null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        if (this.collections == null || this.collections.size() == 0) {
            result.addValidationInfo(new SwordValidationInfo(Collection.elementName(), "This element is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        }
        if (validateAll) {
            if (this.title != null) {
                result.addValidationInfo(this.title.validate(validationContext));
            }
            if (this.collections.size() > 0) {
                Iterator<Collection> iterator = this.collections.iterator();
                while (iterator.hasNext()) {
                    result.addValidationInfo(iterator.next().validate(validationContext));
                }
            }
        }
        result.addUnmarshallValidationInfo(existing, null);
        return result;
    }
}

