/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositManager;
import org.dspace.sword.MediaEntryManager;
import org.dspace.sword.SWORDAuthenticator;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.dspace.sword.ServiceDocumentManager;
import org.purl.sword.base.AtomDocumentRequest;
import org.purl.sword.base.AtomDocumentResponse;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDErrorException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceDocumentRequest;
import org.purl.sword.server.SWORDServer;

public class DSpaceSWORDServer
implements SWORDServer {
    public static final Logger log = Logger.getLogger(DSpaceSWORDServer.class);

    @Override
    public ServiceDocument doServiceDocument(ServiceDocumentRequest request) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        SWORDContext sc = null;
        try {
            ServiceDocument doc;
            SWORDAuthenticator auth = new SWORDAuthenticator();
            sc = auth.authenticate(request);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_do_service_document", (String)""));
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"sword_service_document_request", (String)("username=" + request.getUsername() + ",on_behalf_of=" + request.getOnBehalfOf())));
            SWORDService service = new SWORDService(sc);
            ServiceDocumentManager manager = new ServiceDocumentManager(service);
            ServiceDocument serviceDocument = doc = manager.getServiceDocument(request.getLocation());
            return serviceDocument;
        }
        catch (DSpaceSWORDException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("The DSpace SWORD interface experienced an error", e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    @Override
    public DepositResponse doDeposit(Deposit deposit) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        SWORDContext sc = null;
        try {
            SWORDAuthenticator auth = new SWORDAuthenticator();
            sc = auth.authenticate(deposit);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_do_deposit", (String)""));
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"sword_deposit_request", (String)("username=" + deposit.getUsername() + ",on_behalf_of=" + deposit.getOnBehalfOf())));
            SWORDService service = new SWORDService(sc);
            service.setVerbose(deposit.isVerbose());
            DepositManager dm = new DepositManager(service);
            DepositResponse response = dm.deposit(deposit);
            sc.commit();
            DepositResponse depositResponse = response;
            return depositResponse;
        }
        catch (DSpaceSWORDException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SWORDException("There was a problem depositing the item", e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    @Override
    public AtomDocumentResponse doAtomDocument(AtomDocumentRequest adr) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        SWORDContext sc = null;
        try {
            AtomDocumentResponse doc;
            SWORDAuthenticator auth = new SWORDAuthenticator();
            sc = auth.authenticate(adr);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_do_atom_document", (String)""));
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"sword_atom_document_request", (String)("username=" + adr.getUsername())));
            SWORDService service = new SWORDService(sc);
            MediaEntryManager manager = new MediaEntryManager(service);
            AtomDocumentResponse atomDocumentResponse = doc = manager.getMediaEntry(adr.getLocation());
            return atomDocumentResponse;
        }
        catch (DSpaceSWORDException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("The DSpace SWORD interface experienced an error", e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }
}

