/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.swordclient;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.sword.client.ServiceDocumentHelper;
import org.purl.sword.base.Collection;
import org.purl.sword.base.ServiceDocument;
import org.xml.sax.SAXException;

public class SelectPackagingTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = SelectPackagingTransformer.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectCollection.title");
    private static final Message T_SwordCopy_trail = SelectPackagingTransformer.message((String)"xmlui.swordclient.general.SwordCopy_trail");
    private static final Message T_trail = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectCollection.trail");
    private static final Message T_main_head = SelectPackagingTransformer.message((String)"xmlui.swordclient.general.main_head");
    private static final Message T_collection_head = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.head");
    private static final Message T_collection_title = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.title");
    private static final Message T_collection_policy = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.policy");
    private static final Message T_collection_mediation = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.mediation");
    private static final Message T_collection_file_types = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.file_types");
    private static final Message T_collection_package_formats = SelectPackagingTransformer.message((String)"xmlui.swordclient.SelectPackagingAction.package_formats");
    private static final Message T_submit_next = SelectPackagingTransformer.message((String)"xmlui.general.next");
    private static final Message T_submit_cancel = SelectPackagingTransformer.message((String)"xmlui.general.cancel");
    private static Logger log = Logger.getLogger(SelectPackagingTransformer.class);

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_SwordCopy_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String handle = this.parameters.getParameter("handle", null);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ServiceDocument serviceDoc = (ServiceDocument)request.getAttribute("serviceDoc");
        String location = (String)request.getAttribute("location");
        String[] fileTypes = (String[])request.getAttribute("fileTypes");
        String[] packageFormats = (String[])request.getAttribute("packageFormats");
        Collection collection = ServiceDocumentHelper.getCollection((ServiceDocument)serviceDoc, (String)location);
        Division main = body.addInteractiveDivision("confirm-collection", this.contextPath + "/swordclient", "post", "");
        main.setHead(T_main_head.parameterize(new Object[]{handle}));
        List collectionList = main.addList("collectionList", "form");
        collectionList.setHead(T_collection_head.parameterize(new Object[]{location}));
        collectionList.addItem().addContent(T_collection_title.parameterize(new Object[]{collection.getTitle()}));
        collectionList.addItem().addContent(T_collection_policy.parameterize(new Object[]{collection.getCollectionPolicy()}));
        collectionList.addItem().addContent(T_collection_mediation.parameterize(new Object[]{Boolean.toString(collection.getMediation())}));
        Select fileType = collectionList.addItem().addSelect("fileType");
        for (String ft : fileTypes) {
            fileType.addOption(false, ft, ft);
        }
        fileType.setLabel(T_collection_file_types);
        Select packageFormat = collectionList.addItem().addSelect("packageFormat");
        for (String pf : packageFormats) {
            packageFormat.addOption(false, pf, pf);
        }
        packageFormat.setLabel(T_collection_package_formats);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_next").setValue(T_submit_next);
        buttonList.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("swordclient-continue").setValue(this.knot.getId());
    }
}

