/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FlowContainerUtils {
    public static final String ROLE_ADMIN = "ADMIN";
    public static final String ROLE_WF_STEP1 = "WF_STEP1";
    public static final String ROLE_WF_STEP2 = "WF_STEP2";
    public static final String ROLE_WF_STEP3 = "WF_STEP3";
    public static final String ROLE_SUBMIT = "SUBMIT";
    public static final String ROLE_DEFAULT_READ = "DEFAULT_READ";

    public static FlowResult processEditCollection(Context context, int collectionID, boolean deleteLogo, Request request) throws SQLException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        collection.setMetadata("name", name);
        collection.setMetadata("short_description", shortDescription);
        collection.setMetadata("introductory_text", introductoryText);
        collection.setMetadata("copyright_text", copyrightText);
        collection.setMetadata("side_bar_text", sideBarText);
        collection.setMetadata("license", license);
        collection.setMetadata("provenance_description", provenanceDescription);
        if (deleteLogo) {
            collection.setLogo(null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                collection.setLogo(is);
            }
        }
        collection.update();
        context.commit();
        result.setContinue(true);
        return result;
    }

    public static int getTemplateItemID(Context context, int collectionID) throws SQLException, AuthorizeException, IOException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Item template = collection.getTemplateItem();
        if (template == null) {
            collection.createTemplateItem();
            template = collection.getTemplateItem();
            collection.update();
            template.update();
            context.commit();
        }
        return template.getID();
    }

    public static int getCollectionRole(Context context, int collectionID, String roleName) throws SQLException, AuthorizeException, IOException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = null;
        if (ROLE_ADMIN.equals(roleName)) {
            role = collection.getAdministrators();
            if (role == null) {
                role = collection.createAdministrators();
            }
        } else if (ROLE_SUBMIT.equals(roleName)) {
            role = collection.getSubmitters();
            if (role == null) {
                role = collection.createSubmitters();
            }
        } else if (ROLE_WF_STEP1.equals(roleName)) {
            role = collection.getWorkflowGroup(1);
            if (role == null) {
                role = collection.createWorkflowGroup(1);
            }
        } else if (ROLE_WF_STEP2.equals(roleName)) {
            role = collection.getWorkflowGroup(2);
            if (role == null) {
                role = collection.createWorkflowGroup(2);
            }
        } else if (ROLE_WF_STEP3.equals(roleName) && (role = collection.getWorkflowGroup(3)) == null) {
            role = collection.createWorkflowGroup(3);
        }
        collection.update();
        context.commit();
        if (role != null) {
            return role.getID();
        }
        return -1;
    }

    public static FlowResult processDeleteCollectionRole(Context context, int collectionID, String roleName, int groupID) throws SQLException, UIException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.find((Context)context, (int)groupID);
        if (ROLE_ADMIN.equals(roleName)) {
            throw new UIException("This operation can not be preformed untill the DSpace API is modified to enable the removal of collection administrators.");
        }
        if (ROLE_SUBMIT.equals(roleName)) {
            throw new UIException("This operation can not be preformed untill the DSpace API is modified to enable the removal of collection submitters.");
        }
        if (ROLE_WF_STEP1.equals(roleName)) {
            collection.setWorkflowGroup(1, null);
        } else if (ROLE_WF_STEP2.equals(roleName)) {
            collection.setWorkflowGroup(2, null);
        } else if (ROLE_WF_STEP3.equals(roleName)) {
            collection.setWorkflowGroup(3, null);
        }
        List policies = AuthorizeManager.getPolicies((Context)context, (DSpaceObject)collection);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroupID() != groupID) continue;
            policy.delete();
        }
        collection.update();
        role.delete();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The role was successfully deleted."));
        return result;
    }

    public static int getCollectionDefaultRead(Context context, int collectionID) throws SQLException, AuthorizeException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group[] itemGroups = AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)collection, (int)10);
        Group[] bitstreamGroups = AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)collection, (int)9);
        if (itemGroups.length != 1 && bitstreamGroups.length != 1) {
            return -1;
        }
        Group itemGroup = itemGroups[0];
        Group bitstreamGroup = bitstreamGroups[0];
        if (itemGroup.getID() != bitstreamGroup.getID()) {
            return -1;
        }
        return itemGroup.getID();
    }

    public static int createCollectionDefaultReadGroup(Context context, int collectionID) throws SQLException, AuthorizeException, UIException {
        int roleID = FlowContainerUtils.getCollectionDefaultRead(context, collectionID);
        if (roleID != 0) {
            throw new UIException("Unable to create a new default read group because either the group allready exists or multiple groups are assigned the default privleges.");
        }
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.create((Context)context);
        role.setName("COLLECTION_" + collection.getID() + "_DEFAULT_READ");
        AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)10);
        AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)9);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)role);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)role);
        role.update();
        context.commit();
        return role.getID();
    }

    public static FlowResult changeCollectionDefaultReadToAnonymous(Context context, int collectionID) throws SQLException, AuthorizeException, UIException {
        FlowResult result = new FlowResult();
        int roleID = FlowContainerUtils.getCollectionDefaultRead(context, collectionID);
        if (roleID < 1) {
            throw new UIException("Unable to delete the default read role because the role is either allready assigned to the anonymous group or multiple groups are assigned the default priveleges.");
        }
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.find((Context)context, (int)roleID);
        Group anonymous = Group.find((Context)context, (int)0);
        role.delete();
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)anonymous);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)anonymous);
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "All new items submitted to this collection will default to anonymous read."));
        return result;
    }

    public static FlowResult processDeleteCollection(Context context, int collectionID) throws SQLException, AuthorizeException, IOException {
        Community[] parents;
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        for (Community parent : parents = collection.getCommunities()) {
            parent.removeCollection(collection);
            parent.update();
        }
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully deleted."));
        return result;
    }

    public static FlowResult processCreateCollection(Context context, int communityID, Request request) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community parent = Community.find((Context)context, (int)communityID);
        Collection newCollection = parent.createCollection();
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        newCollection.setMetadata("name", name);
        newCollection.setMetadata("short_description", shortDescription);
        newCollection.setMetadata("introductory_text", introductoryText);
        newCollection.setMetadata("copyright_text", copyrightText);
        newCollection.setMetadata("side_bar_text", sideBarText);
        newCollection.setMetadata("license", license);
        newCollection.setMetadata("provenance_description", provenanceDescription);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            newCollection.setLogo(is);
        }
        newCollection.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully created."));
        result.setParameter("collectionID", newCollection.getID());
        return result;
    }

    public static FlowResult processCreateCommunity(Context context, int communityID, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community parent = Community.find((Context)context, (int)communityID);
        Community newCommunity = parent != null ? parent.createSubcommunity() : Community.create(null, (Context)context);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        newCommunity.setMetadata("name", name);
        newCommunity.setMetadata("short_description", shortDescription);
        newCommunity.setMetadata("introductory_text", introductoryText);
        newCommunity.setMetadata("copyright_text", copyrightText);
        newCommunity.setMetadata("side_bar_text", sideBarText);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            newCommunity.setLogo(is);
        }
        newCommunity.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully created."));
        result.setParameter("communityID", newCommunity.getID());
        return result;
    }

    public static FlowResult processEditCommunity(Context context, int communityID, boolean deleteLogo, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community community = Community.find((Context)context, (int)communityID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        community.setMetadata("name", name);
        community.setMetadata("short_description", shortDescription);
        community.setMetadata("introductory_text", introductoryText);
        community.setMetadata("copyright_text", copyrightText);
        community.setMetadata("side_bar_text", sideBarText);
        if (deleteLogo) {
            community.setLogo(null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                community.setLogo(is);
            }
        }
        community.update();
        context.commit();
        result.setContinue(true);
        return result;
    }

    public static FlowResult processDeleteCommunity(Context context, int communityID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community community = Community.find((Context)context, (int)communityID);
        community.delete();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully deleted."));
        return result;
    }

    public static String checkXMLFragment(String value) {
        value = FlowContainerUtils.escapeXMLEntities(value);
        String xml = "<fragment>" + value + "</fragment>";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        SAXBuilder builder = new SAXBuilder();
        try {
            builder.build((InputStream)inputStream);
        }
        catch (JDOMException jdome) {
            return jdome.getMessage();
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
        return null;
    }

    public static String escapeXMLEntities(String value) {
        if (value == null) {
            return null;
        }
        int amp = -1;
        while ((amp = value.indexOf(38, amp + 1)) > -1) {
            if (FlowContainerUtils.substringCompare(value, amp + 1, '#')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'a', 'm', 'p', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'a', 'p', 'o', 's', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'q', 'u', 'o', 't', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'l', 't', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'g', 't', ';')) continue;
            value = value.substring(0, amp) + "&amp;" + value.substring(amp + 1);
        }
        return value;
    }

    private static boolean substringCompare(String string, int index, char ... characters) {
        if (string.length() <= index + characters.length) {
            return false;
        }
        for (char character : characters) {
            if (string.charAt(index) != character) {
                return false;
            }
            ++index;
        }
        return false;
    }
}

