/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class EditEPersonForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditEPersonForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_save = EditEPersonForm.message((String)"xmlui.general.save");
    private static final Message T_submit_cancel = EditEPersonForm.message((String)"xmlui.general.cancel");
    private static final Message T_title = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.title");
    private static final Message T_eperson_trail = EditEPersonForm.message((String)"xmlui.administrative.eperson.general.epeople_trail");
    private static final Message T_trail = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.trail");
    private static final Message T_head1 = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.head1");
    private static final Message T_email_taken = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.email_taken");
    private static final Message T_head2 = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.head2");
    private static final Message T_error_email_unique = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.error_email_unique");
    private static final Message T_error_email = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.error_email");
    private static final Message T_error_fname = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.error_fname");
    private static final Message T_error_lname = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.error_lname");
    private static final Message T_req_certs = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.req_certs");
    private static final Message T_can_log_in = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.can_log_in");
    private static final Message T_submit_reset_password = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.submit_reset_password");
    private static final Message T_special_help = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.special_help");
    private static final Message T_submit_delete = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.submit_delete");
    private static final Message T_member_head = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.member_head");
    private static final Message T_indirect_member = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.indirect_member");
    private static final Message T_member_none = EditEPersonForm.message((String)"xmlui.administrative.eperson.EditEPersonForm.member_none");
    private static final Message T_email_address = EditEPersonForm.message((String)"xmlui.EPerson.EditProfile.email_address");
    private static final Message T_first_name = EditEPersonForm.message((String)"xmlui.EPerson.EditProfile.first_name");
    private static final Message T_last_name = EditEPersonForm.message((String)"xmlui.EPerson.EditProfile.last_name");
    private static final Message T_telephone = EditEPersonForm.message((String)"xmlui.EPerson.EditProfile.telephone");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/epeople", T_eperson_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        EPerson eperson;
        boolean admin = AuthorizeManager.isAdmin((Context)this.context);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        int epersonID = this.parameters.getParameterAsInteger("epersonID", -1);
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (errorString != null) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        if ((eperson = EPerson.find((Context)this.context, (int)epersonID)) == null) {
            throw new UIException("Unable to find eperson for id:" + epersonID);
        }
        String emailValue = eperson.getEmail();
        String firstValue = eperson.getFirstName();
        String lastValue = eperson.getLastName();
        String phoneValue = eperson.getMetadata("phone");
        boolean canLogInValue = eperson.canLogIn();
        boolean certificatValue = eperson.getRequireCertificate();
        if (request.getParameter("email_address") != null) {
            emailValue = request.getParameter("email_address");
        }
        if (request.getParameter("first_name") != null) {
            firstValue = request.getParameter("first_name");
        }
        if (request.getParameter("last_name") != null) {
            lastValue = request.getParameter("last_name");
        }
        if (request.getParameter("phone") != null) {
            phoneValue = request.getParameter("phone");
        }
        Division edit = body.addInteractiveDivision("eperson-edit", this.contextPath + "/admin/epeople", "post", "primary administrative eperson");
        edit.setHead(T_head1);
        if (errors.contains("eperson_email_key")) {
            Para problem = edit.addPara();
            problem.addHighlight("bold").addContent(T_email_taken);
        }
        List identity = edit.addList("form", "form");
        identity.setHead(T_head2.parameterize(new Object[]{eperson.getFullName()}));
        if (admin) {
            Text email = identity.addItem().addText("email_address");
            email.setRequired();
            email.setLabel(T_email_address);
            email.setValue(emailValue);
            if (errors.contains("eperson_email_key")) {
                email.addError(T_error_email_unique);
            } else if (errors.contains("email_address")) {
                email.addError(T_error_email);
            }
        } else {
            identity.addLabel(T_email_address);
            identity.addItem(emailValue);
        }
        if (admin) {
            Text firstName = identity.addItem().addText("first_name");
            firstName.setRequired();
            firstName.setLabel(T_first_name);
            firstName.setValue(firstValue);
            if (errors.contains("first_name")) {
                firstName.addError(T_error_fname);
            }
        } else {
            identity.addLabel(T_first_name);
            identity.addItem(firstValue);
        }
        if (admin) {
            Text lastName = identity.addItem().addText("last_name");
            lastName.setRequired();
            lastName.setLabel(T_last_name);
            lastName.setValue(lastValue);
            if (errors.contains("last_name")) {
                lastName.addError(T_error_lname);
            }
        } else {
            identity.addLabel(T_last_name);
            identity.addItem(lastValue);
        }
        if (admin) {
            Text phone = identity.addItem().addText("phone");
            phone.setLabel(T_telephone);
            phone.setValue(phoneValue);
        } else {
            identity.addLabel(T_telephone);
            identity.addItem(phoneValue);
        }
        if (admin) {
            CheckBox canLogInField = identity.addItem().addCheckBox("can_log_in");
            canLogInField.setLabel(T_can_log_in);
            canLogInField.addOption(canLogInValue, "true");
            CheckBox certificateField = identity.addItem().addCheckBox("certificate");
            certificateField.setLabel(T_req_certs);
            certificateField.addOption(certificatValue, "true");
            identity.addItem().addHighlight("italic").addContent(T_special_help);
            Item special = identity.addItem();
            special.addButton("submit_reset_password").setValue(T_submit_reset_password);
            special.addButton("submit_delete").setValue(T_submit_delete);
        }
        Item buttons = identity.addItem();
        if (admin) {
            buttons.addButton("submit_save").setValue(T_submit_save);
        }
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        if (admin) {
            Group[] groups;
            List member = edit.addList("eperson-member-of");
            member.setHead(T_member_head);
            for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)eperson)) {
                String url = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId() + "&submit_edit_group&groupID=" + group.getID();
                Item item = member.addItem();
                item.addXref(url, group.getName());
                Group via = this.findViaGroup(eperson, group);
                if (via == null) continue;
                item.addHighlight("fade").addContent(T_indirect_member.parameterize(new Object[]{via.getName()}));
            }
            if (groups.length <= 0) {
                member.addItem().addHighlight("italic").addContent(T_member_none);
            }
        }
        edit.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private Group findViaGroup(EPerson eperson, Group group) throws SQLException {
        Group[] groups;
        for (EPerson direct : group.getMembers()) {
            if (direct.getID() != eperson.getID()) continue;
            return null;
        }
        Group[] targets = group.getMemberGroups();
        for (Group member : groups = Group.allMemberGroups((Context)this.context, (EPerson)eperson)) {
            for (Group target : targets) {
                if (member.getID() != target.getID()) continue;
                return member;
            }
        }
        return null;
    }
}

