/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.submission.AbstractStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.File;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class AddBitstreamForm
extends AbstractStep {
    private static final Message T_dspace_home = AddBitstreamForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_cancel = AddBitstreamForm.message((String)"xmlui.general.cancel");
    private static final Message T_item_trail = AddBitstreamForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.title.");
    private static final Message T_trail = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.trail");
    private static final Message T_head1 = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.head1");
    private static final Message T_bundle_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_label");
    private static final Message T_bundle_original = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_original");
    private static final Message T_bundle_metadata = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_metadata");
    private static final Message T_bundle_thumbnail = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_thumbnail");
    private static final Message T_bundle_license = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_license");
    private static final Message T_bundle_cc_license = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_cc_license");
    private static final Message T_file_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.file_label");
    private static final Message T_file_help = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.file_help");
    private static final Message T_description_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.description_label");
    private static final Message T_description_help = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.description_help");
    private static final Message T_submit_upload = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.submit_upload");
    private static final Message T_no_bundles = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.no_bundles");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        Item item = Item.find((Context)this.context, (int)itemID);
        Division div = body.addInteractiveDivision("add-bitstream", this.contextPath + "/admin/item", "multipart", "primary administrative item");
        List upload = div.addList("submit-upload-new", "form");
        upload.setHead(T_head1);
        int bundleCount = 0;
        Select select = upload.addItem().addSelect("bundle");
        select.setLabel(T_bundle_label);
        if (this.addBundleOption(item, select, "ORIGINAL", T_bundle_original)) {
            ++bundleCount;
        }
        if (this.addBundleOption(item, select, "METADATA", T_bundle_metadata)) {
            ++bundleCount;
        }
        if (this.addBundleOption(item, select, "THUMBNAIL", T_bundle_thumbnail)) {
            ++bundleCount;
        }
        if (this.addBundleOption(item, select, "LICENSE", T_bundle_license)) {
            ++bundleCount;
        }
        if (this.addBundleOption(item, select, "CC_LICENSE", T_bundle_cc_license)) {
            ++bundleCount;
        }
        select.setOptionSelected("ORIGINAL");
        if (bundleCount == 0) {
            select.setDisabled();
        }
        File file = upload.addItem().addFile("file");
        file.setLabel(T_file_label);
        file.setHelp(T_file_help);
        file.setRequired();
        if (bundleCount == 0) {
            file.setDisabled();
        }
        Text description = upload.addItem().addText("description");
        description.setLabel(T_description_label);
        description.setHelp(T_description_help);
        if (bundleCount == 0) {
            description.setDisabled();
        }
        if (bundleCount == 0) {
            upload.addItem().addContent(T_no_bundles);
        }
        org.dspace.app.xmlui.wing.element.Item actions = upload.addItem();
        Button button = actions.addButton("submit_upload");
        button.setValue(T_submit_upload);
        if (bundleCount == 0) {
            button.setDisabled();
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    public boolean addBundleOption(Item item, Select select, String bundleName, Message bundleLabel) throws SQLException, WingException {
        Bundle[] bundles = item.getBundles(bundleName);
        if (bundles == null || bundles.length == 0) {
            if (!AuthorizeManager.isAdmin((Context)this.context)) {
                return false;
            }
        } else {
            Bundle bundle = bundles[0];
            if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bundle, (int)3)) {
                return false;
            }
            if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)bundle, (int)1)) {
                return false;
            }
        }
        select.addOption(bundleName, bundleLabel);
        return true;
    }
}

