/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class RestrictedItem
extends AbstractDSpaceTransformer {
    private static final Message T_title = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.title");
    private static final Message T_dspace_home = RestrictedItem.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.trail");
    private static final Message T_head = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head");
    private static final Message T_para = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        String type = null;
        String identifier = null;
        if (dso == null) {
            type = "resource";
            identifier = "unknown";
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            identifier = community.getMetadata("name");
            type = "community";
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            identifier = collection.getMetadata("name");
            type = "collection";
        } else {
            String handle = dso.getHandle();
            type = "item";
            identifier = handle == null || "".equals(handle) ? "internal ID: " + dso.getID() : "hdl:" + handle;
            if (request.getParameter("bitstreamId") != null) {
                type = "bitstream";
                try {
                    Bitstream bit = Bitstream.find((Context)this.context, (int)new Integer(request.getParameter("bitstreamId")));
                    identifier = bit != null ? bit.getName() : "unknown";
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        Division unauthorized = body.addDivision("unauthorized-item", "primary");
        unauthorized.setHead(T_head.parameterize(new Object[]{type}));
        unauthorized.addPara(T_para.parameterize(new Object[]{type, identifier}));
    }
}

