/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.xmlui.aspect.submission.FlowUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStep
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(AbstractStep.class);
    protected static final Message T_submission_title = AbstractStep.message((String)"xmlui.Submission.general.submission.title");
    protected static final Message T_submission_trail = AbstractStep.message((String)"xmlui.Submission.general.submission.trail");
    protected static final Message T_submission_head = AbstractStep.message((String)"xmlui.Submission.general.submission.head");
    protected static final Message T_previous = AbstractStep.message((String)"xmlui.Submission.general.submission.previous");
    protected static final Message T_save = AbstractStep.message((String)"xmlui.Submission.general.submission.save");
    protected static final Message T_next = AbstractStep.message((String)"xmlui.Submission.general.submission.next");
    protected static final Message T_complete = AbstractStep.message((String)"xmlui.Submission.general.submission.complete");
    protected static final Message T_dspace_home = AbstractStep.message((String)"xmlui.general.dspace_home");
    protected static final Message T_workflow_title = AbstractStep.message((String)"xmlui.Submission.general.workflow.title");
    protected static final Message T_workflow_trail = AbstractStep.message((String)"xmlui.Submission.general.workflow.trail");
    protected static final Message T_workflow_head = AbstractStep.message((String)"xmlui.Submission.general.workflow.head");
    protected static final Message T_showfull = AbstractStep.message((String)"xmlui.Submission.general.showfull");
    protected static final Message T_showsimple = AbstractStep.message((String)"xmlui.Submission.general.showsimple");
    protected static final Message T_initial_questions = AbstractStep.message((String)"xmlui.Submission.general.progress.initial_questions");
    protected static final Message T_describe = AbstractStep.message((String)"xmlui.Submission.general.progress.describe");
    protected static final Message T_upload = AbstractStep.message((String)"xmlui.Submission.general.progress.upload");
    protected static final Message T_review = AbstractStep.message((String)"xmlui.Submission.general.progress.review");
    protected static final Message T_creative_commons = AbstractStep.message((String)"xmlui.Submission.general.progress.creative_commons");
    protected static final Message T_license = AbstractStep.message((String)"xmlui.Submission.general.progress.license");
    protected String id;
    protected SubmissionInfo submissionInfo;
    protected InProgressSubmission submission;
    protected double stepAndPage;
    protected String handle;
    protected int errorFlag;
    protected List<String> errorFields;
    protected boolean requireSubmission = false;
    protected boolean requireWorkflow = false;
    protected boolean requireWorkspace = false;
    protected boolean requireStep = false;
    protected boolean requireHandle = false;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        try {
            this.id = parameters.getParameter("id", null);
            this.stepAndPage = Double.valueOf(parameters.getParameter("step", "-1"));
            this.handle = parameters.getParameter("handle", null);
            this.errorFlag = Integer.valueOf(parameters.getParameter("error", String.valueOf(AbstractProcessingStep.STATUS_COMPLETE)));
            this.errorFields = this.getErrorFields(parameters);
            if (this.id != null) {
                this.submissionInfo = FlowUtils.obtainSubmissionInfo(objectModel, this.id);
                this.submission = this.submissionInfo.getSubmissionItem();
            }
            if (this.requireSubmission && this.submission == null) {
                throw new ProcessingException("Unable to find submission for id: " + this.id);
            }
            if (this.requireWorkflow && !(this.submission instanceof WorkflowItem)) {
                throw new ProcessingException("The submission is not a workflow, " + this.id);
            }
            if (this.requireWorkspace && !(this.submission instanceof WorkspaceItem)) {
                throw new ProcessingException("The submission is not a workspace, " + this.id);
            }
            if (this.requireStep && this.stepAndPage < 0.0) {
                throw new ProcessingException("Step is a required parameter.");
            }
            if (this.requireHandle && this.handle == null) {
                throw new ProcessingException("Handle is a required parameter.");
            }
        }
        catch (SQLException sqle) {
            throw new ProcessingException("Unable to find submission.", (Throwable)sqle);
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.submission instanceof WorkspaceItem) {
            pageMeta.addMetadata("title").addContent(T_submission_title);
            Collection collection = this.submission.getCollection();
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)collection, pageMeta, this.contextPath);
            pageMeta.addTrail().addContent(T_submission_trail);
        } else if (this.submission instanceof WorkflowItem) {
            pageMeta.addMetadata("title").addContent("Workflow Task");
            Collection collection = this.submission.getCollection();
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)collection, pageMeta, this.contextPath);
            pageMeta.addTrail().addContent("Workflow Task");
        }
    }

    public void addSubmissionProgressList(Division div) throws WingException {
        org.dspace.app.xmlui.wing.element.List progress = div.addList("submit-progress", "progress");
        Map progBarInfo = this.submissionInfo.getProgressBarInfo();
        for (String entryNum : progBarInfo.keySet()) {
            String entryNameKey = "xmlui.Submission." + (String)progBarInfo.get(entryNum);
            double currentStepAndPage = Double.valueOf(entryNum);
            this.addJumpButton(progress, AbstractStep.message((String)entryNameKey), currentStepAndPage);
        }
    }

    public void addJumpButton(org.dspace.app.xmlui.wing.element.List list, Message buttonText, double stepAndPage) throws WingException {
        if (buttonText != null && stepAndPage > 0.0) {
            Button jumpButton = list.addItem("step_" + stepAndPage, this.renderJumpButton(stepAndPage)).addButton(AbstractProcessingStep.PROGRESS_BAR_PREFIX + stepAndPage);
            jumpButton.setValue(buttonText);
        }
    }

    public void addControlButtons(org.dspace.app.xmlui.wing.element.List controls) throws WingException {
        Item actions = controls.addItem();
        if (!this.isFirstStep()) {
            actions.addButton(AbstractProcessingStep.PREVIOUS_BUTTON).setValue(T_previous);
        }
        actions.addButton(AbstractProcessingStep.CANCEL_BUTTON).setValue(T_save);
        if (this.isLastStep()) {
            actions.addButton(AbstractProcessingStep.NEXT_BUTTON).setValue(T_complete);
        } else {
            actions.addButton(AbstractProcessingStep.NEXT_BUTTON).setValue(T_next);
        }
    }

    public int getStep() {
        return FlowUtils.getStep(this.stepAndPage);
    }

    public int getPage() {
        return FlowUtils.getPage(this.stepAndPage);
    }

    public boolean isFirstStep() {
        Set submissionPagesSet = this.submissionInfo.getProgressBarInfo().keySet();
        String[] submissionPages = submissionPagesSet.toArray(new String[submissionPagesSet.size()]);
        double firstStepAndPage = Double.valueOf(submissionPages[0]);
        return FlowUtils.getStep(firstStepAndPage) == this.getStep() && FlowUtils.getPage(firstStepAndPage) == this.getPage();
    }

    public boolean isLastStep() {
        boolean inWorkflow = this.submissionInfo.isInWorkflow();
        Set submissionPagesSet = this.submissionInfo.getProgressBarInfo().keySet();
        String[] submissionPages = submissionPagesSet.toArray(new String[submissionPagesSet.size()]);
        double lastStepAndPage = !inWorkflow ? Double.valueOf(submissionPages[submissionPages.length - 2]).doubleValue() : Double.valueOf(submissionPages[submissionPages.length - 1]).doubleValue();
        return FlowUtils.getStep(lastStepAndPage) == this.getStep() && FlowUtils.getPage(lastStepAndPage) == this.getPage();
    }

    public double getMaxStepAndPageReached() throws SQLException {
        if (this.submission instanceof WorkspaceItem) {
            int page;
            WorkspaceItem workspaceItem = (WorkspaceItem)this.submission;
            int step = workspaceItem.getStageReached();
            if (step < 0) {
                step = 0;
            }
            if ((page = workspaceItem.getPageReached()) < 0) {
                page = 0;
            }
            return Double.valueOf(step + "." + page);
        }
        return Double.MAX_VALUE;
    }

    public List<String> getErrorFields(Parameters parameters) {
        List<String> fields = new ArrayList<String>();
        String errors = parameters.getParameter("error_fields", "");
        if (errors != null && errors.length() > 0) {
            if (errors.indexOf(",") > 0) {
                fields = Arrays.asList(errors.split(","));
            } else {
                fields.add(errors);
            }
        }
        return fields;
    }

    private String renderJumpButton(double givenStepAndPage) {
        try {
            if (Double.compare(givenStepAndPage, this.stepAndPage) == 0) {
                return "current";
            }
            if (Double.compare(givenStepAndPage, this.getMaxStepAndPageReached()) > 0) {
                return "disabled";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void recycle() {
        this.id = null;
        this.submission = null;
        this.stepAndPage = -1.0;
        this.handle = null;
        this.errorFlag = 0;
        this.errorFields = null;
        super.recycle();
    }
}

