/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class BitstreamReader
extends AbstractReader
implements Recyclable {
    private static Logger log = Logger.getLogger(BitstreamReader.class);
    private static final String AUTH_REQUIRED_HEADER = "xmlui.BitstreamReader.auth_header";
    private static final String AUTH_REQUIRED_MESSAGE = "xmlui.BitstreamReader.auth_message";
    protected static final int BUFFER_SIZE = 8192;
    protected static final int expires = 216000000;
    protected Response response;
    protected Request request;
    protected InputStream bitstreamInputStream;
    protected long bitstreamSize;
    protected String bitstreamMimeType;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            Context context = ContextUtil.obtainContext(objectModel);
            int itemID = par.getParameterAsInteger("itemID", -1);
            int bitstreamID = par.getParameterAsInteger("bitstreamID", -1);
            String handle = par.getParameter("handle", null);
            int sequence = par.getParameterAsInteger("sequence", -1);
            String name = par.getParameter("name", null);
            Bitstream bitstream = null;
            Item item = null;
            DSpaceObject dso = null;
            if (bitstreamID > -1) {
                bitstream = Bitstream.find((Context)context, (int)bitstreamID);
            } else if (itemID > -1) {
                item = Item.find((Context)context, (int)itemID);
                if (sequence > -1) {
                    bitstream = this.findBitstreamBySequence(item, sequence);
                } else if (name != null) {
                    bitstream = this.findBitstreamByName(item, name);
                }
            } else if (handle != null) {
                dso = HandleManager.resolveToObject((Context)context, (String)handle);
                if (dso instanceof Item && sequence > -1) {
                    bitstream = this.findBitstreamBySequence((Item)dso, sequence);
                } else if (dso instanceof Item && name != null) {
                    bitstream = this.findBitstreamByName((Item)dso, name);
                }
            }
            if (bitstream == null) {
                throw new ResourceNotFoundException("Unable to locate bitstream");
            }
            if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)bitstream, (int)0)) {
                if (this.request.getSession().getAttribute("dspace.current.user.id") != null) {
                    String redictURL = this.request.getContextPath() + "/handle/";
                    if (item != null) {
                        redictURL = redictURL + item.getHandle();
                    } else if (dso != null) {
                        redictURL = redictURL + dso.getHandle();
                    }
                    redictURL = redictURL + "/restricted-resource?bitstreamId=" + bitstream.getID();
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
                AuthenticationUtil.interruptRequest(objectModel, AUTH_REQUIRED_HEADER, AUTH_REQUIRED_MESSAGE, null);
                String redictURL = this.request.getContextPath() + "/login";
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redictURL);
                return;
            }
            this.bitstreamInputStream = bitstream.retrieve();
            this.bitstreamSize = bitstream.getSize();
            this.bitstreamMimeType = bitstream.getFormat().getMIMEType();
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("bitstream_id=" + bitstream.getID())));
        }
        catch (SQLException sqle) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)sqle);
        }
        catch (AuthorizeException ae) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)ae);
        }
    }

    private Bitstream findBitstreamBySequence(Item item, int sequence) throws SQLException {
        Bundle[] bundles;
        if (item == null) {
            return null;
        }
        for (Bundle bundle : bundles = item.getBundles()) {
            Bitstream[] bitstreams;
            for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                if (bitstream.getSequenceID() != sequence) continue;
                return bitstream;
            }
        }
        return null;
    }

    private Bitstream findBitstreamByName(Item item, String name) throws SQLException {
        if (name == null || item == null) {
            return null;
        }
        int maxDepthPathSearch = 3;
        if (ConfigurationManager.getProperty((String)"xmlui.html.max-depth-guess") != null) {
            maxDepthPathSearch = ConfigurationManager.getIntProperty((String)"xmlui.html.max-depth-guess");
        }
        for (int i = 0; i < maxDepthPathSearch + 1; ++i) {
            int indexOfLastSlash;
            Bundle[] bundles;
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bitstreams;
                for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                    if (!name.equals(bitstream.getName())) continue;
                    return bitstream;
                }
            }
            int indexOfSlash = name.indexOf(47);
            if (indexOfSlash < 0) {
                return null;
            }
            name = name.substring(indexOfSlash + 1);
            if (i != maxDepthPathSearch - 1 || (indexOfLastSlash = name.lastIndexOf(47)) <= -1) continue;
            name = name.substring(indexOfLastSlash + 1);
        }
        return null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        ByteRange byteRange;
        int length;
        byte[] buffer;
        block12: {
            if (this.bitstreamInputStream == null) {
                return;
            }
            buffer = new byte[8192];
            length = -1;
            this.response.setDateHeader("Expires", System.currentTimeMillis() + 216000000L);
            String ranges = null;
            byteRange = null;
            if (ranges != null) {
                try {
                    ranges = ranges.substring(ranges.indexOf(61) + 1);
                    byteRange = new ByteRange(ranges);
                }
                catch (NumberFormatException e) {
                    byteRange = null;
                    if (!(this.response instanceof HttpResponse)) break block12;
                    ((HttpResponse)this.response).setStatus(416);
                }
            }
        }
        if (byteRange != null) {
            String entityRange;
            String entityLength;
            if (this.bitstreamSize != -1L) {
                entityLength = "" + this.bitstreamSize;
                entityRange = byteRange.intersection(new ByteRange(0L, this.bitstreamSize)).toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }
            this.response.setHeader("Content-Range", entityRange + "/" + entityLength);
            if (this.response instanceof HttpResponse) {
                ((HttpResponse)this.response).setStatus(206);
            }
            int pos = 0;
            while ((length = this.bitstreamInputStream.read(buffer)) > -1) {
                int posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange((long)pos, (long)posEnd));
                if (intersection != null) {
                    this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                }
                pos += length;
            }
        } else {
            this.response.setHeader("Content-Length", String.valueOf(this.bitstreamSize));
            while ((length = this.bitstreamInputStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
            this.out.flush();
        }
    }

    public String getMimeType() {
        return this.bitstreamMimeType;
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        this.bitstreamInputStream = null;
        this.bitstreamSize = 0L;
        this.bitstreamMimeType = null;
    }
}

