/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class FlowGroupUtils {
    private static final Message T_edit_group_success_notice = new Message("default", "xmlui.administrative.FlowGroupUtils.edit_group_success_notice");
    private static final Message T_delete_group_success_notice = new Message("default", "xmlui.administrative.FlowGroupUtils.delete_group_success_notice");
    private static final String COLLECTION_PREFIX = "COLLECTION_";
    private static final String[] COLLECTION_SUFFIXES = new String[]{"_SUBMIT", "_ADMIN", "_WFSTEP_1", "_WORKFLOW_STEP_1", "_WFSTEP_2", "_WORKFLOW_STEP_2", "_WFSTEP_3", "_WORKFLOW_STEP_3", "_DEFAULT_ITEM_READ"};

    public static String getName(Context context, int groupID) throws SQLException {
        if (groupID < 0) {
            return "New Group";
        }
        Group group = Group.find((Context)context, (int)groupID);
        if (group == null) {
            return "New Group";
        }
        return group.getName();
    }

    public static String[] getEPeopleMembers(Context context, int groupID) throws SQLException {
        if (groupID < 0) {
            return new String[0];
        }
        Group group = Group.find((Context)context, (int)groupID);
        if (group == null) {
            return new String[0];
        }
        EPerson[] epeople = group.getMembers();
        String[] epeopleIDs = new String[epeople.length];
        for (int i = 0; i < epeople.length; ++i) {
            epeopleIDs[i] = String.valueOf(epeople[i].getID());
        }
        return epeopleIDs;
    }

    public static String[] getGroupMembers(Context context, int groupID) throws SQLException {
        if (groupID < 0) {
            return new String[0];
        }
        Group group = Group.find((Context)context, (int)groupID);
        if (group == null) {
            return new String[0];
        }
        Group[] groups = group.getMemberGroups();
        String[] groupIDs = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            groupIDs[i] = String.valueOf(groups[i].getID());
        }
        return groupIDs;
    }

    public static String[] addMember(String[] list, String id) {
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(list));
        newList.add(id);
        return newList.toArray(new String[newList.size()]);
    }

    public static String[] removeMember(String[] list, String id) {
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(list));
        newList.remove(id);
        return newList.toArray(new String[newList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FlowResult processSaveGroup(Context context, int groupID, String newName, String[] newEPeopleIDsArray, String[] newGroupIDsArray) throws SQLException, AuthorizeException, UIException {
        FlowResult result = new FlowResult();
        try {
            newName = URLDecoder.decode(newName, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException(uee);
        }
        if (newName == null || newName.length() == 0) {
            result.setContinue(false);
            result.addError("group_name");
            result.setOutcome(false);
            result.setMessage(new Message("default", "The group name may not be blank."));
            return result;
        }
        Group group = null;
        if (groupID == -1) {
            Group potentialDuplicate = Group.findByName((Context)context, (String)newName);
            if (potentialDuplicate != null) {
                result.setContinue(false);
                result.addError("group_name");
                result.addError("group_name_duplicate");
                result.setOutcome(false);
                result.setMessage(new Message("default", "The group name is allready in use"));
                return result;
            }
            group = Group.create((Context)context);
            group.setName(newName);
        } else {
            group = Group.find((Context)context, (int)groupID);
            String name = group.getName();
            if (name == null || !name.equals(newName)) {
                Group potentialDuplicate = Group.findByName((Context)context, (String)newName);
                if (potentialDuplicate != null) {
                    result.setContinue(false);
                    result.addError("group_name");
                    result.addError("group_name_duplicate");
                    result.setOutcome(false);
                    result.setMessage(new Message("default", "The group name is allready in use"));
                    return result;
                }
                group.setName(newName);
            }
        }
        ArrayList<Integer> newEPeopleIDs = new ArrayList<Integer>();
        for (String epeopleID : newEPeopleIDsArray) {
            newEPeopleIDs.add(Integer.valueOf(epeopleID));
        }
        ArrayList<Integer> newGroupIDs = new ArrayList<Integer>();
        for (String string : newGroupIDsArray) {
            newGroupIDs.add(Integer.valueOf(string));
        }
        for (String string : group.getMembers()) {
            if (!newEPeopleIDs.contains(string.getID())) {
                group.removeMember((EPerson)string);
                continue;
            }
            newEPeopleIDs.remove((Object)string.getID());
        }
        for (String string : group.getMemberGroups()) {
            if (!newGroupIDs.contains(string.getID())) {
                group.removeMember((Group)string);
                continue;
            }
            newGroupIDs.remove((Object)group.getID());
        }
        for (Integer epersonID : newEPeopleIDs) {
            EPerson eperson = EPerson.find((Context)context, (int)epersonID);
            group.addMember(eperson);
        }
        Iterator i$ = newGroupIDs.iterator();
        while (true) {
            if (!i$.hasNext()) {
                group.update();
                context.commit();
                result.setParameter("groupID", group.getID());
                result.setContinue(true);
                result.setOutcome(true);
                result.setMessage(T_edit_group_success_notice);
                return result;
            }
            Integer _groupID = (Integer)i$.next();
            Group _group = Group.find((Context)context, (int)_groupID);
            group.addMember(_group);
        }
    }

    public static FlowResult processDeleteGroups(Context context, String[] groupIDs) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(true);
        for (String id : groupIDs) {
            Group groupDeleted = Group.find((Context)context, (int)Integer.valueOf(id));
            groupDeleted.delete();
        }
        result.setOutcome(true);
        result.setMessage(T_delete_group_success_notice);
        return result;
    }

    public static int getCollectionId(String groupName) {
        if (groupName != null && groupName.startsWith(COLLECTION_PREFIX)) {
            for (String suffix : COLLECTION_SUFFIXES) {
                if (!groupName.endsWith(suffix)) continue;
                String idString = groupName.substring(COLLECTION_PREFIX.length());
                idString = idString.substring(0, idString.length() - suffix.length());
                int collectionID = -1;
                try {
                    collectionID = Integer.valueOf(idString);
                    return collectionID;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return -1;
    }
}

