/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_context_head = Navigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_context_edit_item = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_item");
    private static final Message T_context_edit_collection = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_collection");
    private static final Message T_context_item_mapper = Navigation.message((String)"xmlui.administrative.Navigation.context_item_mapper");
    private static final Message T_context_edit_community = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_community");
    private static final Message T_context_create_collection = Navigation.message((String)"xmlui.administrative.Navigation.context_create_collection");
    private static final Message T_context_create_subcommunity = Navigation.message((String)"xmlui.administrative.Navigation.context_create_subcommunity");
    private static final Message T_context_create_community = Navigation.message((String)"xmlui.administrative.Navigation.context_create_community");
    private static final Message T_administrative_head = Navigation.message((String)"xmlui.administrative.Navigation.administrative_head");
    private static final Message T_administrative_access_control = Navigation.message((String)"xmlui.administrative.Navigation.administrative_access_control");
    private static final Message T_administrative_people = Navigation.message((String)"xmlui.administrative.Navigation.administrative_people");
    private static final Message T_administrative_groups = Navigation.message((String)"xmlui.administrative.Navigation.administrative_groups");
    private static final Message T_administrative_authorizations = Navigation.message((String)"xmlui.administrative.Navigation.administrative_authorizations");
    private static final Message T_administrative_registries = Navigation.message((String)"xmlui.administrative.Navigation.administrative_registries");
    private static final Message T_administrative_metadata = Navigation.message((String)"xmlui.administrative.Navigation.administrative_metadata");
    private static final Message T_administrative_format = Navigation.message((String)"xmlui.administrative.Navigation.administrative_format");
    private static final Message T_administrative_items = Navigation.message((String)"xmlui.administrative.Navigation.administrative_items");
    private static final Message T_administrative_withdrawn = Navigation.message((String)"xmlui.administrative.Navigation.administrative_withdrawn");
    private static final Message T_administrative_control_panel = Navigation.message((String)"xmlui.administrative.Navigation.administrative_control_panel");
    private SourceValidity validity;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        String key = this.context.getCurrentUser() != null ? this.context.getCurrentUser().getEmail() : "anonymous";
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    Group[] groups;
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add((DSpaceObject)this.eperson);
                    for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)this.eperson)) {
                        validity.add((DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        options.addList("account");
        List context = options.addList("context");
        List admin = options.addList("administrative");
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (item.canEdit()) {
                context.setHead(T_context_head);
                context.addItem().addXref(this.contextPath + "/admin/item?itemID=" + item.getID(), T_context_edit_item);
            }
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)11)) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/collection?collectionID=" + collection.getID(), T_context_edit_collection);
                context.addItemXref(this.contextPath + "/admin/mapper?collectionID=" + collection.getID(), T_context_item_mapper);
            }
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            if (community.canEditBoolean()) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/community?communityID=" + community.getID(), T_context_edit_community);
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)community, (int)3)) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/collection?createNew&communityID=" + community.getID(), T_context_create_collection);
            }
            if (AuthorizeManager.isAdmin((Context)this.context)) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/community?createNew&communityID=" + community.getID(), T_context_create_subcommunity);
            }
        }
        if ("community-list".equals(this.sitemapURI) && AuthorizeManager.isAdmin((Context)this.context)) {
            context.setHead(T_context_head);
            context.addItemXref(this.contextPath + "/admin/community?createNew", T_context_create_community);
        }
        if (AuthorizeManager.isAdmin((Context)this.context)) {
            admin.setHead(T_administrative_head);
            List epeople = admin.addList("epeople");
            List registries = admin.addList("registries");
            epeople.setHead(T_administrative_access_control);
            epeople.addItemXref(this.contextPath + "/admin/epeople", T_administrative_people);
            epeople.addItemXref(this.contextPath + "/admin/groups", T_administrative_groups);
            epeople.addItemXref(this.contextPath + "/admin/authorize", T_administrative_authorizations);
            registries.setHead(T_administrative_registries);
            registries.addItemXref(this.contextPath + "/admin/metadata-registry", T_administrative_metadata);
            registries.addItemXref(this.contextPath + "/admin/format-registry", T_administrative_format);
            admin.addItemXref(this.contextPath + "/admin/item", T_administrative_items);
            admin.addItemXref(this.contextPath + "/admin/withdrawn", T_administrative_withdrawn);
            admin.addItemXref(this.contextPath + "/admin/panel", T_administrative_control_panel);
        }
    }

    public int addContextualOptions(List context) throws SQLException, WingException {
        int options = 0;
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (item.canEdit()) {
                context.addItem().addXref(this.contextPath + "/admin/item?itemID=" + item.getID(), T_context_edit_item);
                ++options;
            }
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)11)) {
                context.addItemXref(this.contextPath + "/admin/collection?collectionID=" + collection.getID(), T_context_edit_collection);
                context.addItemXref(this.contextPath + "/admin/mapper?collectionID=" + collection.getID(), T_context_item_mapper);
                ++options;
            }
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            if (community.canEditBoolean()) {
                context.addItemXref(this.contextPath + "/admin/community?communityID=" + community.getID(), T_context_edit_community);
                ++options;
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)community, (int)3)) {
                context.addItemXref(this.contextPath + "/admin/collection?createNew&communityID=" + community.getID(), T_context_create_collection);
                context.addItemXref(this.contextPath + "/admin/community?createNew&communityID=" + community.getID(), T_context_create_subcommunity);
                ++options;
            }
        }
        if ("community-list".equals(this.sitemapURI) && AuthorizeManager.isAdmin((Context)this.context)) {
            context.addItemXref(this.contextPath + "/admin/community?createNew", T_context_create_community);
            ++options;
        }
        return options;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

