/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.Serializable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.PageMeta;

public class SystemwideAlerts
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_COUNTDOWN = SystemwideAlerts.message((String)"xmlui.administrative.SystemwideAlerts.countdown");
    private static boolean active;
    private static String message;
    private static long countDownToo;

    public Serializable getKey() {
        if (active) {
            return null;
        }
        return "1";
    }

    public SourceValidity getValidity() {
        if (active) {
            return null;
        }
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        if (active) {
            Metadata alert = pageMeta.addMetadata("alert", "message");
            long time = countDownToo - System.currentTimeMillis();
            if (time > 0L) {
                alert.addContent(T_COUNTDOWN.parameterize(new Object[]{time /= 60000L}));
            }
            alert.addContent(message);
        }
    }

    public static boolean isAlertActive() {
        return active;
    }

    public static void activateAlert() {
        active = true;
    }

    public static void deactivateAlert() {
        active = false;
    }

    public static void setMessage(String message) {
        SystemwideAlerts.message = message;
    }

    public static String getMessage() {
        return message;
    }

    public static long getCountDownToo() {
        return countDownToo;
    }

    public static void setCountDownToo(long countDownTo) {
        countDownToo = countDownTo;
    }
}

