/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.RequestInfo;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";
    public static final String REQUEST_INTERRUPTED_HEADER = "dspace.request.interrupted.header";
    public static final String REQUEST_INTERRUPTED_MESSAGE = "dspace.request.interrupted.message";
    public static final String REQUEST_INTERRUPTED_CHARACTERS = "dspace.request.interrupted.characters";
    private static final String CURRENT_USER = "dspace.current.user";
    private static final String CURRENT_USER_ID = "dspace.current.user.id";
    private static final String CURRENT_USER_ADDRESS = "dspace.current.user.address";

    public static Context Authenticate(Map objectModel, String email, String password, String realm) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.loggedIn(context, request, context.getCurrentUser());
        } else {
            int explicitStatus = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, (String)realm, (HttpServletRequest)request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.loggedIn(context, request, context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context AuthenticateImplicit(Map objectModel) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.loggedIn(context, request, context.getCurrentUser());
        }
        return context;
    }

    public static void loggedIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        int[] groupIDs;
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        request.setAttribute(CURRENT_USER, (Object)eperson);
        session.setAttribute(CURRENT_USER_ID, (Object)eperson.getID());
        session.setAttribute(CURRENT_USER_ADDRESS, (Object)request.getRemoteAddr());
    }

    public static void loggedIn(Map objectModel, EPerson eperson) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        AuthenticationUtil.loggedIn(context, request, eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        String address;
        Integer id;
        HttpSession session = request.getSession(false);
        if (session != null && (id = (Integer)session.getAttribute(CURRENT_USER_ID)) != null && (address = (String)session.getAttribute(CURRENT_USER_ADDRESS)) != null && address.equals(request.getRemoteAddr())) {
            EPerson eperson = EPerson.find((Context)context, (int)id);
            AuthenticationUtil.loggedIn(context, request, eperson);
        }
    }

    public static void loggedOut(Context context, HttpServletRequest request) {
        HttpSession session = request.getSession();
        context.setCurrentUser(null);
        request.removeAttribute(CURRENT_USER);
        session.removeAttribute(CURRENT_USER_ID);
        session.removeAttribute(CURRENT_USER_ADDRESS);
    }

    public static boolean canSelfRegister(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        return AuthenticationManager.canSelfRegister((Context)context, (HttpServletRequest)request, (String)email);
    }

    public static boolean allowSetPassword(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        return AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)email);
    }

    public static EPerson createNewEperson(Map objectModel, String email) throws SQLException, AuthorizeException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        context.setIgnoreAuthorization(true);
        EPerson eperson = EPerson.create((Context)context);
        eperson.setEmail(email);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        eperson.update();
        context.setIgnoreAuthorization(false);
        AuthenticationManager.initEPerson((Context)context, (HttpServletRequest)request, (EPerson)eperson);
        return eperson;
    }

    public static boolean isInterupptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        Object interruptedObject = session.getAttribute(REQUEST_INTERRUPTED);
        return interruptedObject instanceof RequestInfo;
    }

    public static void interruptRequest(Map objectModel, String header, String message, String characters) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        RequestInfo interruptedRequest = new RequestInfo(request);
        session.setAttribute(REQUEST_INTERRUPTED, (Object)interruptedRequest);
        session.setAttribute(REQUEST_RESUME, null);
        session.setAttribute(REQUEST_INTERRUPTED_HEADER, (Object)header);
        session.setAttribute(REQUEST_INTERRUPTED_MESSAGE, (Object)message);
        session.setAttribute(REQUEST_INTERRUPTED_CHARACTERS, (Object)characters);
    }

    public static String resumeInterruptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        session.setAttribute(REQUEST_INTERRUPTED_HEADER, null);
        session.setAttribute(REQUEST_INTERRUPTED_MESSAGE, null);
        session.setAttribute(REQUEST_INTERRUPTED_CHARACTERS, null);
        Object interruptedObject = session.getAttribute(REQUEST_INTERRUPTED);
        if (interruptedObject instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)interruptedObject;
            session.setAttribute(REQUEST_INTERRUPTED, null);
            session.setAttribute(REQUEST_RESUME, (Object)interruptedRequest);
            return interruptedRequest.getServletPath();
        }
        return null;
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute(REQUEST_RESUME);
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute(REQUEST_INTERRUPTED, null);
                session.setAttribute(REQUEST_RESUME, null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }
}

