/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXFilter
implements ContentHandler,
LexicalHandler {
    private boolean allowDocuments = false;
    private boolean allowDocumentLocators = false;
    private boolean allowProcessingInstructions = false;
    private boolean allowPrefixMappings = false;
    private boolean allowElements = false;
    private boolean allowIgnorableWhitespace = false;
    private boolean allowSkippedEntities = false;
    private boolean allowCharacters = false;
    private boolean allowDTDs = false;
    private boolean allowEntities = false;
    private boolean allowCDATA = false;
    private boolean allowComments = false;
    private int minimumElementLevel = -1;
    private int currentElementLevel = 0;
    private String defaultURI;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private NamespaceSupport namespaces;

    public SAXFilter(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.namespaces = namespaces;
    }

    public SAXFilter allowDocuments() {
        this.allowDocuments = true;
        return this;
    }

    public SAXFilter allowDocumentLocators() {
        this.allowDocumentLocators = true;
        return this;
    }

    public SAXFilter allowProcessingInstructions() {
        this.allowProcessingInstructions = true;
        return this;
    }

    public SAXFilter allowPrefixMappings() {
        this.allowPrefixMappings = true;
        return this;
    }

    public SAXFilter allowElements() {
        this.allowElements = true;
        return this;
    }

    public SAXFilter allowElements(int minimumElementLevel) {
        this.allowElements = true;
        this.minimumElementLevel = minimumElementLevel;
        return this;
    }

    public SAXFilter allowIgnorableWhitespace() {
        this.allowIgnorableWhitespace = true;
        return this;
    }

    public SAXFilter allowSkippedEntities() {
        this.allowSkippedEntities = true;
        return this;
    }

    public SAXFilter allowCharacters() {
        this.allowCharacters = true;
        return this;
    }

    public SAXFilter allowDTDs() {
        this.allowDTDs = true;
        return this;
    }

    public SAXFilter allowEntities() {
        this.allowEntities = true;
        return this;
    }

    public SAXFilter allowCDATA() {
        this.allowCDATA = true;
        return this;
    }

    public SAXFilter allowComments() {
        this.allowComments = true;
        return this;
    }

    public SAXFilter setDefaultNamespace(String uri) {
        this.defaultURI = uri;
        return this;
    }

    public void startDocument() throws SAXException {
        if (this.allowDocuments) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.allowDocuments) {
            this.contentHandler.endDocument();
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.allowDocumentLocators) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.allowProcessingInstructions) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.allowPrefixMappings) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.allowPrefixMappings) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.allowElements) {
            ++this.currentElementLevel;
            if (this.minimumElementLevel < this.currentElementLevel) {
                if (this.defaultURI != null && (uri == null || "".equals(uri))) {
                    String prefix = this.namespaces.getPrefix(this.defaultURI);
                    if (prefix != null && !"".equals(prefix)) {
                        qName = prefix + ":" + localName;
                    }
                    this.contentHandler.startElement(this.defaultURI, localName, qName, atts);
                } else {
                    this.contentHandler.startElement(uri, localName, localName, atts);
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.allowElements) {
            if (this.minimumElementLevel < this.currentElementLevel) {
                if (this.defaultURI != null && (uri == null || "".equals(uri))) {
                    String prefix = this.namespaces.getPrefix(this.defaultURI);
                    if (prefix != null && !"".equals(prefix)) {
                        qName = prefix + ":" + localName;
                    }
                    this.contentHandler.endElement(this.defaultURI, localName, qName);
                } else {
                    this.contentHandler.endElement(uri, localName, localName);
                }
            }
            --this.currentElementLevel;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.allowIgnorableWhitespace) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.allowSkippedEntities) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.allowCharacters) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.allowDTDs) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.allowDTDs) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.allowEntities) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.allowEntities) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.allowCDATA) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.allowCDATA) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.allowComments) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }
}

