/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.WebContinuationDataBean;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class ControlPanel
extends AbstractDSpaceTransformer
implements Serviceable {
    private static final Message T_DSPACE_HOME = ControlPanel.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = ControlPanel.message((String)"xmlui.administrative.ControlPanel.title");
    private static final Message T_trail = ControlPanel.message((String)"xmlui.administrative.ControlPanel.trail");
    private static final Message T_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.head");
    private static final Message T_option_java = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_java");
    private static final Message T_option_dspace = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_dspace");
    private static final Message T_option_knots = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_knots");
    private static final Message T_option_alerts = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_alerts");
    private static final Message T_JAVA_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_head");
    private static final Message T_JAVA_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_version");
    private static final Message T_JAVA_VENDOR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_vendor");
    private static final Message T_OS_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_name");
    private static final Message T_OS_ARCH = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_arch");
    private static final Message T_OS_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_version");
    private static final Message T_RUNTIME_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_head");
    private static final Message T_RUNTIME_PROCESSORS = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_processors");
    private static final Message T_RUNTIME_MAX = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_max");
    private static final Message T_RUNTIME_TOTAL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_total");
    private static final Message T_RUNTIME_USED = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_used");
    private static final Message T_RUNTIME_FREE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_free");
    private static final Message T_DSPACE_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_head");
    private static final Message T_DSPACE_DIR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_dir");
    private static final Message T_DSPACE_URL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_url");
    private static final Message T_DSPACE_HOST_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_hostname");
    private static final Message T_DSPACE_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_name");
    private static final Message T_DB_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_name");
    private static final Message T_DB_URL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_url");
    private static final Message T_DB_DRIVER = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_driver");
    private static final Message T_DB_MAX_CONN = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxconnections");
    private static final Message T_DB_MAX_WAIT = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxwait");
    private static final Message T_DB_MAX_IDLE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxidle");
    private static final Message T_MAIL_SERVER = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_server");
    private static final Message T_MAIL_FROM_ADDRESS = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_from_address");
    private static final Message T_FEEDBACK_RECIPIENT = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_feedback_recipient");
    private static final Message T_MAIL_ADMIN = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_admin");
    private static final Message T_knots_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_head");
    private static final Message T_knots_column1 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_column1");
    private static final Message T_knots_column2 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_column2");
    private static final Message T_knots_column3 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_column3");
    private static final Message T_knots_hours = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_hours");
    private static final Message T_knots_minutes = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_minutes");
    private static final Message T_knots_expired = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_expired");
    private static final Message T_knots_active = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_active");
    private static final Message T_knots_none = ControlPanel.message((String)"xmlui.administrative.ControlPanel.knots_none");
    private static final Message T_alerts_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_head");
    private static final Message T_alerts_warning = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_warning");
    private static final Message T_alerts_message_label = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_message_label");
    private static final Message T_alerts_message_default = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_message_default");
    private static final Message T_alerts_countdown_label = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_label");
    private static final Message T_alerts_countdown_none = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_none");
    private static final Message T_alerts_countdown_5 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_5");
    private static final Message T_alerts_countdown_15 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_15");
    private static final Message T_alerts_countdown_30 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_30");
    private static final Message T_alerts_countdown_60 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_60");
    private static final Message T_alerts_countdown_keep = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_keep");
    private static final Message T_alerts_submit_activate = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_submit_activate");
    private static final Message T_alerts_submit_deactivate = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_submit_deactivate");
    private static final Message T_select_panel = ControlPanel.message((String)"xmlui.administrative.ControlPanel.select_panel");
    private ServiceManager serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_DSPACE_HOME);
        pageMeta.addTrailLink(this.contextPath + "/admin/panel", T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (!AuthorizeManager.isAdmin((Context)this.context)) {
            throw new AuthorizeException("You are not authorized to view this page.");
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        OPTIONS option = null;
        if (request.getParameter("java") != null) {
            option = OPTIONS.java;
        }
        if (request.getParameter("dspace") != null) {
            option = OPTIONS.dspace;
        }
        if (request.getParameter("knots") != null) {
            option = OPTIONS.knots;
        }
        if (request.getParameter("alerts") != null) {
            option = OPTIONS.alerts;
        }
        Division div = body.addInteractiveDivision("control-panel", this.contextPath + "/admin/panel", "post", "primary administrative");
        div.setHead(T_head);
        org.dspace.app.xmlui.wing.element.List options = div.addList("options", "simple", "horizontal");
        if (option == OPTIONS.java) {
            options.addItem().addHighlight("bold").addXref("?java", T_option_java);
        } else {
            options.addItemXref("?java", T_option_java);
        }
        if (option == OPTIONS.dspace) {
            options.addItem().addHighlight("bold").addXref("?dspace", T_option_dspace);
        } else {
            options.addItemXref("?dspace", T_option_dspace);
        }
        if (option == OPTIONS.knots) {
            options.addItem().addHighlight("bold").addXref("?knots", T_option_knots);
        } else {
            options.addItemXref("?knots", T_option_knots);
        }
        if (option == OPTIONS.alerts) {
            options.addItem().addHighlight("bold").addXref("?alerts", T_option_alerts);
        } else {
            options.addItemXref("?alerts", T_option_alerts);
        }
        if (option == OPTIONS.java) {
            this.addJavaInformation(div);
        } else if (option == OPTIONS.dspace) {
            this.addDSpaceConfiguration(div);
        } else if (option == OPTIONS.knots) {
            this.addWebContinuations(div);
        } else if (option == OPTIONS.alerts) {
            this.addAlerts(div);
        } else {
            div.addPara(T_select_panel);
        }
    }

    private void addJavaInformation(Division div) throws WingException {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        maxMemory = maxMemory / 1024L / 1024L;
        totalMemory = totalMemory / 1024L / 1024L;
        usedMemory = usedMemory / 1024L / 1024L;
        freeMemory = freeMemory / 1024L / 1024L;
        org.dspace.app.xmlui.wing.element.List list = div.addList("javaOs");
        list.setHead(T_JAVA_HEAD);
        list.addLabel(T_JAVA_VERSION);
        list.addItem(System.getProperty("java.version"));
        list.addLabel(T_JAVA_VENDOR);
        list.addItem(System.getProperty("java.vendor"));
        list.addLabel(T_OS_NAME);
        list.addItem(System.getProperty("os.name"));
        list.addLabel(T_OS_ARCH);
        list.addItem(System.getProperty("os.arch"));
        list.addLabel(T_OS_VERSION);
        list.addItem(System.getProperty("os.version"));
        org.dspace.app.xmlui.wing.element.List runtime = div.addList("runtime");
        runtime.setHead(T_RUNTIME_HEAD);
        runtime.addLabel(T_RUNTIME_PROCESSORS);
        runtime.addItem(String.valueOf(processors));
        runtime.addLabel(T_RUNTIME_MAX);
        runtime.addItem(String.valueOf(maxMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_TOTAL);
        runtime.addItem(String.valueOf(totalMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_USED);
        runtime.addItem(String.valueOf(usedMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_FREE);
        runtime.addItem(String.valueOf(freeMemory) + " MiB");
    }

    private void addDSpaceConfiguration(Division div) throws WingException {
        org.dspace.app.xmlui.wing.element.List dspace = div.addList("dspace");
        dspace.setHead(T_DSPACE_HEAD);
        dspace.addLabel(T_DSPACE_DIR);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.dir"));
        dspace.addLabel(T_DSPACE_URL);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.url"));
        dspace.addLabel(T_DSPACE_HOST_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.hostname"));
        dspace.addLabel(T_DSPACE_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.name"));
        dspace.addLabel(T_DB_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.name"));
        dspace.addLabel(T_DB_URL);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.url"));
        dspace.addLabel(T_DB_DRIVER);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.driver"));
        dspace.addLabel(T_DB_MAX_CONN);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxconnections"));
        dspace.addLabel(T_DB_MAX_WAIT);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxwait"));
        dspace.addLabel(T_DB_MAX_IDLE);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxidle"));
        dspace.addLabel(T_MAIL_SERVER);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.server"));
        dspace.addLabel(T_MAIL_FROM_ADDRESS);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.from.address"));
        dspace.addLabel(T_FEEDBACK_RECIPIENT);
        dspace.addItem(ConfigurationManager.getProperty((String)"feedback.recipient"));
        dspace.addLabel(T_MAIL_ADMIN);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.admin"));
    }

    private void addWebContinuations(Division div) throws WingException {
        ArrayList<WebContinuation> knots = new ArrayList<WebContinuation>();
        try {
            ContinuationsManager continuationManager = (ContinuationsManager)this.serviceManager.lookup(ContinuationsManager.ROLE);
            List knotBeans = continuationManager.getWebContinuationsDataBeanList();
            for (WebContinuationDataBean flow : knotBeans) {
                WebContinuation knot = continuationManager.lookupWebContinuation(flow.getId(), flow.getInterpreterId());
                if (knot == null) continue;
                knots.add(knot);
            }
            Collections.sort(knots, new WebContinuationByAccessTimeComparator());
            Collections.reverse(knots);
        }
        catch (ServiceException se) {
            throw new UIException("Unable to query continuation states.", se);
        }
        Table activeFlows = div.addTable("knots", 1, 1);
        activeFlows.setHead(T_knots_head);
        Row row = activeFlows.addRow("header");
        row.addCellContent(T_knots_column1);
        row.addCellContent(T_knots_column2);
        row.addCellContent(T_knots_column3);
        for (WebContinuation knot : knots) {
            String interpreter = knot.getInterpreterId();
            if (interpreter != null && interpreter.length() > 45) {
                interpreter = "..." + interpreter.substring(interpreter.length() - 43);
            }
            Message lastAccessMessage = null;
            long lastAccess = System.currentTimeMillis() - knot.getLastAccessTime();
            lastAccessMessage = lastAccess > 0x6DDD00L ? T_knots_hours.parameterize(new Object[]{lastAccess / 3600000L}) : T_knots_minutes.parameterize(new Object[]{lastAccess / 60000L});
            row = activeFlows.addRow();
            row.addCellContent(interpreter);
            row.addCellContent(lastAccessMessage);
            row.addCellContent(knot.hasExpired() ? T_knots_expired : T_knots_active);
        }
        if (knots.size() == 0) {
            activeFlows.addRow().addCell(1, 3).addContent(T_knots_none);
        }
    }

    private void addAlerts(Division div) throws WingException {
        div.addHidden("alerts").setValue("true");
        org.dspace.app.xmlui.wing.element.List form = div.addList("system-wide-alerts", "form");
        form.setHead(T_alerts_head);
        form.addItem(T_alerts_warning);
        TextArea message = form.addItem().addTextArea("message");
        message.setLabel(T_alerts_message_label);
        message.setSize(5, 45);
        if (SystemwideAlerts.getMessage() == null) {
            message.setValue(T_alerts_message_default);
        } else {
            message.setValue(SystemwideAlerts.getMessage());
        }
        Select countdown = form.addItem().addSelect("countdown");
        countdown.setLabel(T_alerts_countdown_label);
        countdown.addOption(0, T_alerts_countdown_none);
        countdown.addOption(5, T_alerts_countdown_5);
        countdown.addOption(15, T_alerts_countdown_15);
        countdown.addOption(30, T_alerts_countdown_30);
        countdown.addOption(60, T_alerts_countdown_60);
        if (SystemwideAlerts.isAlertActive() && SystemwideAlerts.getCountDownToo() - System.currentTimeMillis() > 0L) {
            countdown.addOption(true, -1, T_alerts_countdown_keep);
        } else {
            countdown.setOptionSelected(0);
        }
        Item actions = form.addItem();
        actions.addButton("submit_activate").setValue(T_alerts_submit_activate);
        actions.addButton("submit_deactivate").setValue(T_alerts_submit_deactivate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WebContinuationByAccessTimeComparator<WC extends WebContinuation>
    implements Comparator<WC> {
        @Override
        public int compare(WC a, WC b) {
            if (a.getLastAccessTime() > b.getLastAccessTime()) {
                return 1;
            }
            if (a.getLastAccessTime() > b.getLastAccessTime()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OPTIONS {
        java,
        dspace,
        knots,
        alerts;

    }
}

