/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.SAXFilter;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ItemAdapter
extends AbstractAdapter {
    private Item item;
    private List<Bitstream> contentBitstreams = new ArrayList<Bitstream>();
    private Bitstream primaryBitstream;
    private StringBuffer dmdSecIDS;

    public ItemAdapter(Item item, String contextPath) {
        super(contextPath);
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    protected String getMETSOBJID() {
        if (this.item.getHandle() != null) {
            return this.contextPath + "/handle/" + this.item.getHandle();
        }
        return null;
    }

    protected String getMETSOBJEDIT() {
        return this.contextPath + "/admin/item?itemID=" + this.item.getID();
    }

    protected String getMETSID() {
        if (this.item.getHandle() == null) {
            return "item:" + this.item.getID();
        }
        return "hdl:" + this.item.getHandle();
    }

    protected String getMETSProfile() throws WingException {
        return "DSPACE METS SIP Profile 1.0";
    }

    protected String getMETSLabel() {
        return "DSpace Item";
    }

    protected String getFileID(Bitstream bitstream) {
        return "file_" + bitstream.getID();
    }

    protected String getGroupFileID(Bitstream bitstream) {
        return "group_file_" + bitstream.getID();
    }

    protected void renderDescriptiveSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        AttributeMap attributes;
        String groupID = this.getGenericID("group_dmd_");
        this.dmdSecIDS = new StringBuffer();
        if (this.dmdTypes.size() == 0 || this.dmdTypes.contains("DIM")) {
            DCValue[] dcvs;
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append("" + dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", attributes);
            attributes = new AttributeMap();
            attributes.put((Object)"MDTYPE", (Object)"OTHER");
            attributes.put((Object)"OTHERMDTYPE", (Object)"DIM");
            this.startElement(METS, "mdWrap", attributes);
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            attributes = new AttributeMap();
            attributes.put((Object)"dspaceType", (Object)Constants.typeText[this.item.getType()]);
            if (this.item.isWithdrawn()) {
                attributes.put((Object)"withdrawn", (Object)"y");
            }
            this.startElement(DIM, "dim", attributes);
            for (DCValue dcv : dcvs = this.item.getMetadata("*", "*", "*", "*")) {
                attributes = new AttributeMap();
                attributes.put((Object)"mdschema", (Object)dcv.schema);
                attributes.put((Object)"element", (Object)dcv.element);
                if (dcv.qualifier != null) {
                    attributes.put((Object)"qualifier", (Object)dcv.qualifier);
                }
                if (dcv.language != null) {
                    attributes.put((Object)"language", (Object)dcv.language);
                }
                this.startElement(DIM, "field", attributes);
                this.sendCharacters(dcv.value);
                this.endElement(DIM, "field");
            }
            this.endElement(DIM, "dim");
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
        }
        for (String dmdType : this.dmdTypes) {
            DisseminationCrosswalk crosswalk;
            if ("DIM".equals(dmdType) || (crosswalk = this.getDisseminationCrosswalk(dmdType)) == null) continue;
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append(" " + dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", attributes);
            attributes = new AttributeMap();
            if (this.isDefinedMETStype(dmdType)) {
                attributes.put((Object)"MDTYPE", (Object)dmdType);
            } else {
                attributes.put((Object)"MDTYPE", (Object)"OTHER");
                attributes.put((Object)"OTHERMDTYPE", (Object)dmdType);
            }
            this.startElement(METS, "mdWrap", attributes);
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            try {
                Element dissemination = crosswalk.disseminateElement((DSpaceObject)this.item);
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                SAXOutputter outputter = new SAXOutputter();
                outputter.setContentHandler((ContentHandler)filter);
                outputter.setLexicalHandler((LexicalHandler)filter);
                outputter.output(dissemination);
            }
            catch (JDOMException jdome) {
                throw new WingException((Throwable)jdome);
            }
            catch (AuthorizeException ae) {
                // empty catch block
            }
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
        }
        Boolean include = ConfigurationManager.getBooleanProperty((String)"xmlui.bitstream.mods");
        if (include.booleanValue() && this.dmdTypes.contains("MODS")) {
            Bundle[] bundles;
            String groupID2 = this.getGenericID("group_dmd_");
            for (Bundle bundle : bundles = this.item.getBundles("METADATA")) {
                Bitstream bitstream = bundle.getBitstreamByName("MODS.xml");
                if (bitstream == null) continue;
                String dmdID = this.getGenericID("dmd_");
                attributes = new AttributeMap();
                attributes.put((Object)"ID", (Object)dmdID);
                attributes.put((Object)"GROUPID", (Object)groupID2);
                this.startElement(METS, "dmdSec", attributes);
                attributes = new AttributeMap();
                attributes.put((Object)"MDTYPE", (Object)"MODS");
                this.startElement(METS, "mdWrap", attributes);
                this.startElement(METS, "xmlData", new AttributeMap[0]);
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(filter);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
                try {
                    InputStream is = bitstream.retrieve();
                    reader.parse(new InputSource(is));
                }
                catch (AuthorizeException ae) {
                    // empty catch block
                }
                this.endElement(METS, "xmlData");
                this.endElement(METS, "mdWrap");
                this.endElement(METS, "dmdSec");
            }
        }
    }

    protected void renderFileSection() throws SQLException, SAXException {
        List<Object> bundles;
        this.startElement(METS, "fileSec", new AttributeMap[0]);
        if (this.fileGrpTypes.size() == 0) {
            bundles = Arrays.asList(this.item.getBundles());
        } else {
            bundles = new ArrayList();
            for (String string : this.fileGrpTypes) {
                for (Bundle newBundle : this.item.getBundles(string)) {
                    bundles.add(newBundle);
                }
            }
        }
        for (Bundle bundle : bundles) {
            String use = bundle.getName();
            boolean isContentBundle = false;
            boolean isDerivedBundle = false;
            if ("ORIGINAL".equals(use)) {
                use = "CONTENT";
                isContentBundle = true;
            }
            if ("TEXT".equals(bundle.getName()) || "THUMBNAIL".equals(bundle.getName())) {
                isDerivedBundle = true;
            }
            if (this.fileGrpTypes.size() != 0 && !this.fileGrpTypes.contains(use)) continue;
            AttributeMap attributes = new AttributeMap();
            attributes.put((Object)"USE", (Object)use);
            this.startElement(METS, "fileGrp", attributes);
            for (Bitstream bitstream : bundle.getBitstreams()) {
                String fileID = this.getFileID(bitstream);
                Bitstream originalBitstream = null;
                if (isDerivedBundle) {
                    originalBitstream = ItemAdapter.findOriginalBitstream(this.item, bitstream);
                }
                String groupID = this.getGroupFileID(originalBitstream == null ? bitstream : originalBitstream);
                this.renderFile(this.item, bitstream, fileID, groupID);
                if (!isContentBundle) continue;
                this.contentBitstreams.add(bitstream);
                if (bundle.getPrimaryBitstreamID() != bitstream.getID()) continue;
                this.primaryBitstream = bitstream;
            }
            this.endElement(METS, "fileGrp");
        }
        this.endElement(METS, "fileSec");
    }

    protected void renderStructureMap() throws SQLException, SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"LOGICAL");
        attributes.put((Object)"LABEL", (Object)"DSpace");
        this.startElement(METS, "structMap", attributes);
        attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"DSpace Item");
        if (this.dmdSecIDS != null) {
            attributes.put((Object)"DMDID", (Object)this.dmdSecIDS.toString());
        }
        this.startElement(METS, "div", attributes);
        if (this.primaryBitstream != null) {
            attributes = new AttributeMap();
            String fileID = this.getFileID(this.primaryBitstream);
            attributes.put((Object)"FILEID", (Object)fileID);
            this.startElement(METS, "fptr", attributes);
            this.endElement(METS, "fptr");
        }
        for (Bitstream bitstream : this.contentBitstreams) {
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)this.getGenericID("div_"));
            attributes.put((Object)"TYPE", (Object)"DSpace Content Bitstream");
            this.startElement(METS, "div", attributes);
            attributes = new AttributeMap();
            String fileID = this.getFileID(bitstream);
            attributes.put((Object)"FILEID", (Object)fileID);
            this.startElement(METS, "fptr", attributes);
            this.endElement(METS, "fptr");
            this.endElement(METS, "div");
        }
        this.endElement(METS, "div");
        this.endElement(METS, "structMap");
    }

    protected void renderExtraSections() throws SAXException, SQLException, IOException {
        Bundle[] bundles;
        Boolean include = ConfigurationManager.getBooleanProperty((String)"xmlui.bitstream.mets");
        if (!include.booleanValue()) {
            return;
        }
        for (Bundle bundle : bundles = this.item.getBundles("METADATA")) {
            Bitstream bitstream = bundle.getBitstreamByName("METS.xml");
            if (bitstream == null) continue;
            try {
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                filter.allowElements(1);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(filter);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
                reader.parse(new InputSource(bitstream.retrieve()));
            }
            catch (AuthorizeException ae) {
                // empty catch block
            }
        }
    }

    protected static Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        Bundle[] bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().length() - 4);
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getName() == null || !bundles[i].getName().equals("ORIGINAL")) continue;
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int bsnum = 0; bsnum < bitstreams.length; ++bsnum) {
                if (!bitstreams[bsnum].getName().equals(originalFilename)) continue;
                return bitstreams[bsnum];
            }
        }
        return null;
    }
}

