/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentActivityAction
extends AbstractAction {
    public static int MAX_EVENTS = 250;
    public static String IP_HEADER = "X-Forwarded-For";
    private static Queue<Event> events = new LinkedList<Event>();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext(objectModel);
        Event event = new Event(context, request);
        events.add(event);
        while (events.size() > MAX_EVENTS) {
            events.poll();
        }
        return null;
    }

    public static List<Event> getEvents() {
        ArrayList<Event> list = new ArrayList<Event>();
        list.addAll(events);
        return list;
    }

    static {
        if (ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.max") != null) {
            MAX_EVENTS = ConfigurationManager.getIntProperty((String)"xmlui.controlpanel.activity.max");
        }
        if (ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader") != null) {
            IP_HEADER = ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader");
        }
    }

    public static class Event {
        private String sessionID;
        private int epersonID = -1;
        private String url;
        private long timestamp;
        private String userAgent;
        private String ip;

        public Event(Context context, Request request) {
            EPerson eperson;
            if (context != null && (eperson = context.getCurrentUser()) != null) {
                this.epersonID = eperson.getID();
            }
            if (request != null) {
                this.url = request.getSitemapURI();
                Session session = request.getSession(true);
                if (session != null) {
                    this.sessionID = session.getId();
                }
                this.userAgent = request.getHeader("User-Agent");
                this.ip = request.getHeader(IP_HEADER);
                if (this.ip == null) {
                    this.ip = request.getRemoteAddr();
                }
            }
            this.timestamp = System.currentTimeMillis();
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getEPersonID() {
            return this.epersonID;
        }

        public String getURL() {
            return this.url;
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getIP() {
            return this.ip;
        }

        public String getDectectedBrowser() {
            if (this.userAgent.toLowerCase().contains("google/")) {
                return "Google (bot)";
            }
            if (this.userAgent.toLowerCase().contains("msnbot/")) {
                return "MSN (bot)";
            }
            if (this.userAgent.toLowerCase().contains("googlebot/")) {
                return "Google (bot)";
            }
            if (this.userAgent.toLowerCase().contains("webcrawler/")) {
                return "WebCrawler (bot)";
            }
            if (this.userAgent.toLowerCase().contains("inktomi")) {
                return "Inktomi (bot)";
            }
            if (this.userAgent.toLowerCase().contains("teoma")) {
                return "Teoma (bot)";
            }
            if (this.userAgent.contains("Lotus-Notes/")) {
                return "Lotus-Notes";
            }
            if (this.userAgent.contains("Opera")) {
                return "Opera";
            }
            if (this.userAgent.contains("Safari/")) {
                return "Safari";
            }
            if (this.userAgent.contains("Konqueror/")) {
                return "Konqueror";
            }
            if (this.userAgent.contains("MSIE")) {
                if (this.userAgent.contains("MSIE 8")) {
                    return "MSIE 8";
                }
                if (this.userAgent.contains("MSIE 7")) {
                    return "MSIE 7";
                }
                if (this.userAgent.contains("MSIE 6")) {
                    return "MSIE 6";
                }
                if (this.userAgent.contains("MSIE 5")) {
                    return "MSIE 5";
                }
                return "MSIE";
            }
            if (this.userAgent.contains("Gecko/")) {
                if (this.userAgent.contains("Camio/")) {
                    return "Gecko/Camino";
                }
                if (this.userAgent.contains("Chimera/")) {
                    return "Gecko/Chimera";
                }
                if (this.userAgent.contains("Firebird/")) {
                    return "Gecko/Firebird";
                }
                if (this.userAgent.contains("Phoenix/")) {
                    return "Gecko/Phoenix";
                }
                if (this.userAgent.contains("Galeon")) {
                    return "Gecko/Galeon";
                }
                if (this.userAgent.contains("Firefox/1")) {
                    return "Firefox 1.x";
                }
                if (this.userAgent.contains("Firefox/2")) {
                    return "Firefox 2.x";
                }
                if (this.userAgent.contains("Firefox/3")) {
                    return "Firefox 3.x";
                }
                if (this.userAgent.contains("Firefox/")) {
                    return "Firefox";
                }
                if (this.userAgent.contains("Netscape/")) {
                    return "Netscape";
                }
                return "Gecko";
            }
            if (this.userAgent.contains("KHTML/")) {
                return "KHTML";
            }
            if (this.userAgent.contains("Netscape/")) {
                return "Netscape";
            }
            if (this.userAgent.contains("Mozilla/")) {
                return "Mozilla";
            }
            return "Unknown";
        }
    }
}

