/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Image;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSpaceFeedGenerator
extends AbstractGenerator
implements Configurable,
CacheableProcessingComponent,
Recyclable {
    private static final Logger log = Logger.getLogger(DSpaceFeedGenerator.class);
    private String format = null;
    private String handle = null;
    private static int itemCount = 0;
    private static String defaultDescriptionFields = "dc.description.abstract, dc.description, dc.title.alternative, dc.title";
    private static final String I18N_PREFIX = "I18N:";
    private static final String I18N_NAMESPACE = "http://apache.org/cocoon/i18n/2.1";
    private DSpaceValidity validity = null;
    private List<BrowseItem> recentSubmissionItems;

    public Serializable getKey() {
        String key = "key:" + this.handle + ":" + this.format;
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                FeedValidity validity = new FeedValidity();
                Context context = ContextUtil.obtainContext(this.objectModel);
                DSpaceObject dso = null;
                if (this.handle != null && !this.handle.contains("site")) {
                    dso = HandleManager.resolveToObject((Context)context, (String)this.handle);
                }
                validity.add(dso);
                for (BrowseItem item : this.getRecientlySubmittedItems(context, dso)) {
                    validity.add((DSpaceObject)item);
                }
                this.validity = ((DSpaceValidity)validity).complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        itemCount = ConfigurationManager.getIntProperty((String)"webui.feed.items");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.format = par.getParameter("feedFormat", null);
        this.handle = par.getParameter("handle", null);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext(this.objectModel);
            DSpaceObject dso = null;
            if (this.handle != null && !this.handle.contains("site")) {
                dso = HandleManager.resolveToObject((Context)context, (String)this.handle);
                if (dso == null) {
                    throw new ResourceNotFoundException("Unable to find DSpace object matching the given handle: " + this.handle);
                }
                if (dso.getType() != 3 && dso.getType() != 4) {
                    throw new ResourceNotFoundException("Unable to syndicate DSpace object: " + this.handle);
                }
            }
            Channel channel = this.generateFeed(context, dso);
            channel.setFeedType(this.format);
            WireFeedOutput feedWriter = new WireFeedOutput();
            Document dom = feedWriter.outputW3CDom((WireFeed)channel);
            this.unmangleI18N(dom);
            DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            streamer.stream((Node)dom);
        }
        catch (IllegalArgumentException iae) {
            throw new ResourceNotFoundException("Syndication feed format, '" + this.format + "', is not supported.");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (FeedException fe) {
            throw new SAXException((Exception)((Object)fe));
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
    }

    private String mangleI18N(String key) {
        return I18N_PREFIX + key;
    }

    private void unmangleI18N(Document dom) {
        NodeList elementNodes = dom.getElementsByTagName("*");
        for (int i = 0; i < elementNodes.getLength(); ++i) {
            NodeList textNodes = elementNodes.item(i).getChildNodes();
            for (int j = 0; j < textNodes.getLength(); ++j) {
                Node oldNode = textNodes.item(j);
                if (oldNode.getNodeType() != 3 || oldNode.getNodeValue() == null || !oldNode.getNodeValue().startsWith(I18N_PREFIX)) continue;
                Node parent = oldNode.getParentNode();
                String key = oldNode.getNodeValue().substring(I18N_PREFIX.length());
                Element newNode = dom.createElementNS(I18N_NAMESPACE, "text");
                newNode.setAttribute("key", key);
                newNode.setAttribute("catalogue", "default");
                parent.replaceChild(newNode, oldNode);
            }
        }
    }

    private Channel generateFeed(Context context, DSpaceObject dso) throws IOException, SQLException {
        String description = null;
        String title = null;
        Bitstream logo = null;
        Channel channel = new Channel();
        if (dso == null) {
            channel.setTitle(ConfigurationManager.getProperty((String)"dspace.name"));
            channel.setLink(this.resolveURL(null));
            channel.setDescription(this.mangleI18N("xmlui.feed.general_description"));
        } else {
            if (dso.getType() == 3) {
                Collection col = (Collection)dso;
                description = col.getMetadata("short_description");
                title = col.getMetadata("name");
                logo = col.getLogo();
            } else if (dso.getType() == 4) {
                Community comm = (Community)dso;
                description = comm.getMetadata("short_description");
                title = comm.getMetadata("name");
                logo = comm.getLogo();
            }
            String objectUrl = this.resolveURL(dso);
            channel.setDescription(description);
            channel.setLink(objectUrl);
            channel.setTitle(title);
            if (logo != null) {
                Image image = new Image();
                image.setLink(objectUrl);
                image.setTitle(this.mangleI18N("xmlui.feed.logo_title"));
                image.setUrl(this.resolveURL(null) + "/retrieve/" + logo.getID());
                channel.setImage(image);
            }
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (BrowseItem item : this.getRecientlySubmittedItems(context, dso)) {
            items.add(this.itemFromDSpaceItem(context, item));
        }
        channel.setItems(items);
        return channel;
    }

    private Item itemFromDSpaceItem(Context context, BrowseItem dspaceItem) throws SQLException {
        String dateField;
        Item rssItem = new Item();
        String titleField = ConfigurationManager.getProperty((String)"webui.feed.item.title");
        if (titleField == null) {
            titleField = "dc.title";
        }
        if ((dateField = ConfigurationManager.getProperty((String)"webui.feed.item.date")) == null) {
            dateField = "dc.date.issued";
        }
        String itHandle = this.resolveURL((DSpaceObject)dspaceItem);
        rssItem.setLink(itHandle);
        String title = null;
        try {
            title = DSpaceFeedGenerator.getMetadata((BrowseItem)dspaceItem, (String)titleField)[0].value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            title = this.mangleI18N("xmlui.feed.untitled");
        }
        rssItem.setTitle(title);
        String descriptionFields = ConfigurationManager.getProperty((String)"webui.feed.item.description");
        if (descriptionFields == null) {
            descriptionFields = defaultDescriptionFields;
        }
        StringTokenizer st = new StringTokenizer(descriptionFields, ",");
        Description descrip = new Description();
        descrip.setValue("");
        while (st.hasMoreTokens()) {
            DCValue[] values;
            String field = st.nextToken().trim();
            boolean isDate = false;
            if (field.indexOf("(date)") > 0) {
                field = field.replaceAll("\\(date\\)", "");
                isDate = true;
            }
            for (DCValue value : values = DSpaceFeedGenerator.getMetadata(dspaceItem, field)) {
                String fieldValue = value.value;
                if (isDate) {
                    fieldValue = new DCDate(fieldValue).toString();
                }
                descrip.setValue(descrip.getValue() + fieldValue + "\n\n");
            }
        }
        rssItem.setDescription(descrip);
        String dcDate = null;
        try {
            dcDate = DSpaceFeedGenerator.getMetadata((BrowseItem)dspaceItem, (String)dateField)[0].value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (dcDate != null) {
            rssItem.setPubDate(new DCDate(dcDate).toDate());
        }
        return rssItem;
    }

    private List<BrowseItem> getRecientlySubmittedItems(Context context, DSpaceObject dso) throws SQLException {
        if (this.recentSubmissionItems != null) {
            return this.recentSubmissionItems;
        }
        String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
        BrowserScope scope = new BrowserScope(context);
        if (dso instanceof Collection) {
            scope.setCollection((Collection)dso);
        } else if (dso instanceof Community) {
            scope.setCommunity((Community)dso);
        }
        scope.setResultsPerPage(itemCount);
        try {
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(context);
            this.recentSubmissionItems = be.browse(scope).getResults();
        }
        catch (BrowseException bex) {
            log.error((Object)"Caught browse exception", (Throwable)bex);
        }
        catch (SortException e) {
            log.error((Object)"Caught sort exception", (Throwable)e);
        }
        return this.recentSubmissionItems;
    }

    private String resolveURL(DSpaceObject dso) {
        if (dso == null) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String url = request.isSecure() ? "https://" : "http://";
            url = url + ConfigurationManager.getProperty((String)"dspace.hostname");
            url = url + ":" + request.getServerPort();
            url = url + request.getContextPath();
            return url;
        }
        if (ConfigurationManager.getBooleanProperty((String)"webui.feed.localresolve")) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String url = request.isSecure() ? "https://" : "http://";
            url = url + ConfigurationManager.getProperty((String)"dspace.hostname");
            url = url + ":" + request.getServerPort();
            url = url + request.getContextPath();
            url = url + "/handle/" + dso.getHandle();
            return url;
        }
        return HandleManager.getCanonicalForm((String)dso.getHandle());
    }

    public void recycle() {
        this.format = null;
        this.handle = null;
        this.validity = null;
        this.recentSubmissionItems = null;
        super.recycle();
    }

    private static DCValue[] getMetadata(BrowseItem item, String mdString) throws SQLException {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().toLowerCase().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        DCValue[] values = "*".equals(qualifier) ? item.getMetadata(schema, element, "*", "*") : ("".equals(qualifier) ? item.getMetadata(schema, element, null, "*") : item.getMetadata(schema, element, qualifier, "*"));
        return values;
    }

    private class FeedValidity
    extends DSpaceValidity {
        private static final long serialVersionUID = 1L;
        private static final long CACHE_AGE = 86400000L;
        private long expires = 0L;

        private FeedValidity() {
        }

        public DSpaceValidity complete() {
            this.expires = System.currentTimeMillis() + 86400000L;
            return super.complete();
        }

        public int isValid() {
            if (this.completed) {
                if (System.currentTimeMillis() < this.expires) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public int isValid(SourceValidity otherValidity) {
            if (this.completed && otherValidity instanceof FeedValidity) {
                FeedValidity other = (FeedValidity)otherValidity;
                if (this.hash == other.hash) {
                    this.expires = System.currentTimeMillis() + 86400000L;
                    other.expires = System.currentTimeMillis() + 86400000L;
                    return 1;
                }
            }
            return -1;
        }
    }
}

