/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.ContainerAdapter;
import org.dspace.app.xmlui.objectmanager.ItemAdapter;
import org.dspace.app.xmlui.objectmanager.RepositoryAdapter;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class DSpaceMETSGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext(this.objectModel);
            AbstractAdapter adapter = this.resolveAdapter(context);
            if (adapter == null) {
                throw new ResourceNotFoundException("Unable to locate object.");
            }
            this.configureAdapter(adapter);
            this.contentHandler.startDocument();
            adapter.renderMETS(this.contentHandler, this.lexicalHandler);
            this.contentHandler.endDocument();
        }
        catch (WingException we) {
            throw new ProcessingException((Exception)((Object)we));
        }
        catch (CrosswalkException ce) {
            throw new ProcessingException((Exception)((Object)ce));
        }
        catch (SQLException sqle) {
            throw new ProcessingException((Exception)sqle);
        }
    }

    private AbstractAdapter resolveAdapter(Context context) throws SQLException {
        String[] parts;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String contextPath = request.getContextPath();
        String handle = this.parameters.getParameter("handle", null);
        String internal = this.parameters.getParameter("internal", null);
        AbstractAdapter adapter = null;
        if (handle != null) {
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle);
            if (dso instanceof Item) {
                adapter = new ItemAdapter((Item)dso, contextPath);
            } else if (dso instanceof Collection || dso instanceof Community) {
                adapter = new ContainerAdapter(context, dso, contextPath);
            }
        } else if (internal != null && (parts = internal.split(":")).length == 2) {
            String type = parts[0];
            int id = Integer.valueOf(parts[1]);
            if ("item".equals(type)) {
                Item item = Item.find((Context)context, (int)id);
                if (item != null) {
                    adapter = new ItemAdapter(item, contextPath);
                }
            } else if ("collection".equals(type)) {
                Collection collection = Collection.find((Context)context, (int)id);
                if (collection != null) {
                    adapter = new ContainerAdapter(context, (DSpaceObject)collection, contextPath);
                }
            } else if ("community".equals(type)) {
                Community community = Community.find((Context)context, (int)id);
                if (community != null) {
                    adapter = new ContainerAdapter(context, (DSpaceObject)community, contextPath);
                }
            } else if ("repository".equals(type) && ConfigurationManager.getProperty((String)"handle.prefix").equals(id)) {
                adapter = new RepositoryAdapter(context, contextPath);
            }
        }
        return adapter;
    }

    public void configureAdapter(AbstractAdapter adapter) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String sections = request.getParameter("sections");
        String dmdTypes = request.getParameter("dmdTypes");
        String amdTypes = request.getParameter("amdTypes");
        String fileGrpTypes = request.getParameter("fileGrpTypes");
        String structTypes = request.getParameter("structTypes");
        adapter.setSections(sections);
        adapter.setDmdTypes(dmdTypes);
        adapter.setAmdTypes(amdTypes);
        adapter.setFileGrpTypes(fileGrpTypes);
        adapter.setStructTypes(structTypes);
    }
}

