/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Password;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class PasswordLogin
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    public static final Message T_title = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.title");
    public static final Message T_dspace_home = PasswordLogin.message((String)"xmlui.general.dspace_home");
    public static final Message T_trail = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.trail");
    public static final Message T_head1 = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.head1");
    public static final Message T_email_address = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.email_address");
    public static final Message T_error_bad_login = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.error_bad_login");
    public static final Message T_password = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.password");
    public static final Message T_forgot_link = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.forgot_link");
    public static final Message T_submit = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.submit");
    public static final Message T_head2 = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.head2");
    public static final Message T_para1 = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.para1");
    public static final Message T_register_link = PasswordLogin.message((String)"xmlui.EPerson.PasswordLogin.register_link");

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String previous_email = request.getParameter("login_email");
        Session session = request.getSession();
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header == null && message == null && characters == null && previous_email == null) {
            return "1";
        }
        return "0";
    }

    public SourceValidity getValidity() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String previous_email = request.getParameter("login_email");
        Session session = request.getSession();
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header == null && message == null && characters == null && previous_email == null) {
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SQLException, SAXException, WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Session session = request.getSession();
        String previousEmail = request.getParameter("login_email");
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header != null || message != null || characters != null) {
            Division reason = body.addDivision("login-reason");
            if (header != null) {
                reason.setHead(PasswordLogin.message((String)header));
            } else {
                reason.setHead("Authentication Required");
            }
            if (message != null) {
                reason.addPara(PasswordLogin.message((String)message));
            }
            if (characters != null) {
                reason.addPara(characters);
            }
        }
        Division login = body.addInteractiveDivision("login", this.contextPath + "/password-login", "post", "primary");
        login.setHead(T_head1);
        List list = login.addList("password-login", "form");
        Text email = list.addItem().addText("login_email");
        email.setRequired();
        email.setLabel(T_email_address);
        if (previousEmail != null) {
            email.setValue(previousEmail);
            email.addError(T_error_bad_login);
        }
        Item item = list.addItem();
        Password password = item.addPassword("login_password");
        password.setRequired();
        password.setLabel(T_password);
        item.addXref(this.contextPath + "/forgot", T_forgot_link);
        list.addLabel();
        Item submit = list.addItem("login-in", null);
        submit.addButton("submit").setValue(T_submit);
        if (ConfigurationManager.getBooleanProperty((String)"xmlui.user.registration", (boolean)true)) {
            Division register = login.addDivision("register");
            register.setHead(T_head2);
            register.addPara(T_para1);
            register.addPara().addXref(this.contextPath + "/register", T_register_link);
        }
    }
}

