/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.license.CreativeCommons;
import org.xml.sax.SAXException;

public class CCLicenseStep
extends AbstractSubmissionStep {
    protected static final Message T_head = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.head");
    protected static final Message T_info1 = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.info1");
    protected static final Message T_submit_to_creative_commons = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.submit_to_creative_commons");
    protected static final Message T_license = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.license");
    protected static final Message T_submit_remove = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.submit_remove");
    protected static final Message T_no_license = CCLicenseStep.message((String)"xmlui.Submission.submit.CCLicenseStep.no_license");
    public static final String CREATIVE_COMMONS_URL = "http://creativecommons.org/license/";

    public CCLicenseStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean https = request.isSecure();
        String server = request.getServerName();
        int port = request.getServerPort();
        String exitURL = https ? "https://" : "http://";
        exitURL = exitURL + server;
        if (port != 80 && port != 443) {
            exitURL = exitURL + ":" + port;
        }
        exitURL = exitURL + actionURL + "?submission-continue=" + this.knot.getId() + "&cc_license_url=[license_url]";
        Division div = body.addDivision("submit-cclicense", "primary submission");
        div.setHead(T_submission_head);
        Division progressDiv = div.addInteractiveDivision("submit-cclicense-progress", actionURL, "post");
        this.addSubmissionProgressList(progressDiv);
        progressDiv.addHidden("submission-continue").setValue(this.knot.getId());
        Division offsiteDiv = div.addInteractiveDivision("submit-cclicense-offsite", CREATIVE_COMMONS_URL, "post");
        offsiteDiv.setHead(T_head);
        offsiteDiv.addPara(T_info1);
        offsiteDiv.addHidden("submission-continue").setValue(this.knot.getId());
        offsiteDiv.addHidden("partner").setValue("dspace");
        offsiteDiv.addHidden("exit_url").setValue(exitURL);
        Para ccPara = offsiteDiv.addPara("creative-commons-button", "creative-commons-button");
        ccPara.addButton("submit_to_creative_commons").setValue(T_submit_to_creative_commons);
        Division onsiteDiv = div.addInteractiveDivision("submit-cclicense-offsite", actionURL, "post");
        List form = onsiteDiv.addList("submit-review", "form");
        form.addLabel(T_license);
        if (CreativeCommons.hasLicense((Context)this.context, (Item)item)) {
            String url = CreativeCommons.getLicenseURL((Item)item);
            form.addItem().addXref(url, url);
            form.addItem().addButton("submit_no_cc").setValue(T_submit_remove);
            form.addItem().addHidden("cc_license_url").setValue(url);
        } else {
            form.addItem().addHighlight("italic").addContent(T_no_license);
        }
        this.addControlButtons(form);
    }

    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    public void recycle() {
        super.recycle();
    }
}

