/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.PolicySet;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;

public class FlowAuthorizationUtils {
    public static FlowResult resolveItemIdentifier(Context context, String identifier) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        if (identifier.contains("/")) {
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)identifier);
            if (dso != null && dso.getType() == 2) {
                result.setParameter("itemID", dso.getID());
                result.setParameter("type", 2);
                result.setContinue(true);
                return result;
            }
            if (dso != null && dso.getType() == 3) {
                result.setParameter("collectionID", dso.getID());
                result.setParameter("type", 3);
                result.setContinue(true);
                return result;
            }
            if (dso != null && dso.getType() == 4) {
                result.setParameter("communityID", dso.getID());
                result.setParameter("type", 4);
                result.setContinue(true);
                return result;
            }
        } else {
            Item item = null;
            try {
                item = Item.find((Context)context, (int)Integer.valueOf(identifier));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (item != null) {
                result.setParameter("itemID", item.getID());
                result.setParameter("type", 2);
                result.setContinue(true);
                return result;
            }
        }
        result.addError("identifier");
        return result;
    }

    public static FlowResult processEditPolicy(Context context, int objectType, int objectID, int policyID, int groupID, int actionID) throws SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        boolean added = false;
        ResourcePolicy policy = ResourcePolicy.find((Context)context, (int)policyID);
        if (actionID == -1) {
            result.setContinue(false);
            result.addError("action_id");
            return result;
        }
        if (groupID == -1) {
            result.setContinue(false);
            result.addError("group_id");
            return result;
        }
        Community policyParent = null;
        if (policy == null) {
            policy = ResourcePolicy.create((Context)context);
            switch (objectType) {
                case 4: {
                    policyParent = Community.find((Context)context, (int)objectID);
                    break;
                }
                case 3: {
                    policyParent = Collection.find((Context)context, (int)objectID);
                    break;
                }
                case 2: {
                    policyParent = Item.find((Context)context, (int)objectID);
                    break;
                }
                case 1: {
                    policyParent = Bundle.find((Context)context, (int)objectID);
                    break;
                }
                case 0: {
                    policyParent = Bitstream.find((Context)context, (int)objectID);
                }
            }
            policy.setResource(policyParent);
            added = true;
        }
        Group group = Group.find((Context)context, (int)groupID);
        policy.setAction(actionID);
        policy.setGroup(group);
        Bitstream logo = null;
        Collection logoContainer = null;
        if (objectType == 3) {
            logoContainer = Collection.find((Context)context, (int)objectID);
            logo = logoContainer.getLogo();
        } else if (objectType == 4) {
            logoContainer = Community.find((Context)context, (int)objectID);
            logo = ((Community)logoContainer).getLogo();
        }
        if (logo != null) {
            List policySet = AuthorizeManager.getPolicies((Context)context, (DSpaceObject)logoContainer);
            AuthorizeManager.removeAllPolicies((Context)context, (DSpaceObject)logo);
            AuthorizeManager.addPolicies((Context)context, (List)policySet, (DSpaceObject)logo);
        }
        policy.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        if (added) {
            result.setMessage(new Message("default", "A new policy was created successfully"));
        } else {
            result.setMessage(new Message("default", "The policy was edited successfully"));
        }
        result.setParameter("policyID", policy.getID());
        return result;
    }

    public static FlowResult processDeletePolicies(Context context, String[] policyIDs) throws NumberFormatException, SQLException {
        FlowResult result = new FlowResult();
        for (String id : policyIDs) {
            ResourcePolicy policyDeleted = ResourcePolicy.find((Context)context, (int)Integer.valueOf(id));
            policyDeleted.delete();
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies were deleted successfully"));
        return result;
    }

    public static FlowResult processAdvancedPolicyAdd(Context context, String[] groupIDs, int actionID, int resourceID, String[] collectionIDs) throws NumberFormatException, SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        for (String groupID : groupIDs) {
            for (String collectionID : collectionIDs) {
                PolicySet.setPolicies((Context)context, (int)3, (int)Integer.valueOf(collectionID), (int)resourceID, (int)actionID, (int)Integer.valueOf(groupID), (boolean)false, (boolean)false);
                if (resourceID != 0) continue;
                PolicySet.setPolicies((Context)context, (int)3, (int)Integer.valueOf(collectionID), (int)1, (int)actionID, (int)Integer.valueOf(groupID), (boolean)false, (boolean)false);
            }
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies were added successfully!"));
        return result;
    }

    public static FlowResult processAdvancedPolicyDelete(Context context, int resourceID, String[] collectionIDs) throws NumberFormatException, SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        for (String collectionID : collectionIDs) {
            PolicySet.setPolicies((Context)context, (int)3, (int)Integer.valueOf(collectionID), (int)resourceID, (int)0, (int)0, (boolean)false, (boolean)true);
            if (resourceID != 0) continue;
            PolicySet.setPolicies((Context)context, (int)3, (int)Integer.valueOf(collectionID), (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies for the selected collections were cleared."));
        return result;
    }
}

