/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.AccountManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;

public class FlowEPersonUtils {
    private static final Message T_add_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.add_eperson_success_notice");
    private static final Message T_edit_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.edit_eperson_success_notice");
    private static final Message T_reset_password_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.reset_password_success_notice");
    private static final Message t_delete_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.delete_eperson_success_notice");
    private static final Message t_delete_eperson_failed_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.delete_eperson_failed_notice");

    public static FlowResult processAddEPerson(Context context, Request request, Map objectModel) throws SQLException, AuthorizeException {
        EPerson potentialDupicate;
        boolean certificate;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String email = request.getParameter("email_address");
        String first = request.getParameter("first_name");
        String last = request.getParameter("last_name");
        String phone = request.getParameter("phone");
        boolean login = request.getParameter("can_log_in") != null;
        boolean bl = certificate = request.getParameter("certificate") != null;
        if (email.length() == 0) {
            result.addError("email_address");
        }
        if (first.length() == 0) {
            result.addError("first_name");
        }
        if (last.length() == 0) {
            result.addError("last_name");
        }
        if ((potentialDupicate = EPerson.findByEmail((Context)context, (String)email)) != null) {
            result.addError("eperson_email_key");
        }
        if (result.getErrors() == null) {
            EPerson newPerson = AuthenticationUtil.createNewEperson(objectModel, email);
            newPerson.setFirstName(first);
            newPerson.setLastName(last);
            newPerson.setMetadata("phone", phone);
            newPerson.setCanLogIn(login);
            newPerson.setRequireCertificate(certificate);
            newPerson.setSelfRegistered(false);
            newPerson.update();
            context.commit();
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_add_eperson_success_notice);
            result.setParameter("epersonID", newPerson.getID());
        }
        return result;
    }

    public static FlowResult processEditEPerson(Context context, Request request, Map ObjectModel, int epersonID) throws SQLException, AuthorizeException {
        boolean certificate;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String email = request.getParameter("email_address");
        String first = request.getParameter("first_name");
        String last = request.getParameter("last_name");
        String phone = request.getParameter("phone");
        boolean login = request.getParameter("can_log_in") != null;
        boolean bl = certificate = request.getParameter("certificate") != null;
        if (email.length() == 0) {
            result.addError("email_address");
        }
        if (first.length() == 0) {
            result.addError("first_name");
        }
        if (last.length() == 0) {
            result.addError("last_name");
        }
        if (result.getErrors() == null) {
            EPerson personModified = EPerson.find((Context)context, (int)epersonID);
            if (!personModified.getEmail().equals(email)) {
                EPerson potentialDupicate = EPerson.findByEmail((Context)context, (String)email);
                if (potentialDupicate == null) {
                    personModified.setEmail(email);
                } else if (potentialDupicate != personModified) {
                    result.addError("eperson_email_key");
                    return result;
                }
            }
            if (!personModified.getFirstName().equals(first)) {
                personModified.setFirstName(first);
            }
            if (!personModified.getLastName().equals(last)) {
                personModified.setLastName(last);
            }
            if (!personModified.getMetadata("phone").equals(phone)) {
                personModified.setMetadata("phone", phone);
            }
            personModified.setCanLogIn(login);
            personModified.setRequireCertificate(certificate);
            personModified.update();
            context.commit();
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_edit_eperson_success_notice);
        }
        return result;
    }

    public static FlowResult processResetPassword(Context context, int epersonID) throws IOException, MessagingException, SQLException, AuthorizeException {
        EPerson eperson = EPerson.find((Context)context, (int)epersonID);
        AccountManager.sendForgotPasswordInfo((Context)context, (String)eperson.getEmail());
        FlowResult result = new FlowResult();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_reset_password_success_notice);
        return result;
    }

    public static FlowResult processLoginAs(Context context, Map objectModel, int epersonID) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(true);
        result.setOutcome(true);
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        EPerson eperson = EPerson.find((Context)context, (int)epersonID);
        try {
            AuthenticationUtil.loginAs(context, request, eperson);
        }
        catch (AuthorizeException ae) {
            result.setOutcome(false);
            result.setCharacters(ae.getMessage());
        }
        return result;
    }

    public static FlowResult processDeleteEPeople(Context context, String[] epeopleIDs) throws NumberFormatException, SQLException, AuthorizeException, EPersonDeletionException {
        FlowResult result = new FlowResult();
        ArrayList<String> unableList = new ArrayList<String>();
        for (String id : epeopleIDs) {
            EPerson personDeleted = EPerson.find((Context)context, (int)Integer.valueOf(id));
            try {
                personDeleted.delete();
            }
            catch (EPersonDeletionException epde) {
                String firstName = personDeleted.getFirstName();
                String lastName = personDeleted.getLastName();
                String email = personDeleted.getEmail();
                unableList.add(firstName + " " + lastName + " (" + email + ")");
            }
        }
        if (unableList.size() > 0) {
            result.setOutcome(false);
            result.setMessage(t_delete_eperson_failed_notice);
            String characters = null;
            for (String unable : unableList) {
                if (characters == null) {
                    characters = unable;
                    continue;
                }
                characters = characters + ", " + unable;
            }
            result.setCharacters(characters);
        } else {
            result.setOutcome(true);
            result.setMessage(t_delete_eperson_success_notice);
        }
        return result;
    }
}

