/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.core.Context;

public class ContextUtil {
    private static final Logger log = Logger.getLogger(ContextUtil.class);
    public static final String DSPACE_CONTEXT = "dspace.context";

    public static Context obtainContext(Map objectModel) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context == null) {
            context = new Context();
            context.setExtraLogInfo("session_id=" + request.getSession().getId());
            HttpServletRequest httpRequest = (HttpServletRequest)objectModel.get("httprequest");
            AuthenticationUtil.resumeLogin(context, httpRequest);
            int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)httpRequest);
            for (int i = 0; i < groupIDs.length; ++i) {
                context.setSpecialGroup(groupIDs[i]);
                log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
            }
            context.setExtraLogInfo("session_id=" + request.getSession().getId() + ":ip_addr=" + request.getRemoteAddr());
            request.setAttribute(DSPACE_CONTEXT, (Object)context);
        }
        return context;
    }

    public static void closeContext(HttpServletRequest request) throws ServletException {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context != null && context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException sqle) {
                throw new ServletException("Unable to close DSpace context.", (Throwable)sqle);
            }
        }
    }
}

