/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.administrative.FlowContainerUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.core.Context;

public class EditCollectionMetadataForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditCollectionMetadataForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_collection_trail = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.general.options_roles");
    private static final Message T_options_harvest = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_submit_return = EditCollectionMetadataForm.message((String)"xmlui.general.return");
    private static final Message T_title = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.title");
    private static final Message T_trail = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.trail");
    private static final Message T_main_head = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.main_head");
    private static final Message T_label_name = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_name");
    private static final Message T_label_short_description = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_short_description");
    private static final Message T_label_introductory_text = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_introductory_text");
    private static final Message T_label_copyright_text = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_copyright_text");
    private static final Message T_label_side_bar_text = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_side_bar_text");
    private static final Message T_label_license = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_license");
    private static final Message T_label_provenance_description = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_provenance_description");
    private static final Message T_label_logo = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_logo");
    private static final Message T_label_existing_logo = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_existing_logo");
    private static final Message T_label_item_template = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.label_item_template");
    private static final Message T_submit_create_template = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.submit_create_template");
    private static final Message T_submit_edit_template = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.submit_edit_template");
    private static final Message T_submit_delete_template = EditCollectionMetadataForm.message((String)"xmlui.general.delete");
    private static final Message T_submit_delete_logo = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.submit_delete_logo");
    private static final Message T_submit_delete = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.submit_delete");
    private static final Message T_submit_save = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.submit_save");
    private static final Message T_sysadmins_only = EditCollectionMetadataForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.sysadmins_only");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        Item item;
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection thisCollection = Collection.find((Context)this.context, (int)collectionID);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        String short_description_error = FlowContainerUtils.checkXMLFragment(thisCollection.getMetadata("short_description"));
        String introductory_text_error = FlowContainerUtils.checkXMLFragment(thisCollection.getMetadata("introductory_text"));
        String copyright_text_error = FlowContainerUtils.checkXMLFragment(thisCollection.getMetadata("copyright_text"));
        String side_bar_text_error = FlowContainerUtils.checkXMLFragment(thisCollection.getMetadata("side_bar_text"));
        Division main = body.addInteractiveDivision("collection-metadata-edit", this.contextPath + "/admin/collection", "multipart", "primary administrative collection");
        main.setHead(T_main_head.parameterize(new Object[]{thisCollection.getMetadata("name")}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addXref(baseURL + "&submit_harvesting", T_options_harvest);
        List metadataList = main.addList("metadataList", "form");
        metadataList.addLabel(T_label_name);
        Text name = metadataList.addItem().addText("name");
        name.setSize(40);
        name.setValue(thisCollection.getMetadata("name"));
        metadataList.addLabel(T_label_short_description);
        Text short_description = metadataList.addItem().addText("short_description");
        short_description.setValue(thisCollection.getMetadata("short_description"));
        short_description.setSize(40);
        if (short_description_error != null) {
            short_description.addError(short_description_error);
        }
        metadataList.addLabel(T_label_introductory_text);
        TextArea introductory_text = metadataList.addItem().addTextArea("introductory_text");
        introductory_text.setValue(thisCollection.getMetadata("introductory_text"));
        introductory_text.setSize(6, 40);
        if (introductory_text_error != null) {
            introductory_text.addError(introductory_text_error);
        }
        metadataList.addLabel(T_label_copyright_text);
        TextArea copyright_text = metadataList.addItem().addTextArea("copyright_text");
        copyright_text.setValue(thisCollection.getMetadata("copyright_text"));
        copyright_text.setSize(6, 40);
        if (copyright_text_error != null) {
            copyright_text.addError(copyright_text_error);
        }
        metadataList.addLabel(T_label_side_bar_text);
        TextArea side_bar_text = metadataList.addItem().addTextArea("side_bar_text");
        side_bar_text.setValue(thisCollection.getMetadata("side_bar_text"));
        side_bar_text.setSize(6, 40);
        if (side_bar_text_error != null) {
            side_bar_text.addError(side_bar_text_error);
        }
        metadataList.addLabel(T_label_license);
        TextArea license = metadataList.addItem().addTextArea("license");
        license.setValue(thisCollection.getMetadata("license"));
        license.setSize(6, 40);
        metadataList.addLabel(T_label_provenance_description);
        TextArea provenance_description = metadataList.addItem().addTextArea("provenance_description");
        provenance_description.setValue(thisCollection.getMetadata("provenance_description"));
        provenance_description.setSize(6, 40);
        metadataList.addLabel(T_label_logo);
        metadataList.addItem().addFile("logo");
        if (thisCollection.getLogo() != null) {
            metadataList.addLabel(T_label_existing_logo);
            item = metadataList.addItem();
            item.addFigure(this.contextPath + "/bitstream/id/" + thisCollection.getLogo().getID() + "/bob.jpg", null, null);
            item.addButton("submit_delete_logo").setValue(T_submit_delete_logo);
        }
        metadataList.addLabel(T_label_item_template);
        item = metadataList.addItem();
        if (thisCollection.getTemplateItem() == null) {
            item.addButton("submit_create_template").setValue(T_submit_create_template);
        } else {
            item.addButton("submit_edit_template").setValue(T_submit_edit_template);
            item.addButton("submit_delete_template").setValue(T_submit_delete_template);
        }
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_save);
        if (AuthorizeManager.isAdmin((Context)this.context)) {
            buttonList.addButton("submit_delete").setValue(T_submit_delete);
        }
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

