/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.mapper;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = SearchItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_cancel = SearchItemForm.message((String)"xmlui.general.cancel");
    private static final Message T_mapper_trail = SearchItemForm.message((String)"xmlui.administrative.mapper.general.mapper_trail");
    private static final Message T_title = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.title");
    private static final Message T_trail = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.trail");
    private static final Message T_head1 = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.head1");
    private static final Message T_submit_map = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.submit_map");
    private static final Message T_column1 = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.column1");
    private static final Message T_column2 = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.column2");
    private static final Message T_column3 = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.column3");
    private static final Message T_column4 = SearchItemForm.message((String)"xmlui.administrative.mapper.SearchItemForm.column4");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_mapper_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException {
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection collection = Collection.find((Context)this.context, (int)collectionID);
        String query = SearchItemForm.URLDecode(this.parameters.getParameter("query", null));
        ArrayList<Item> items = this.preformSearch(collection, query);
        Division div = body.addInteractiveDivision("search-items", this.contextPath + "/admin/mapper", "get", "primary administrative mapper");
        div.setHead(T_head1.parameterize(new Object[]{query}));
        Para actions = div.addPara();
        actions.addButton("submit_map").setValue(T_submit_map);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        Table table = div.addTable("search-items-table", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        for (Item item : items) {
            Collection[] collections;
            String itemID = String.valueOf(item.getID());
            Collection owningCollection = item.getOwningCollection();
            String owning = owningCollection.getMetadata("name");
            String author = "unkown";
            DCValue[] dcAuthors = item.getDC("contributor", "*", "*");
            if (dcAuthors != null && dcAuthors.length >= 1) {
                author = dcAuthors[0].value;
            }
            String title = "untitled";
            DCValue[] dcTitles = item.getDC("title", null, "*");
            if (dcTitles != null && dcTitles.length >= 1) {
                title = dcTitles[0].value;
            }
            String url = this.contextPath + "/handle/" + item.getHandle();
            Row row = table.addRow();
            boolean canBeMapped = true;
            for (Collection c : collections = item.getCollections()) {
                if (c.getID() != collectionID) continue;
                canBeMapped = false;
            }
            if (canBeMapped) {
                CheckBox select = row.addCell().addCheckBox("itemID");
                select.setLabel("Select");
                select.addOption(itemID);
            } else {
                row.addCell().addContent("");
            }
            row.addCellContent(owning);
            row.addCell().addXref(url, author);
            row.addCell().addXref(url, title);
        }
        actions = div.addPara();
        actions.addButton("submit_map").setValue(T_submit_map);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private ArrayList<Item> preformSearch(Collection collection, String query) throws SQLException, IOException {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.setQuery(query);
        queryArgs.setPageSize(Integer.MAX_VALUE);
        QueryResults results = DSQuery.doQuery((Context)this.context, (QueryArgs)queryArgs);
        ArrayList<Item> items = new ArrayList<Item>();
        List handles = results.getHitHandles();
        for (String handle : handles) {
            Item item;
            DSpaceObject resultDSO = HandleManager.resolveToObject((Context)this.context, (String)handle);
            if (!(resultDSO instanceof Item) || (item = (Item)resultDSO).isOwningCollection(collection)) continue;
            items.add(item);
        }
        return items;
    }
}

