/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearch
extends AbstractDSpaceTransformer {
    private static final Logger log = Logger.getLogger(AbstractSearch.class);
    private static final Message T_result_query = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.result_query");
    private static final Message T_head1_community = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_community");
    private static final Message T_head1_collection = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_collection");
    private static final Message T_head1_none = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head1_none");
    private static final Message T_head2 = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head2");
    private static final Message T_head3 = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.head3");
    private static final Message T_no_results = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.no_results");
    private static final Message T_all_of_dspace = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.all_of_dspace");
    private static final Message T_sort_by_relevance = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by.relevance");
    private static final Message T_sort_by = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.sort_by");
    private static final Message T_order = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order");
    private static final Message T_order_asc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.asc");
    private static final Message T_order_desc = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.order.desc");
    private static final Message T_rpp = AbstractSearch.message((String)"xmlui.ArtifactBrowser.AbstractSearch.rpp");
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private QueryArgs queryArgs;
    private QueryResults queryResults;
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            String key = "";
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            key = key + "-" + this.getParameterPage();
            key = key + "-" + this.getParameterRpp();
            key = key + "-" + this.getParameterSortBy();
            key = key + "-" + this.getParameterOrder();
            key = key + "-" + this.getParameterEtAl();
            DSpaceObject scope = this.getScope();
            if (scope != null) {
                key = key + "-" + scope.getHandle();
            }
            key = key + "-" + this.getQuery();
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (Exception e) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject scope = this.getScope();
                validity.add(scope);
                this.performSearch();
                List handles = this.queryResults.getHitHandles();
                for (String handle : handles) {
                    DSpaceObject resultDSO = HandleManager.resolveToObject((Context)this.context, (String)handle);
                    validity.add(resultDSO);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logSearch();
        }
        return this.validity;
    }

    @Override
    public abstract void addBody(Body var1) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException;

    protected void buildSearchResultsDivision(Division search) throws IOException, SQLException, WingException {
        if (this.getQuery().length() > 0) {
            this.performSearch();
            DSpaceObject searchScope = this.getScope();
            Para para = search.addPara("result-query", "result-query");
            String query = this.getQuery();
            int hitCount = this.queryResults.getHitCount();
            para.addContent(T_result_query.parameterize(new Object[]{query, hitCount}));
            Division results = search.addDivision("search-results", "primary");
            if (searchScope instanceof Community) {
                Community community = (Community)searchScope;
                String communityName = community.getMetadata("name");
                results.setHead(T_head1_community.parameterize(new Object[]{communityName}));
            } else if (searchScope instanceof Collection) {
                Collection collection = (Collection)searchScope;
                String collectionName = collection.getMetadata("name");
                results.setHead(T_head1_collection.parameterize(new Object[]{collectionName}));
            } else {
                results.setHead(T_head1_none);
            }
            if (this.queryResults.getHitCount() > 0) {
                int itemsTotal = this.queryResults.getHitCount();
                int firstItemIndex = this.queryResults.getStart() + 1;
                int lastItemIndex = this.queryResults.getStart() + this.queryResults.getPageSize();
                if (itemsTotal < lastItemIndex) {
                    lastItemIndex = itemsTotal;
                }
                int currentPage = this.queryResults.getStart() / this.queryResults.getPageSize() + 1;
                int pagesTotal = (this.queryResults.getHitCount() - 1) / this.queryResults.getPageSize() + 1;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("page", "{pageNum}");
                String pageURLMask = this.generateURL(parameters);
                results.setMaskedPagination(itemsTotal, firstItemIndex, lastItemIndex, currentPage, pagesTotal, pageURLMask);
                ReferenceSet referenceSet = null;
                boolean resultsContainsBothContainersAndItems = false;
                List containerHandles = this.queryResults.getHitHandles();
                for (String handle : containerHandles) {
                    DSpaceObject resultDSO = HandleManager.resolveToObject((Context)this.context, (String)handle);
                    if (!(resultDSO instanceof Community) && !(resultDSO instanceof Collection)) continue;
                    if (referenceSet == null) {
                        referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
                        referenceSet.setHead(T_head2);
                        resultsContainsBothContainersAndItems = true;
                    }
                    referenceSet.addReference((Object)resultDSO);
                }
                referenceSet = null;
                List itemHandles = this.queryResults.getHitHandles();
                for (String handle : itemHandles) {
                    DSpaceObject resultDSO = HandleManager.resolveToObject((Context)this.context, (String)handle);
                    if (!(resultDSO instanceof Item)) continue;
                    if (referenceSet == null) {
                        referenceSet = results.addReferenceSet("search-results-repository", "summaryList", null, "repository-search-results");
                        if (resultsContainsBothContainersAndItems) {
                            referenceSet.setHead(T_head3);
                        }
                    }
                    referenceSet.addReference((Object)resultDSO);
                }
            } else {
                results.addPara(T_no_results);
            }
        }
    }

    protected void buildScopeList(Select scope) throws SQLException, WingException {
        block4: {
            Community[] communities;
            DSpaceObject scopeDSO;
            block5: {
                block3: {
                    scopeDSO = this.getScope();
                    if (scopeDSO != null) break block3;
                    scope.addOption("/", T_all_of_dspace);
                    scope.setOptionSelected("/");
                    for (Community community : Community.findAllTop((Context)this.context)) {
                        scope.addOption(community.getHandle(), community.getMetadata("name"));
                    }
                    break block4;
                }
                if (!(scopeDSO instanceof Community)) break block5;
                Community community = (Community)scopeDSO;
                scope.addOption("/", T_all_of_dspace);
                scope.addOption(community.getHandle(), community.getMetadata("name"));
                scope.setOptionSelected(community.getHandle());
                for (Collection collection : community.getCollections()) {
                    scope.addOption(collection.getHandle(), collection.getMetadata("name"));
                }
                break block4;
            }
            if (!(scopeDSO instanceof Collection)) break block4;
            Collection collection = (Collection)scopeDSO;
            scope.addOption("/", T_all_of_dspace);
            scope.addOption(collection.getHandle(), collection.getMetadata("name"));
            scope.setOptionSelected(collection.getHandle());
            for (Community community : communities = collection.getCommunities()[0].getAllParents()) {
                scope.addOption(community.getHandle(), community.getMetadata("name"));
            }
        }
    }

    protected void performSearch() throws SQLException, IOException, UIException {
        if (this.queryResults != null) {
            return;
        }
        Context context = ContextUtil.obtainContext(this.objectModel);
        String query = this.getQuery();
        DSpaceObject scope = this.getScope();
        int page = this.getParameterPage();
        this.queryArgs = new QueryArgs();
        this.queryArgs.setPageSize(this.getParameterRpp());
        try {
            this.queryArgs.setSortOption(SortOption.getSortOption((int)this.getParameterSortBy()));
        }
        catch (SortException se) {
            // empty catch block
        }
        this.queryArgs.setSortOrder(this.getParameterOrder());
        this.queryArgs.setQuery(query);
        if (page > 1) {
            this.queryArgs.setStart((Integer.valueOf(page) - 1) * this.queryArgs.getPageSize());
        } else {
            this.queryArgs.setStart(0);
        }
        QueryResults qResults = null;
        qResults = scope instanceof Community ? DSQuery.doQuery((Context)context, (QueryArgs)this.queryArgs, (Community)((Community)scope)) : (scope instanceof Collection ? DSQuery.doQuery((Context)context, (QueryArgs)this.queryArgs, (Collection)((Collection)scope)) : DSQuery.doQuery((Context)context, (QueryArgs)this.queryArgs));
        this.queryResults = qResults;
    }

    protected DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle(this.objectModel) : HandleManager.resolveToObject((Context)this.context, (String)scopeString);
        return dso;
    }

    protected int getParameterPage() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("page"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getParameterRpp() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    protected int getParameterSortBy() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String getParameterOrder() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
        return s != null ? s : "DESC";
    }

    protected int getParameterEtAl() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("etal"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected QueryResults getQueryResults() {
        return this.queryResults;
    }

    protected boolean variableScope() throws SQLException {
        return HandleUtil.obtainHandle(this.objectModel) == null;
    }

    protected abstract String getQuery() throws UIException;

    protected abstract String generateURL(Map<String, String> var1) throws UIException;

    @Override
    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    protected void buildSearchControls(Division div) throws WingException {
        Table controlsTable = div.addTable("search-controls", 1, 3);
        Row controlsRow = controlsTable.addRow("data");
        Cell rppCell = controlsRow.addCell();
        rppCell.addContent(T_rpp);
        Select rppSelect = rppCell.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == this.getParameterRpp(), i, Integer.toString(i));
        }
        Cell sortCell = controlsRow.addCell();
        try {
            sortCell.addContent(T_sort_by);
            Select sortSelect = sortCell.addSelect("sort_by");
            sortSelect.addOption(false, 0, T_sort_by_relevance);
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.isVisible()) continue;
                sortSelect.addOption(so.getNumber() == this.getParameterSortBy(), so.getNumber(), AbstractSearch.message((String)("xmlui.ArtifactBrowser.AbstractSearch.sort_by." + so.getName())));
            }
        }
        catch (SortException se) {
            throw new WingException("Unable to get sort options", (Throwable)se);
        }
        Cell orderCell = controlsRow.addCell();
        orderCell.addContent(T_order);
        Select orderSelect = orderCell.addSelect("order");
        orderSelect.addOption("ASC".equals(this.getParameterOrder()), "ASC", T_order_asc);
        orderSelect.addOption("DESC".equals(this.getParameterOrder()), "DESC", T_order_desc);
    }

    protected void logSearch() {
        int countCommunities = 0;
        int countCollections = 0;
        int countItems = 0;
        for (Object type : this.queryResults.getHitTypes()) {
            if (!(type instanceof Integer)) continue;
            switch ((Integer)type) {
                case 2: {
                    ++countItems;
                    break;
                }
                case 3: {
                    ++countCollections;
                    break;
                }
                case 4: {
                    ++countCommunities;
                }
            }
        }
        String logInfo = "";
        try {
            DSpaceObject dsoScope = this.getScope();
            if (dsoScope instanceof Collection) {
                logInfo = "collection_id=" + dsoScope.getID() + ",";
            } else if (dsoScope instanceof Community) {
                logInfo = "community_id=" + dsoScope.getID() + ",";
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"search", (String)(logInfo + "query=\"" + this.queryArgs.getQuery() + "\",results=(" + countCommunities + "," + countCollections + "," + countItems + ")")));
    }
}

