/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.browse.BrowseItem;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSpaceObjectManager
implements ObjectManager {
    private List<DSpaceObject> dsos = new ArrayList<DSpaceObject>();

    public boolean manageObject(Object object) throws WingException {
        if (object instanceof BrowseItem) {
            this.dsos.add((DSpaceObject)((BrowseItem)object));
            return true;
        }
        if (object instanceof Item) {
            this.dsos.add((DSpaceObject)((Item)object));
            return true;
        }
        if (object instanceof Collection) {
            this.dsos.add((DSpaceObject)((Collection)object));
            return true;
        }
        if (object instanceof Community) {
            this.dsos.add((DSpaceObject)((Community)object));
            return true;
        }
        return false;
    }

    public String getObjectURL(Object object) throws WingException {
        if (object instanceof DSpaceObject) {
            DSpaceObject dso = (DSpaceObject)object;
            String handle = dso.getHandle();
            if (handle != null) {
                return "/metadata/handle/" + handle + "/mets.xml";
            }
            if (dso instanceof Item || dso instanceof BrowseItem) {
                return "/metadata/internal/item/" + dso.getID() + "/mets.xml";
            }
            if (object instanceof Collection) {
                return "/metadata/internal/collection/" + dso.getID() + "/mets.xml";
            }
            if (object instanceof Community) {
                return "/metadata/internal/community/" + dso.getID() + "/mets.xml";
            }
        }
        return null;
    }

    public String getObjectType(Object object) throws WingException {
        if (object instanceof Item || object instanceof BrowseItem) {
            return "DSpace Item";
        }
        if (object instanceof Collection) {
            return "DSpace Collection";
        }
        if (object instanceof Community) {
            return "DSpace Community";
        }
        return null;
    }

    public String getRepositoryIdentifier(Object object) throws WingException {
        return ConfigurationManager.getProperty((String)"handle.prefix");
    }

    public String getRepositoryURL(Object object) throws WingException {
        String handlePrefix = ConfigurationManager.getProperty((String)"handel.prefix");
        return "/metadata/internal/repository/" + handlePrefix + "/mets.xml";
    }

    public HashMap<String, String> getAllManagedRepositories() throws WingException {
        String handlePrefix = ConfigurationManager.getProperty((String)"handle.prefix");
        HashMap<String, String> allRepositories = new HashMap<String, String>();
        allRepositories.put(handlePrefix, "/metadata/internal/repository/" + handlePrefix + "/mets.xml");
        return allRepositories;
    }
}

