/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;

public class SetupCollectionHarvestingForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = SetupCollectionHarvestingForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_collection_trail = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.options_roles");
    private static final Message T_main_head = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.main_head");
    private static final Message T_options_harvest = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_title = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.title");
    private static final Message T_trail = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.trail");
    private static final Message T_label_source = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.label_source");
    private static final Message T_source_normal = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_normal");
    private static final Message T_source_harvested = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_harvested");
    private static final Message T_submit_return = SetupCollectionHarvestingForm.message((String)"xmlui.general.return");
    private static final Message T_submit_save = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.submit_save");
    private static final Message T_main_settings_head = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.main_settings_head");
    private static final Message T_options_head = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.options_head");
    private static final Message T_label_oai_provider = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.label_oai_provider");
    private static final Message T_label_setid = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.label_setid");
    private static final Message T_label_metadata_format = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.label_metadata_format");
    private static final Message T_help_oaiurl = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.help_oaiurl");
    private static final Message T_error_oaiurl = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.error_oaiurl");
    private static final Message T_help_oaisetid = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.help_oaisetid");
    private static final Message T_error_oaisetid = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.error_oaisetid");
    private static final Message T_label_harvest_level = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.label_harvest_level");
    private static final Message T_option_md_only = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.option_md_only");
    private static final Message T_option_md_and_ref = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.option_md_and_ref");
    private static final Message T_option_md_and_bs = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.option_md_and_bs");
    private static final Message T_submit_test = SetupCollectionHarvestingForm.message((String)"xmlui.administrative.collection.SetupCollectionHarvestingForm.submit_test");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int harvestLevelValue;
        String metadataFormatValue;
        String oaiSetIdValue;
        String oaiProviderValue;
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection thisCollection = Collection.find((Context)this.context, (int)collectionID);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        HarvestedCollection hc = HarvestedCollection.find((Context)this.context, (int)collectionID);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        String errorString = this.parameters.getParameter("errors", null);
        String[] errors = errorString.split(",");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (String error : errors) {
            String[] errorPieces = error.split(":", 2);
            if (errorPieces.length > 1) {
                errorMap.put(errorPieces[0], errorPieces[1]);
                continue;
            }
            errorMap.put(errorPieces[0], errorPieces[0]);
        }
        if (hc != null && request.getParameter("submit_test") == null) {
            oaiProviderValue = hc.getOaiSource();
            oaiSetIdValue = hc.getOaiSetId();
            metadataFormatValue = hc.getHarvestMetadataConfig();
            harvestLevelValue = hc.getHarvestType();
        } else {
            oaiProviderValue = this.parameters.getParameter("oaiProviderValue", "");
            oaiSetIdValue = this.parameters.getParameter("oaiSetAll", "");
            if (!"all".equals(oaiSetIdValue)) {
                oaiSetIdValue = this.parameters.getParameter("oaiSetIdValue", null);
            }
            metadataFormatValue = this.parameters.getParameter("metadataFormatValue", "");
            String harvestLevelString = this.parameters.getParameter("harvestLevelValue", "0");
            harvestLevelValue = harvestLevelString.length() == 0 ? 0 : Integer.parseInt(harvestLevelString);
        }
        Division main = body.addInteractiveDivision("collection-harvesting-setup", this.contextPath + "/admin/collection", "multipart", "primary administrative collection");
        main.setHead(T_main_head.parameterize(new Object[]{thisCollection.getMetadata("name")}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_harvesting", T_options_harvest);
        List harvestSource = main.addList("harvestSource", "form");
        harvestSource.addLabel(T_label_source);
        Radio source = harvestSource.addItem().addRadio("source");
        source.addOption(hc == null || harvestLevelValue == -1, "source_normal", T_source_normal);
        source.addOption(hc != null, "source_harvested", T_source_harvested);
        List settings = main.addList("harvestSettings", "form");
        settings.setHead(T_main_settings_head);
        settings.addLabel(T_label_oai_provider);
        Text oaiProvider = settings.addItem().addText("oai_provider");
        oaiProvider.setSize(40);
        oaiProvider.setValue(oaiProviderValue);
        oaiProvider.setHelp(T_help_oaiurl);
        if (errorMap.containsKey("invalidAddress")) {
            oaiProvider.addError((String)errorMap.get("invalidAddress"));
        }
        if (errorMap.containsKey("oai_provider")) {
            oaiProvider.addError(T_error_oaiurl);
        }
        settings.addLabel(T_label_setid);
        Composite oaiSetComp = settings.addItem().addComposite("oai-set-comp");
        Radio oaiSetSettingRadio = oaiSetComp.addRadio("oai-set-setting");
        oaiSetSettingRadio.addOption("all".equals(oaiSetIdValue) || oaiSetIdValue == null, "all", "All sets");
        oaiSetSettingRadio.addOption(!"all".equals(oaiSetIdValue) && oaiSetIdValue != null, "specific", "Specific sets");
        Text oaiSetId = oaiSetComp.addText("oai_setid");
        oaiSetId.setSize(40);
        if (!"all".equals(oaiSetIdValue) && oaiSetIdValue != null) {
            oaiSetId.setValue(oaiSetIdValue);
        }
        oaiSetId.setHelp(T_help_oaisetid);
        if (errorMap.containsKey("noSuchSet")) {
            oaiSetId.addError((String)errorMap.get("noSuchSet"));
        }
        if (errorMap.containsKey("oai_setid")) {
            oaiSetId.addError(T_error_oaisetid);
        }
        settings.addLabel(T_label_metadata_format);
        Select metadataFormat = settings.addItem().addSelect("metadata_format");
        if (errorMap.containsKey("oreNotSupported")) {
            metadataFormat.addError((String)errorMap.get("oreNotSupported"));
        }
        if (errorMap.containsKey("metadataNotSupported")) {
            metadataFormat.addError((String)errorMap.get("metadataNotSupported"));
        }
        String metaString = "harvester.oai.metadataformats.";
        Enumeration pe = ConfigurationManager.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(metaString)) continue;
            String metadataString = ConfigurationManager.getProperty((String)key);
            String metadataKey = key.substring(metaString.length());
            String displayName = metadataString.indexOf(44) != -1 ? metadataString.substring(metadataString.indexOf(44) + 1) : metadataKey + "(" + metadataString + ")";
            metadataFormat.addOption(metadataKey.equalsIgnoreCase(metadataFormatValue), metadataKey, displayName);
        }
        settings.addLabel();
        Item harvestButtons = settings.addItem();
        harvestButtons.addButton("submit_test").setValue(T_submit_test);
        List harvestOptions = main.addList("harvestOptions", "form");
        harvestOptions.setHead(T_options_head);
        harvestOptions.addLabel(T_label_harvest_level);
        Radio harvestLevel = harvestOptions.addItem().addRadio("harvest_level");
        harvestLevel.addOption(harvestLevelValue == 1, 1, T_option_md_only);
        harvestLevel.addOption(harvestLevelValue == 2, 2, T_option_md_and_ref);
        harvestLevel.addOption(harvestLevelValue != 1 && harvestLevelValue != 2, 3, T_option_md_and_bs);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_save);
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

